/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.waveFunction;

import edu.davidson.chm.waveFunction.WaveFunction;

public class HydrogenicWaveFunction
extends WaveFunction {
    private final double RES = 1.0E-15;
    private final double ln2 = 0.69314718056;
    int n;
    int l;
    int m;
    double[] factorials = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.7178291212E12, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23, 1.5511210043330986E25, 4.0329146112660565E26, 1.0888869450418352E28, 3.0488834461171384E29, 8.841761993739701E30, 2.6525285981219103E32};

    public HydrogenicWaveFunction() {
    }

    public HydrogenicWaveFunction(int _n, int _l, int _m) {
        this.n = _n > 0 ? _n : 1;
        this.l = _l >= 0 && _l < this.n ? _l : 0;
        this.m = Math.abs(_m) <= this.l ? _m : 0;
    }

    public double[] getAngular(double theta, double phi) {
        double[] _wf = new double[2];
        double norm = Math.sqrt((double)(2 * this.l + 1) * this.factorial(this.l - this.m) / (this.factorial(this.l + this.m) * 4.0 * Math.PI));
        double _THETA = 0.0;
        _THETA = this.l == 0 ? Math.sqrt(0.07957747154594767) : this.legendre(this.l, this.m, Math.cos(theta)) * norm;
        if (this.m == 0) {
            _wf[0] = _THETA;
            _wf[1] = 0.0;
        } else {
            _wf[0] = _THETA * Math.cos((double)this.m * phi);
            _wf[1] = _THETA * Math.sin((double)this.m * phi);
        }
        if (Math.abs(_wf[0]) < 1.0E-15) {
            _wf[0] = 0.0;
        }
        if (Math.abs(_wf[1]) < 1.0E-15) {
            _wf[1] = 0.0;
        }
        return _wf;
    }

    public int getN() {
        return this.n;
    }

    public int getL() {
        return this.l;
    }

    public int getM() {
        return this.m;
    }

    public double getMaxR(double _fraction) {
        if (_fraction > 0.0 && _fraction < 1.0) {
            return (double)this.n * (-Math.log(_fraction) + (double)this.n * (1.0 + 0.5 * Math.log(this.n)));
        }
        return 3.0;
    }

    public double getRadial(double x) {
        double f1 = this.factorial(this.n - this.l - 1);
        double f2 = this.factorial(this.n + this.l);
        double norm = 2.0 / (double)(this.n * this.n) * Math.sqrt(f1 / f2);
        if (this.n == 1) {
            return 2.0 * Math.exp(-x);
        }
        if (this.n == 2) {
            if (this.l == 0) {
                return (1.0 - x / 2.0) * Math.exp(-x / 2.0) / Math.sqrt(2.0);
            }
            return x * Math.exp(-x / 2.0) / Math.sqrt(24.0);
        }
        return norm * Math.pow(2.0 * x / (double)this.n, this.l) * Math.exp(-x / (double)this.n) * this.laguerre(2 * this.l + 1, this.n - this.l - 1, 2.0 * x / (double)this.n);
    }

    public double[] getValue(double x, double theta, double phi) {
        double[] _psi = new double[2];
        double[] _a = this.getAngular(theta, phi);
        double _rad = this.getRadial(x);
        _psi[0] = _rad * _a[0];
        _psi[1] = _rad * _a[1];
        if (Math.abs(_psi[0]) < 1.0E-15) {
            _psi[0] = 0.0;
        }
        if (Math.abs(_psi[1]) < 1.0E-15) {
            _psi[1] = 0.0;
        }
        return _psi;
    }

    public double[] getValueXYZ(double _x, double _y, double _z) {
        double _r = Math.sqrt(_x * _x + _y * _y + _z * _z);
        double _theta = 0.0;
        if (_r > 0.0) {
            _theta = Math.acos(_z / _r);
        }
        double _phi = Math.atan2(_y, _x);
        return this.getValue(_r, _theta, _phi);
    }

    public void setNLM(int _n, int _l, int _m) {
        this.n = _n > 0 ? _n : 1;
        this.l = _l >= 0 && _l < this.n ? _l : 0;
        this.m = Math.abs(_m) <= this.l ? _m : 0;
    }

    private double factorial(int _val) {
        if (_val < 0) {
            return 1.0;
        }
        double fac = 1.0;
        fac = _val <= 30 ? this.factorials[_val] : Math.pow(_val, _val) * Math.exp(-_val) * Math.sqrt(Math.PI * 2 * (double)_val);
        return fac;
    }

    private double laguerre(int a, int b, double x) {
        if (b < 1) {
            return 1.0;
        }
        if (b < 2) {
            return 1.0 + (double)a - x;
        }
        if (b < 3) {
            return 1.0 + 0.5 * (double)a * (3.0 + (double)a) - x * (2.0 + (double)a - 0.5 * x);
        }
        double A = 1.0 + (double)a - x;
        double B = 1.0 + 0.5 * (double)a * (3.0 + (double)a) - x * (2.0 + (double)a - 0.5 * x);
        double C = 0.0;
        for (int i = 3; i <= b; ++i) {
            double _i = i;
            C = ((2.0 * _i + (double)a - 1.0 - x) * B - (_i + (double)a - 1.0) * A) / _i;
            A = B;
            B = C;
        }
        return C;
    }

    private double legendre(int L, int _M, double X) {
        int M = Math.abs(_M);
        int LM = L - M;
        if (M > L) {
            return 0.0;
        }
        if (L == 0) {
            return 1.0;
        }
        if (X < 0.0) {
            if (LM % 2 == 1) {
                return -this.legendre(L, M, -X);
            }
            return this.legendre(L, M, -X);
        }
        double X2 = X * X;
        double YY = 1.0 - X2;
        double Y = Math.sqrt(YY);
        if (L == 1) {
            if (M == 0) {
                return X;
            }
            return Y;
        }
        if (L == 2) {
            if (M == 0) {
                return 1.5 * X2 - 0.5;
            }
            if (M == 1) {
                return 3.0 * X * Y;
            }
            return 3.0 * YY;
        }
        double fM = M;
        if (L == M) {
            return Math.exp(this.logGamma(2.0 * fM + 1.0) - fM * 0.69314718056 - this.logGamma(fM + 1.0)) * Math.pow(Y, fM);
        }
        int M2 = M * M;
        double S2 = 0.0;
        double S1 = Math.exp(0.5 * this.logGamma(2.0 * fM + 1.0) - fM * 0.69314718056 - this.logGamma(fM + 1.0)) * Math.pow(Y, fM);
        double T = 2.0 * fM + 1.0;
        double root = Math.sqrt(T);
        double mRoot = 0.0;
        double Snm = 0.0;
        for (int i = M + 1; i <= L; ++i) {
            Snm = (T * X * S1 - mRoot * S2) / root;
            T += 2.0;
            mRoot = root;
            root = Math.sqrt((i + 1) * (i + 1) - M2);
            S2 = S1;
            S1 = Snm;
        }
        return Math.exp(0.5 * (this.logGamma(this.l + this.m + 1) - this.logGamma(this.l - this.m + 1))) * Snm;
    }

    private double logGamma(double X) {
        double YY = 1.0 / (X * X);
        double con = 0.918938533205;
        double[] b = new double[]{0.0, 0.0833333333333, -0.00277777777778, 7.93650793651E-4, -5.95238095238E-4, 8.41750841751E-4};
        double sum = 0.0;
        if (X > 10.0) {
            sum = (X - 0.5) * Math.log(X) - X * con;
            double tmp = X;
            for (int k = 1; k <= 5; ++k) {
                sum += b[k] * (tmp *= YY);
            }
            return sum;
        }
        if (X > 0.0) {
            double X1 = X - 1.0;
            int X11 = (int)Math.floor((double)11 - X1);
            double X10 = X1 + (double)X11;
            sum = 0.0;
            for (int k = 1; k <= X11 - 1; ++k) {
                sum -= Math.log(X10 - (double)k);
            }
            return sum + this.logGamma(X10);
        }
        return 0.0;
    }
}

