/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.waveFunction;

import edu.davidson.chm.waveFunction.HydrogenicWaveFunction;
import edu.davidson.chm.waveFunction.WaveFunction;
import java.util.Vector;

public class HybridWaveFunction
extends WaveFunction {
    private final double RES = 1.0E-15;
    Vector waveFunctions = new Vector();
    Vector coefReal = new Vector();
    Vector coefImag = new Vector();
    double norm = 1.0;

    public HybridWaveFunction() {
    }

    public HybridWaveFunction(WaveFunction _waveFunction, double _coefReal, double _coefImag) {
        this.waveFunctions.addElement(_waveFunction);
        if (_coefReal != 0.0 || _coefImag != 0.0) {
            this.coefReal.addElement(new Double(_coefReal));
            this.coefImag.addElement(new Double(_coefImag));
            this.norm = 1.0 / Math.sqrt(_coefReal * _coefReal + _coefImag * _coefImag);
        } else {
            this.coefReal.addElement(new Double(1.0));
            this.coefImag.addElement(new Double(0.0));
            this.norm = 1.0;
        }
    }

    public void addNML(int _n, int _l, int _m, double _coefReal, double _coefImag) {
        this.waveFunctions.addElement(new HydrogenicWaveFunction(_n, _l, _m));
        if (_coefReal == 0.0 && _coefImag == 0.0) {
            this.coefReal.addElement(new Double(1.0));
            this.coefImag.addElement(new Double(0.0));
        } else {
            this.coefReal.addElement(new Double(_coefReal));
            this.coefImag.addElement(new Double(_coefImag));
        }
        double[] _cR = this.getCoefReal();
        double[] _cI = this.getCoefImag();
        double _tmp = 0.0;
        for (int i = 0; i < _cR.length; ++i) {
            _tmp += _cR[i] * _cR[i] + _cI[i] * _cI[i];
        }
        this.norm = 1.0 / Math.sqrt(_tmp);
    }

    public void addWaveFunction(WaveFunction _waveFunction, double _coefReal, double _coefImag) {
        this.waveFunctions.addElement(_waveFunction);
        if (_coefReal == 0.0 && _coefImag == 0.0) {
            this.coefReal.addElement(new Double(1.0));
            this.coefImag.addElement(new Double(0.0));
        } else {
            this.coefReal.addElement(new Double(_coefReal));
            this.coefImag.addElement(new Double(_coefImag));
        }
        double[] _cR = this.getCoefReal();
        double[] _cI = this.getCoefImag();
        double _tmp = 0.0;
        for (int i = 0; i < _cR.length; ++i) {
            _tmp += _cR[i] * _cR[i] + _cI[i] * _cI[i];
        }
        this.norm = 1.0 / Math.sqrt(_tmp);
    }

    public void clear() {
        this.waveFunctions.clear();
        this.coefReal.clear();
        this.coefImag.clear();
        this.norm = 1.0;
    }

    public double[] getValue(double _r, double _theta, double _phi) {
        WaveFunction[] _psi = this.getWaveFunctions();
        double[] _coefReal = this.getCoefReal();
        double[] _coefImag = this.getCoefImag();
        double[] _val = new double[2];
        double[] _tmp = new double[2];
        _val[0] = 0.0;
        _val[1] = 0.0;
        if (this.waveFunctions.size() == 0) {
            return _val;
        }
        for (int i = 0; i < _psi.length; ++i) {
            _tmp = _psi[i].getValue(_r, _theta, _phi);
            _val[0] = _val[0] + (_tmp[0] * _coefReal[i] - _tmp[1] * _coefImag[i]);
            _val[1] = _val[1] + (_tmp[1] * _coefReal[i] + _tmp[0] * _coefImag[i]);
        }
        _val[0] = _val[0] * this.norm;
        _val[1] = _val[1] * this.norm;
        if (Math.abs(_val[0]) < 1.0E-15) {
            _val[0] = 0.0;
        }
        if (Math.abs(_val[1]) < 1.0E-15) {
            _val[1] = 0.0;
        }
        return _val;
    }

    public double[] getValueXYZ(double _x, double _y, double _z) {
        double _r = Math.sqrt(_x * _x + _y * _y + _z * _z);
        double _theta = 0.0;
        if (_r > 0.0) {
            _theta = Math.acos(_z / _r);
        }
        double _phi = Math.atan2(_y, _x);
        return this.getValue(_r, _theta, _phi);
    }

    private double[] getCoefImag() {
        if (this.coefImag.size() == 0) {
            return null;
        }
        Object[] _double = new Double[this.coefImag.size()];
        this.coefImag.copyInto(_double);
        double[] _array = new double[_double.length];
        for (int i = 0; i < _double.length; ++i) {
            _array[i] = (Double)_double[i];
        }
        return _array;
    }

    private double[] getCoefReal() {
        if (this.coefReal.size() == 0) {
            return null;
        }
        Object[] _double = new Double[this.coefReal.size()];
        this.coefReal.copyInto(_double);
        double[] _array = new double[_double.length];
        for (int i = 0; i < _double.length; ++i) {
            _array[i] = (Double)_double[i];
        }
        return _array;
    }

    public double getMaxR(double _fraction) {
        WaveFunction[] _array = this.getWaveFunctions();
        double _maxR = 0.0;
        for (int i = 0; i < _array.length; ++i) {
            double _tmp = _array[i].getMaxR(_fraction);
            if (!(_tmp > _maxR)) continue;
            _maxR = _tmp;
        }
        return _maxR;
    }

    private WaveFunction[] getWaveFunctions() {
        if (this.waveFunctions.size() == 0) {
            return null;
        }
        Object[] _array = new WaveFunction[this.waveFunctions.size()];
        this.waveFunctions.copyInto(_array);
        return _array;
    }
}

