/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.waveFunction;

import edu.davidson.chm.waveFunction.WaveFunction;

class Gyy
extends WaveFunction {
    private double alpha = 1.0;
    private double scale = 1.0;
    private double constant = 1.0;
    private double exp = 1.0;

    public Gyy() {
    }

    public Gyy(double _alpha, double _scale) {
        this.alpha = _alpha > 0.0 ? _alpha : 1.0;
        this.scale = _scale > 0.0 ? _scale : 1.0;
        double tmp = Math.pow(this.alpha * this.scale * this.scale, 7.0);
        double pi3 = 31.006276680299816;
        this.constant = Math.pow(2048.0 * tmp / pi3, 0.25);
        this.exp = this.alpha * this.scale * this.scale;
    }

    public double getMaxR(double frac) {
        if (frac <= 0.0 || frac >= 1.0) {
            return 1.0;
        }
        return Math.sqrt((1.0 - Math.log(frac)) / this.exp);
    }

    public double[] getValue(double r, double theta, double phi) {
        double[] val = new double[2];
        double y = r * Math.sin(theta) * Math.sin(phi);
        val[0] = this.constant * y * y * Math.exp(-this.exp * r * r);
        val[1] = 0.0;
        return val;
    }

    public double[] getValueXYZ(double x, double y, double z) {
        double[] val = new double[2];
        double r2 = x * x + y * y + z * z;
        val[0] = this.constant * y * y * Math.exp(-this.exp * r2);
        val[1] = 0.0;
        return val;
    }
}

