/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.waveFunction;

import edu.davidson.chm.waveFunction.WaveFunction;

class Gs
extends WaveFunction {
    private double alpha = 1.0;
    private double scale = 1.0;
    private double constant = 1.0;
    private double exp = 1.0;

    public Gs() {
    }

    public Gs(double _alpha, double _scale) {
        this.alpha = _alpha > 0.0 ? _alpha : 1.0;
        this.scale = _scale > 0.0 ? _scale : 1.0;
        this.constant = Math.pow(2.0 * this.alpha * this.scale * this.scale / Math.PI, 0.75);
        this.exp = this.alpha * this.scale * this.scale;
    }

    public double getMaxR(double frac) {
        if (frac <= 0.0 || frac >= 1.0) {
            return 1.0;
        }
        return Math.sqrt(-Math.log(frac) / this.exp);
    }

    public double[] getValue(double r, double theta, double phi) {
        double[] val = new double[]{this.constant * Math.exp(-this.exp * r * r), 0.0};
        return val;
    }

    public double[] getValueXYZ(double x, double y, double z) {
        double[] val = new double[2];
        double r2 = x * x + y * y + z * z;
        val[0] = this.constant * Math.exp(-this.exp * r2);
        val[1] = 0.0;
        return val;
    }
}

