/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.waveFunction;

import edu.davidson.chm.waveFunction.Gs;
import edu.davidson.chm.waveFunction.Gx;
import edu.davidson.chm.waveFunction.Gxx;
import edu.davidson.chm.waveFunction.Gxy;
import edu.davidson.chm.waveFunction.Gxz;
import edu.davidson.chm.waveFunction.Gy;
import edu.davidson.chm.waveFunction.Gyy;
import edu.davidson.chm.waveFunction.Gyz;
import edu.davidson.chm.waveFunction.Gz;
import edu.davidson.chm.waveFunction.Gzz;
import edu.davidson.chm.waveFunction.WaveFunction;

public class Gaussian
extends WaveFunction {
    private int n = 1;
    private WaveFunction[] g = null;
    private double[] c = null;
    private int geo = 0;
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double z0 = 0.0;

    public Gaussian() {
        this.createArrays();
        this.geo = 0;
        this.setFunction(0, 1.0, 1.0, 1.0);
    }

    public Gaussian(int nbr, String geometry) {
        this.n = nbr > 0 ? nbr : 1;
        this.createArrays();
        this.setGeometry(geometry);
        this.setFunction(0, 1.0, 1.0, 1.0);
    }

    public Gaussian(int nbr, String geometry, double alpha, double scale, double coef) {
        this.n = nbr > 0 ? nbr : 1;
        this.createArrays();
        this.setGeometry(geometry);
        this.setFunction(0, alpha, scale, coef);
    }

    public double getMaxR(double frac) {
        double maxr = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double tmp = this.g[i].getMaxR(frac);
            if (!(tmp > maxr)) continue;
            maxr = tmp;
        }
        return maxr + Math.sqrt(this.x0 * this.x0 + this.y0 * this.y0 + this.z0 * this.z0);
    }

    public double[] getValue(double r, double theta, double phi) {
        double[] val = new double[]{0.0, 0.0};
        double x = r * Math.sin(theta) * Math.cos(phi) - this.x0;
        double y = r * Math.sin(theta) * Math.sin(phi) - this.y0;
        double z = r * Math.cos(theta) - this.z0;
        for (int i = 0; i < this.n; ++i) {
            double[] wf = this.g[i].getValueXYZ(x, y, z);
            val[0] = val[0] + this.c[i] * wf[0];
        }
        return val;
    }

    public double[] getValueXYZ(double x, double y, double z) {
        double[] val = new double[]{0.0, 0.0};
        double _x = x - this.x0;
        double _y = y - this.y0;
        double _z = z - this.z0;
        for (int i = 0; i < this.n; ++i) {
            double[] wf = this.g[i].getValueXYZ(_x, _y, _z);
            val[0] = val[0] + this.c[i] * wf[0];
        }
        return val;
    }

    public void setFunction(int id, double alpha, double scale, double coef) {
        if (id < 0 || id >= this.n) {
            System.out.println("G.addFunction:  Invalid function id");
            return;
        }
        switch (this.geo) {
            case 0: {
                this.g[id] = new Gs(alpha, scale);
                break;
            }
            case 1: {
                this.g[id] = new Gx(alpha, scale);
                break;
            }
            case 2: {
                this.g[id] = new Gy(alpha, scale);
                break;
            }
            case 3: {
                this.g[id] = new Gz(alpha, scale);
                break;
            }
            case 4: {
                this.g[id] = new Gxx(alpha, scale);
                break;
            }
            case 5: {
                this.g[id] = new Gxy(alpha, scale);
                break;
            }
            case 6: {
                this.g[id] = new Gxz(alpha, scale);
                break;
            }
            case 7: {
                this.g[id] = new Gyy(alpha, scale);
                break;
            }
            case 8: {
                this.g[id] = new Gyz(alpha, scale);
                break;
            }
            case 9: {
                this.g[id] = new Gzz(alpha, scale);
                break;
            }
            default: {
                this.g[id] = new Gs(alpha, scale);
            }
        }
        this.c[id] = coef;
    }

    public void setOrigin(double r, double theta, double phi) {
        this.x0 = r * Math.sin(theta) * Math.cos(phi);
        this.y0 = r * Math.sin(theta) * Math.sin(phi);
        this.z0 = r * Math.cos(theta);
    }

    public void setOriginXYZ(double x, double y, double z) {
        this.x0 = x;
        this.y0 = y;
        this.z0 = z;
    }

    protected void createArrays() {
        this.g = new WaveFunction[this.n];
        this.c = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.g[i] = new Gs(1.0, 1.0);
            this.c[i] = 0.0;
        }
    }

    protected void setGeometry(String geometry) {
        this.geo = geometry.equals("x") ? 1 : (geometry.equals("y") ? 2 : (geometry.equals("z") ? 3 : (geometry.equals("xx") ? 4 : (geometry.equals("xy") ? 5 : (geometry.equals("xz") ? 6 : (geometry.equals("yy") ? 7 : (geometry.equals("yz") ? 8 : (geometry.equals("zz") ? 9 : 0))))))));
    }
}

