/*
 * Decompiled with CFR 0.152.
 */
package thermometer;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import thermometer.DataFormat;

public class Thermometer
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    boolean isVertical;
    private Color liquidColor = new Color(255, 0, 0);
    private Color backgroundColor;
    private double tempLow = 0.0;
    private double tempHigh = 100.0;
    private double temp = 25.0;
    private boolean autoScaleMax = false;
    private boolean autoScaleMin = false;
    private int labelStyle = 3;
    private boolean isChanged = true;
    private int xDrag = 0;
    private int yDrag = 0;
    private boolean isDrag = false;
    private Rectangle liquid = new Rectangle(0, 0, 1, 1);
    private boolean isDragable = false;
    private double[][] ds = new double[1][1];
    private boolean isSet = false;
    private Rectangle bounds;
    private int thermWidth = 10;
    private int tickMajor = 10;
    private int tickMinor = 5;
    private int tickLength = 20;
    private int thermLength;
    private int bulbLength;
    private int xBulb;
    private int yBulb;
    private int bulbRad = 5;
    private int x;
    private int y;
    private int labelLength = 20;
    private int pos;
    private double range;
    private int tickNbr;
    private int tickMult;
    private int tickExp;
    private int tickMinorNbr;
    private int nMinor;
    private int nMajor;
    private double valMinor;
    private double valMajor;
    private double valLow;
    private int yTickLow;
    private Font font;
    private FontMetrics fontMetrics;
    private Font degFont;
    private FontMetrics degFontMetrics;
    private int labelOffset;
    private int labelShift;
    private String labelString;
    private int labelHeight;

    public Thermometer() {
        SApplet.addDataListener((Object)((Object)this));
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addData(SDataSource ds, int id, double[] xVal, double[] yVal) {
        this.setTemperature(yVal[0]);
    }

    public void addDatum(SDataSource ds, int id, double xVal, double yVal) {
        this.setTemperature(yVal);
    }

    public void autoScaleMax(boolean val) {
        this.autoScaleMax = val;
    }

    public void autoScaleMin(boolean val) {
        this.autoScaleMin = val;
    }

    public void clearSeries(int id) {
    }

    public void deleteSeries(int id) {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Thermometer, Version 1.1, Copyright 2000, David N. Blauch";
    }

    public SApplet getOwner() {
        return this;
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"AutoScaleMax", "boolean", "Autoscale the Maximum Temperature"}, {"AutoScaleMin", "boolean", "Autoscale the Minimum Temperature"}, {"BGGOLOR", "Color", "Background Color"}, {"MaxTemperature", "double", "Maximum Temperature"}, {"MinTemperature", "double", "Minimum Temperature"}, {"Vertical", "boolean", "Vertical Orientation"}};
        return pinfo;
    }

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public double getTemperature() {
        return this.temp;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.getTemperature();
        return this.ds;
    }

    public String[] getVarStrings() {
        return new String[]{"T"};
    }

    public void init() {
        try {
            this.isVertical = Boolean.valueOf(this.getParameter("Vertical", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.tempLow = Double.valueOf(this.getParameter("MinTemperature", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.tempHigh = Double.valueOf(this.getParameter("MaxTemperature", "100.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.backgroundColor = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.backgroundColor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.autoScaleMax = Boolean.valueOf(this.getParameter("AutoScaleMax", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.autoScaleMin = Boolean.valueOf(this.getParameter("AutoScaleMin", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.bounds.width, this.bounds.height);
            this.paintThermometer(g);
        }
        this.isChanged = false;
    }

    public void setBackgroundColor(String rgb) {
        this.backgroundColor = Color.decode(rgb);
        ((Component)((Object)this)).setBackground(this.backgroundColor);
        this.isChanged = true;
    }

    public void setDragable(boolean val) {
        this.isDragable = val;
    }

    public void setLabel(int val) {
        this.labelStyle = val >= 0 || val <= 6 ? val : 0;
    }

    public void setLiquidColor(String rgb) {
        this.liquidColor = Color.decode(rgb);
        this.isChanged = true;
    }

    public void setMaxTemperature(double val) {
        if (val > this.tempLow) {
            this.tempHigh = val;
            this.setScale();
            this.isChanged = true;
        }
    }

    public void setMinTemperature(double val) {
        if (val < this.tempHigh) {
            this.tempLow = val;
            this.setScale();
            this.isChanged = true;
        }
    }

    public void setMinMaxTemperature(double valMin, double valMax) {
        if (valMax > valMin) {
            this.tempLow = valMin;
            this.tempHigh = valMax;
            this.setScale();
            this.isChanged = true;
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setTemperature(double val) {
        if (val < this.tempLow && this.autoScaleMin) {
            this.tempLow = val;
            this.setScale();
            this.isChanged = true;
        } else if (val > this.tempHigh && this.autoScaleMax) {
            this.tempHigh = val;
            this.setScale();
            this.isChanged = true;
        }
        this.temp = val;
        this.updateTemperature(((Component)((Object)this)).getGraphics(), this.temp);
        this.updateDataConnections();
    }

    public void start() {
        this.setup();
    }

    public void stop() {
    }

    public boolean mouseDown(Event evt, int xpos, int ypos) {
        if (this.liquid.contains(xpos, ypos) && this.isDragable) {
            this.isDrag = true;
            this.xDrag = xpos;
            this.yDrag = ypos;
        }
        return true;
    }

    public boolean mouseUp(Event evt, int xpos, int ypos) {
        this.isDrag = false;
        return true;
    }

    public boolean mouseDrag(Event evt, int xpos, int ypos) {
        if (this.isDrag && this.isDragable) {
            double newTemp;
            if (this.isVertical) {
                int newpos = this.pos - this.yDrag + ypos;
                this.yDrag = ypos;
                newTemp = (double)(this.yTickLow - newpos) * this.valMajor / (double)this.nMajor + this.valLow;
            } else {
                int newpos = this.pos - this.xDrag + xpos;
                this.xDrag = xpos;
                newTemp = (double)(this.yTickLow - newpos) * this.valMajor / (double)this.nMajor + this.valLow;
            }
            this.setTemperature(newTemp);
        }
        return true;
    }

    private void setup() {
        this.bounds = ((Component)((Object)this)).getBounds();
        if (this.backgroundColor == null) {
            this.backgroundColor = ((Component)((Object)this)).getBackground();
        } else {
            ((Component)((Object)this)).setBackground(this.backgroundColor);
        }
        if (this.isVertical) {
            this.thermLength = this.bounds.height - 1 - 3 * this.thermWidth / 2;
            this.bulbLength = this.thermLength / 12;
            this.thermLength -= this.bulbLength - this.thermWidth;
            this.x = this.bulbRad;
            this.y = this.thermWidth / 2;
            this.xBulb = 0;
            this.yBulb = this.thermLength + this.thermWidth / 2;
        } else {
            this.thermLength = this.bounds.width - 2 * this.thermWidth;
            this.bulbLength = this.thermLength / 10;
            this.thermLength -= this.bulbLength - this.thermWidth;
            this.x = this.bulbRad;
            this.y = this.bulbLength + this.thermLength;
            this.xBulb = 0;
            this.yBulb = 0;
        }
        this.setLabels();
        this.setScale();
        this.isSet = true;
        this.updateDataConnections();
    }

    private void setScale() {
        this.tickNbr = 0;
        double[] tmpMult = new double[]{1.0, 2.0, 4.0, 5.0};
        int[] tmpMinor = new int[]{5, 4, 4, 5};
        this.range = this.tempHigh - this.tempLow;
        if (this.range == 0.0) {
            System.out.print("Thermometer.class:  Range is Zero\n");
            this.tempHigh += 1.0;
            this.range = this.tempHigh - this.tempLow;
        } else if (this.range < 0.0) {
            System.out.print("Thermometer.class:  Max Temperature lower then Min Temperature\n");
            this.range = this.tempHigh;
            this.tempHigh = this.tempLow;
            this.tempLow = this.range;
            this.range = this.tempHigh - this.tempLow;
        }
        for (int i = 0; i < tmpMult.length; ++i) {
            int tmpExp = (int)Math.floor(this.log(this.range / tmpMult[i]) - 0.05);
            int tmpNbr = (int)Math.ceil(this.range / (tmpMult[i] * Math.pow(10.0, tmpExp)));
            if (tmpNbr <= this.tickNbr) continue;
            this.tickNbr = tmpNbr;
            this.tickExp = tmpExp;
            this.tickMult = (int)tmpMult[i];
            this.tickMinorNbr = tmpMinor[i];
        }
        if (this.tickNbr == 0 || this.tickMinorNbr == 0 || this.tickMult == 0) {
            System.out.print(String.valueOf(new StringBuffer("Thermometer.class:  Scaling Error, min=").append(this.tempLow).append(" max=").append(this.tempHigh).append("\n")));
            return;
        }
        this.valMajor = (double)this.tickMult * Math.pow(10.0, this.tickExp);
        this.valMinor = this.valMajor / (double)this.tickMinorNbr;
        this.range = (double)this.tickNbr * this.valMajor;
        this.nMajor = (int)Math.floor((this.thermLength - this.labelHeight) / this.tickNbr);
        this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
        this.nMajor = this.tickMinorNbr * this.nMinor;
        this.valLow = this.valMajor * Math.floor(this.tempLow / this.valMajor);
        while (this.valLow + this.range < this.tempHigh) {
            ++this.tickNbr;
            if (this.tickNbr > 20) {
                System.out.print("Thermometer.class:  Too many scale expansions.\n");
                break;
            }
            this.range = (double)this.tickNbr * this.valMajor;
            this.nMajor = (int)Math.floor((this.thermLength - this.labelHeight) / this.tickNbr);
            this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
            this.nMajor = this.tickMinorNbr * this.nMinor;
            this.valLow = this.valMajor * Math.floor(this.tempLow / this.valMajor);
        }
        this.yTickLow = this.isVertical ? this.yBulb - (this.thermLength - this.labelHeight - this.tickNbr * this.nMajor) / 2 : this.yBulb + this.bulbLength + (this.thermLength - this.tickNbr * this.nMajor) / 2;
        this.tempLow = this.valLow;
        this.tempHigh = this.valLow + this.range;
    }

    private void setLabels() {
        this.font = ((Component)((Object)this)).getFont();
        this.fontMetrics = ((Component)((Object)this)).getFontMetrics(this.font);
        this.degFont = new Font(this.font.getName(), this.font.getStyle(), this.font.getSize() - 4);
        this.degFontMetrics = ((Component)((Object)this)).getFontMetrics(this.degFont);
        this.labelHeight = this.labelStyle != 0 && this.isVertical ? this.degFontMetrics.getHeight() : 0;
        if (this.isVertical) {
            this.labelOffset = this.fontMetrics.getAscent() / 2 - 1;
        } else {
            this.labelOffset = this.fontMetrics.charWidth('0');
            this.labelShift = this.fontMetrics.getAscent() / 2;
        }
    }

    private double log(double val) {
        return Math.log(val) / Math.log(10.0);
    }

    private void paintThermometer(Graphics g) {
        if (this.isVertical) {
            g.setColor(this.backgroundColor);
            g.fillRect(this.x, this.y, this.thermWidth, this.thermLength);
            g.setColor(this.liquidColor);
            g.fillRoundRect(this.xBulb, this.yBulb, this.thermWidth + 2 * this.bulbRad, this.bulbLength, 2 * this.bulbRad, 2 * this.bulbRad);
            this.pos = this.yTickLow - (int)Math.round((this.temp - this.valLow) * (double)this.nMajor / this.valMajor);
            if (this.pos > this.yBulb) {
                System.out.print("Thermometer.class:  Temperature too low\n");
                this.pos = this.yBulb;
            } else if (this.pos < this.y) {
                System.out.print("Thermometer.class:  Temperature too high\n");
                this.pos = this.y;
            } else {
                g.fillRect(this.x, this.pos, this.thermWidth, this.yBulb - this.pos);
                this.liquid = new Rectangle(this.x, this.pos, this.thermWidth, this.yBulb - this.pos + this.bulbLength);
            }
            g.setColor(Color.black);
            g.drawLine(this.x - 1, this.y, this.x - 1, this.y + this.thermLength);
            g.drawLine(this.x + this.thermWidth, this.y, this.x + this.thermWidth, this.y + this.thermLength);
            g.drawArc(this.x - 1, this.y - this.thermWidth / 2, this.thermWidth + 1, this.thermWidth + 1, 0, 180);
            g.drawRoundRect(this.xBulb, this.yBulb, this.thermWidth + 2 * this.bulbRad, this.bulbLength, 2 * this.bulbRad, 2 * this.bulbRad);
            g.setColor(this.liquidColor);
            g.drawLine(this.xBulb + this.bulbRad, this.yBulb, this.xBulb + this.bulbRad + this.thermWidth, this.yBulb);
            g.setColor(Color.black);
            for (int i = 0; i <= this.tickNbr; ++i) {
                int nbrLen;
                g.drawLine(this.x + this.thermWidth, this.yTickLow - i * this.nMajor, this.x + this.thermWidth + this.tickMajor, this.yTickLow - i * this.nMajor);
                if (i < this.tickNbr) {
                    for (int j = 1; j < this.tickMinorNbr; ++j) {
                        g.drawLine(this.x + this.thermWidth, this.yTickLow - i * this.nMajor - j * this.nMinor, this.x + this.thermWidth + this.tickMinor, this.yTickLow - i * this.nMajor - j * this.nMinor);
                    }
                }
                nbrLen = (nbrLen = (int)Math.ceil(Math.log(this.range + this.valLow) / DataFormat.ln10)) < 1 ? 3 : (nbrLen += 2);
                int nbrDec = (int)(-Math.floor(Math.log(this.range) / DataFormat.ln10 - 1.0));
                if (nbrDec < 0) {
                    nbrDec = 0;
                }
                g.drawString(DataFormat.formatDec(this.valLow + (double)i * this.valMajor, nbrLen + nbrDec, nbrDec), this.x + this.thermWidth + this.tickLength, this.yTickLow - i * this.nMajor + this.labelOffset);
            }
            g.setColor(Color.black);
            switch (this.labelStyle) {
                case 1: {
                    g.drawString("K", this.x + this.thermWidth + this.tickLength, this.y + this.labelOffset);
                    break;
                }
                case 2: {
                    g.drawString("Kelvin", this.x + this.thermWidth + this.tickLength, this.y + this.labelOffset);
                    break;
                }
                case 3: {
                    g.setFont(this.degFont);
                    g.drawString("o", this.x + this.thermWidth + this.tickLength, this.y + this.labelOffset / 4);
                    g.setFont(this.font);
                    g.drawString("C", this.x + this.thermWidth + this.tickLength + this.degFontMetrics.charWidth('o'), this.y + this.labelOffset);
                    break;
                }
                case 4: {
                    g.drawString("Celcius", this.x + this.thermWidth + this.tickLength, this.y + this.labelOffset);
                    break;
                }
                case 5: {
                    g.setFont(this.degFont);
                    g.drawString("o", this.x + this.thermWidth + this.tickLength, this.y + this.labelOffset / 4);
                    g.setFont(this.font);
                    g.drawString("F", this.x + this.thermWidth + this.tickLength + this.degFontMetrics.charWidth('o'), this.y + this.labelOffset);
                    break;
                }
                case 6: {
                    g.drawString("Fahrenheit", this.x + this.thermWidth + this.tickLength / 4, this.y + this.labelOffset);
                    break;
                }
            }
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(this.y - this.thermLength, this.x, this.thermLength, this.thermWidth);
            g.setColor(this.liquidColor);
            g.fillRoundRect(this.yBulb, this.xBulb, this.bulbLength, this.thermWidth + 2 * this.bulbRad, 2 * this.bulbRad, 2 * this.bulbRad);
            this.pos = this.yTickLow + (int)Math.round((this.temp - this.valLow) * (double)this.nMajor / this.valMajor);
            if (this.pos < this.yBulb + this.bulbLength) {
                System.out.print("Thermometer.class:  Temperature too low\n");
                this.pos = this.yBulb + this.bulbLength;
            } else if (this.pos > this.y) {
                System.out.print("Thermometer.class:  Temperature too high\n");
                this.pos = this.y;
            } else {
                g.fillRect(this.yBulb, this.x, this.pos - this.yBulb, this.thermWidth);
                this.liquid = new Rectangle(this.yBulb, this.x, this.pos - this.yBulb, this.thermWidth);
            }
            g.setColor(Color.black);
            g.drawLine(this.y - this.thermLength, this.x - 1, this.y, this.x - 1);
            g.drawLine(this.y - this.thermLength, this.x + this.thermWidth, this.y, this.x + this.thermWidth);
            g.drawArc(this.y - this.thermWidth / 2, this.x - 1, this.thermWidth + 1, this.thermWidth + 1, -90, 180);
            g.drawRoundRect(this.yBulb, this.xBulb, this.bulbLength, this.thermWidth + 2 * this.bulbRad, 2 * this.bulbRad, 2 * this.bulbRad);
            g.setColor(this.liquidColor);
            g.drawLine(this.yBulb + this.bulbLength, this.xBulb + this.bulbRad, this.yBulb + this.bulbLength, this.xBulb + this.bulbRad + this.thermWidth);
            g.setColor(Color.black);
            for (int i = 0; i <= this.tickNbr; ++i) {
                g.drawLine(this.yTickLow + i * this.nMajor, this.x + this.thermWidth, this.yTickLow + i * this.nMajor, this.x + this.thermWidth + this.tickMajor);
                if (i < this.tickNbr) {
                    for (int j = 1; j < this.tickMinorNbr; ++j) {
                        g.drawLine(this.yTickLow + i * this.nMajor + j * this.nMinor, this.x + this.thermWidth, this.yTickLow + i * this.nMajor + j * this.nMinor, this.x + this.thermWidth + this.tickMinor);
                    }
                }
                g.drawString(DataFormat.formatDec(this.valLow + (double)i * this.valMajor, 4, 1), this.yTickLow + i * this.nMajor - this.labelOffset, this.x + this.thermWidth + this.tickLength + this.labelShift);
            }
            g.setColor(Color.black);
            switch (this.labelStyle) {
                case 1: {
                    g.drawString("K", 0, this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
                case 2: {
                    g.drawString("Kelvin", 0, this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
                case 3: {
                    g.setFont(this.degFont);
                    g.drawString("o", 0, this.x + this.thermWidth + this.tickLength + this.labelShift / 4);
                    g.setFont(this.font);
                    g.drawString("C", this.degFontMetrics.charWidth('o'), this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
                case 4: {
                    g.drawString("Celcius", 0, this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
                case 5: {
                    g.setFont(this.degFont);
                    g.drawString("o", 0, this.x + this.thermWidth + this.tickLength + this.labelShift / 4);
                    g.setFont(this.font);
                    g.drawString("F", this.degFontMetrics.charWidth('o'), this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
                case 6: {
                    g.drawString("Fahrenheit", 0, this.x + this.thermWidth + this.tickLength + this.labelShift);
                    break;
                }
            }
        }
    }

    private void updateTemperature(Graphics g, double newTemp) {
        if (this.isChanged) {
            this.paint(g);
        } else if (this.isVertical) {
            g.setColor(this.liquidColor);
            this.pos = this.yTickLow - (int)Math.round((newTemp - this.valLow) * (double)this.nMajor / this.valMajor);
            if (this.pos > this.yBulb) {
                System.out.print("Thermometer.class:  Temperature too low\n");
                this.pos = this.yBulb;
            } else if (this.pos < this.y) {
                System.out.print("Thermometer.class:  Temperature too high\n");
                this.pos = this.y;
            } else {
                this.liquid = new Rectangle(this.x, this.pos, this.thermWidth, this.yBulb - this.pos + this.bulbLength);
                g.fillRect(this.x, this.pos, this.thermWidth, this.yBulb - this.pos);
            }
            g.setColor(this.backgroundColor);
            if (this.pos > this.y) {
                g.fillRect(this.x, this.y, this.thermWidth, this.pos - this.y);
            }
        } else {
            g.setColor(this.liquidColor);
            this.pos = this.yTickLow - (int)Math.round((newTemp - this.valLow) * (double)this.nMajor / this.valMajor);
            if (this.pos < this.yBulb + this.bulbLength) {
                System.out.print("Thermometer.class:  Temperature too low\n");
                this.pos = this.yBulb + this.bulbLength;
            } else if (this.pos > this.y) {
                System.out.print("Thermometer.class:  Temperature too high\n");
                this.pos = this.y;
            } else {
                this.liquid = new Rectangle(this.yBulb, this.x, this.pos - this.yBulb, this.thermWidth);
                g.fillRect(this.yBulb, this.x, this.pos - this.yBulb, this.thermWidth);
            }
            g.setColor(this.backgroundColor);
            if (this.pos < this.y) {
                g.fillRect(this.pos, this.x, this.y - this.pos, this.thermWidth);
            }
        }
    }
}

