/*
 * Decompiled with CFR 0.152.
 */
package spectrophotometer;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.Random;

public class Spectrophotometer
extends SApplet
implements SStepable,
SDataSource {
    boolean isStandalone = false;
    private Rectangle bounds;
    private int x;
    private int y;
    private int xSim;
    private int w;
    private int h;
    private int wSim;
    private int hDia;
    private int hm1;
    private Image image;
    private Graphics gImage;
    private Graphics gApplet;
    private int wD = 10;
    private int xD;
    private int[] dX = new int[5];
    private int[] dY = new int[5];
    private int[] sX = new int[5];
    private int[] sY = new int[5];
    private Color backgroundColor = ((Component)((Object)this)).getBackground();
    private Color sampleColor = new Color(127, 255, 255);
    private int cellX;
    private int cellXX;
    private int cellL;
    private int cellR;
    private int cellWidth;
    private double pathLength = 1.0;
    private boolean showCell = true;
    private double intensity = 10.0;
    private double speed = 50.0;
    private double wavelength = 400.0;
    private Color photonColor;
    private int max = 0;
    private int n = 0;
    private int[] pX = new int[1];
    private int[] pY = new int[1];
    private double[] pt = new double[1];
    private int dia = 6;
    private Random rnd = new Random();
    private double t0;
    private double t;
    private double ppcm = 33.0;
    private double conc = 1.0;
    private double molAbs = 0.199;
    private double bkgScatter = 0.0;
    private double bkgScatterA = (1.0 - this.bkgScatter) * (1.0 - this.bkgScatter);
    private double prob;
    private long cntS;
    private long cntD;
    private double refIntensity = this.intensity;
    private double scale = 0.0;
    private double scaleP = 0.0;
    private double dtime = 0.02;
    private double[][] ds = new double[1][6];
    private double add = 0.0;
    private boolean isSet = false;
    private double time0 = 0.0;
    private boolean timerOn = false;
    BorderLayout borderLayout1 = new BorderLayout();
    Panel controlPanel = new Panel();
    Button stopButton = new Button();
    Button resetButton = new Button();
    Button startTimerButton = new Button();
    Button startButton = new Button();
    Button stopTimerButton = new Button();
    GridLayout gridLayout1 = new GridLayout();
    private boolean autoTimer = false;
    private boolean autoTrigger = true;
    private int controlPosition = 2;
    private boolean showControls = false;

    public Spectrophotometer() {
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clock.addClockListener((SStepable)this);
    }

    public void destroy() {
        if (this.clock.isRunning()) {
            this.stopSimulation();
        }
    }

    public String getAppletInfo() {
        return "Spectrophotometer.class Version 1.0 Copyright 2000 David N. Blauch";
    }

    public Color getColor(double val) {
        float rd = 0.0f;
        float gn = 0.0f;
        float bl = 0.0f;
        if (val <= (double)440) {
            if (val < (double)380) {
                val = 380.0;
            }
            rd = (float)(1.0 * ((double)440 - val) / 60.0);
            gn = 0.0f;
            bl = 0.5f;
        } else if ((double)440 < val && val <= (double)475) {
            rd = 0.0f;
            gn = (float)(1.0 * (val - (double)440) / 70.0);
            bl = 0.5f;
        } else if ((double)475 < val && val <= (double)510) {
            rd = 0.0f;
            gn = 0.5f;
            bl = (float)(1.0 * ((double)510 - val) / 70.0);
        } else if ((double)510 < val && val <= (double)580) {
            rd = (float)(1.0 * (val - (double)510) / 70.0);
            gn = (float)(1.0 * (val - (double)440) / 140.0);
            bl = 0.0f;
        } else if ((double)580 < val && val <= (double)645) {
            rd = 1.0f;
            gn = (float)(1.0 * ((double)645 - val) / 65.0);
            bl = 0.0f;
        } else if ((double)645 < val) {
            if (val > (double)780) {
                val = 780.0;
            }
            rd = (float)(1.0 * ((double)780 - val) / 135.0);
            gn = 0.0f;
            bl = 0.0f;
        }
        return new Color(rd, gn, bl);
    }

    public boolean getIsSet() {
        return this.isSet;
    }

    public SApplet getOwner() {
        return this;
    }

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGColor", "Color", "Background Color"}, {"Concentration", "double", "Analyte concentration in mole/L"}, {"ControlPosition", "int", "Control Position: 0=North 1=East 2=South 3=West"}, {"Dt", "double", "Simulation time increment"}, {"Intensity", "double", "Light Source Intensity - photons/sec"}, {"LiquidColor", "Color", "Color of the sample solution"}, {"MolarAbsorptivity", "double", "Analyte molar absorptivity in L/(mole cm)"}, {"PathLength", "double", "Cell path length in centimeters"}, {"PixelsPerCM", "double", "Pixels per centimeter"}, {"ShowControls", "boolean", "Show the controls"}, {"Wavelength", "double", "Photon wavelength in nanometers"}};
        return pinfo;
    }

    public double getTime() {
        if (this.timerOn) {
            return this.t - this.time0;
        }
        return 0.0;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.getTime();
        this.ds[0][1] = this.cntS;
        this.ds[0][2] = this.cntD;
        if (this.ds[0][0] > 0.0) {
            this.ds[0][3] = (double)this.cntD / this.ds[0][0];
            this.ds[0][4] = this.ds[0][3] / this.refIntensity;
            this.ds[0][5] = this.ds[0][4] <= 0.0 ? 0.0 : -Math.log(this.ds[0][4]) / Math.log(10.0);
        } else {
            this.ds[0][5] = 0.0;
            this.ds[0][4] = 0.0;
            this.ds[0][3] = 0.0;
        }
        return this.ds;
    }

    public String[] getVarStrings() {
        return new String[]{"t", "s", "d", "I", "T", "A"};
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillPolygon(this.sX, this.sY, 5);
        g.fillPolygon(this.dX, this.dY, 5);
        this.paintRegion();
        this.gApplet.drawImage(this.image, this.x, this.y, (ImageObserver)((Object)this));
    }

    public void resetSimulation() {
        this.stopSimulation();
        this.clock.setDt(this.dtime);
        this.clock.setFPS(1.0 / this.dtime);
        this.clock.setTime(0.0);
        this.t = 0.0;
        this.timerOn = false;
        if (this.autoTimer) {
            this.autoTrigger = true;
        }
        this.initPhotons();
        this.cntS = 0L;
        this.cntD = 0L;
        this.add = 0.0;
        this.updateDataConnections();
        ((Component)((Object)this)).repaint();
    }

    public void setAutoTimer(boolean val) {
        this.autoTimer = val;
        if (val) {
            this.autoTrigger = true;
        }
    }

    public void setBackgroundColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Spectrophotometer.class:  Invalid string for setBackgroundColor\n");
            return;
        }
        this.backgroundColor = newColor;
        ((Component)((Object)this)).setBackground(this.backgroundColor);
    }

    public void setBackgroundScattering(double val) {
        if (val >= 0.0) {
            this.bkgScatter = val;
            this.bkgScatterA = (1.0 - this.bkgScatter) * (1.0 - this.bkgScatter);
        }
    }

    public void setConcentration(double val) {
        if (val >= 0.0) {
            this.conc = val * 1000.0;
            this.prob = this.molAbs * Math.log(10.0) * this.conc / this.ppcm;
            this.scaleP = Math.exp(-this.prob * (double)this.cellWidth);
        }
    }

    public void setIntensity(double val) {
        if (val > 0.0) {
            this.intensity = val;
        }
    }

    public void setLiquidColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Spectrophotometer.class:  Invalid string for setLiquidColor\n");
            return;
        }
        this.sampleColor = newColor;
    }

    public void setMolarAbsorptivity(double val) {
        if (val >= 0.0) {
            this.molAbs = val / 1000.0;
            this.prob = this.molAbs * Math.log(10.0) * this.conc / this.ppcm;
            this.scaleP = Math.exp(-this.prob * (double)this.cellWidth);
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setPathLength(double val) {
        if (val > 0.0 && val < (double)(this.w - 40) / this.ppcm) {
            this.pathLength = val;
            this.cellWidth = (int)Math.round(this.pathLength * this.ppcm);
            this.scaleP = Math.exp(-this.prob * (double)this.cellWidth);
            this.cellX = (this.w - this.cellWidth) / 2;
            this.cellXX = this.cellX + this.cellWidth;
            this.cellL = this.cellX - this.dia / 2;
            this.cellR = this.cellXX - this.dia / 2;
        }
    }

    public void setPhotonRadius(int val) {
        if (val > 0) {
            this.dia = 2 * val;
            this.cellL = this.cellX - val;
            this.cellR = this.cellXX - val;
        }
    }

    public void setPixelsPerCM(int val) {
        if (!this.clock.isRunning() && this.pathLength * (double)val < (double)(this.w - 20)) {
            this.ppcm = val;
            this.cellWidth = (int)Math.round(this.pathLength * this.ppcm);
            this.cellX = (this.w - this.cellWidth) / 2;
            this.cellXX = this.cellX + this.cellWidth;
            this.cellL = this.cellX - this.dia / 2;
            this.cellR = this.cellXX - this.dia / 2;
            this.prob = this.molAbs * Math.log(10.0) * this.conc / this.ppcm;
            this.scaleP = Math.exp(-this.prob * (double)this.cellWidth);
        }
    }

    public void setReferenceIntensity(double val) {
        this.refIntensity = val <= 0.0 ? this.intensity * this.bkgScatterA : val;
    }

    public void setScalingFactor(double val) {
        this.scale = val;
        this.scaleP = Math.exp(-this.prob * (double)this.cellWidth);
    }

    public void setSpeed(double val) {
        if (val > 0.0) {
            this.speed = val;
        }
    }

    public void setTimeIncrement(double val) {
        if (!this.clock.isRunning() && val > 0.0) {
            this.dtime = val;
            this.clock.setDt(this.dtime);
            this.clock.setFPS(1.0 / this.dtime);
        }
    }

    public void setWavelength(double val) {
        if (val >= 380.0 && val <= 780.0) {
            this.wavelength = val;
            this.photonColor = this.getColor(this.wavelength);
        }
    }

    public void start() {
        this.setup();
    }

    public void startSimulation() {
        if (!this.clock.isRunning()) {
            this.clock.startClock();
        }
    }

    public void startTimer() {
        this.timerOn = true;
        this.autoTrigger = false;
        this.time0 = this.t;
        this.cntS = 0L;
        this.cntD = 0L;
        this.updateDataConnections();
    }

    public void step(double dt, double tm) {
        double pr;
        this.t0 = this.t;
        this.t = tm + dt;
        for (int i = 0; i < this.n; ++i) {
            int dx = (int)Math.round((this.t - this.pt[i]) * this.speed);
            if (this.pX[i] > this.w) {
                if (this.autoTimer && this.autoTrigger) {
                    this.startTimer();
                }
                this.removePhoton(i--);
                ++this.cntD;
                continue;
            }
            if (this.showCell) {
                if (dx > this.cellL && dx <= this.cellR) {
                    if (this.pX[i] <= this.cellL) {
                        pr = (double)(dx - this.cellL) * this.prob;
                        if (this.rnd.nextDouble() <= this.getProb(pr)) {
                            this.removePhoton(i--);
                            continue;
                        }
                        if (this.rnd.nextDouble() <= this.bkgScatter) {
                            this.removePhoton(i--);
                            continue;
                        }
                    } else {
                        pr = (double)(dx - this.pX[i]) * this.prob;
                        if (this.rnd.nextDouble() <= this.getProb(pr)) {
                            this.removePhoton(i--);
                            continue;
                        }
                    }
                } else if (this.pX[i] > this.cellL && this.pX[i] <= this.cellR) {
                    pr = (double)(this.cellR - this.pX[i]) * this.prob;
                    if (this.rnd.nextDouble() <= this.getProb(pr)) {
                        this.removePhoton(i--);
                        continue;
                    }
                    if (this.rnd.nextDouble() <= this.bkgScatter) {
                        this.removePhoton(i--);
                        continue;
                    }
                }
            }
            this.pX[i] = dx;
        }
        this.add += (this.t - this.t0) * this.intensity;
        if (this.scale > 0.0 && this.timerOn) {
            this.cntS += (long)((int)Math.round(Math.floor(this.add) * this.scale));
            pr = Math.floor(this.add) * this.scale * this.scaleP * this.bkgScatterA;
            this.cntD = Math.floor(pr) + this.rnd.nextDouble() <= pr ? (this.cntD += (long)((int)(pr + 1.0))) : (this.cntD += (long)((int)pr));
        }
        while (this.add >= 1.0) {
            if (this.n >= this.max) {
                System.out.print("Maximum number of photons exceeded\n");
            } else {
                this.pt[this.n] = this.t;
                this.pX[this.n] = 0;
                this.pY[this.n++] = (int)Math.round((double)this.hDia * this.rnd.nextDouble());
                ++this.cntS;
            }
            this.add -= 1.0;
        }
        this.paintRegion();
        this.gApplet.drawImage(this.image, this.x, this.y, (ImageObserver)((Object)this));
        this.updateDataConnections();
    }

    public void stop() {
    }

    public void stopSimulation() {
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
    }

    public void stopTimer() {
        this.timerOn = false;
    }

    public void useCell(boolean val) {
        this.showCell = val;
    }

    public void init() {
        try {
            this.intensity = Double.valueOf(this.getParameter("Intensity", "10.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.intensity <= 0.0) {
            this.intensity = 10.0;
        }
        try {
            this.ppcm = Double.valueOf(this.getParameter("PixelsPerCM", "33"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ppcm <= 0.0) {
            this.ppcm = 33.0;
        }
        try {
            this.sampleColor = Color.decode(this.getParameter("LiquidColor", "#7FFFFF"));
        }
        catch (NumberFormatException e) {
            this.sampleColor = new Color(127, 255, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.backgroundColor = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.backgroundColor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.pathLength = Double.valueOf(this.getParameter("PathLength", "1.00"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pathLength <= 0.0) {
            this.pathLength = 1.0;
        }
        try {
            this.conc = Double.valueOf(this.getParameter("Concentration", "0.001"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conc = this.conc < 0.0 ? 1.0 : (this.conc *= 1000.0);
        try {
            this.molAbs = Double.valueOf(this.getParameter("MolarAbsorptivity", "199.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.molAbs = this.molAbs < 0.0 ? 0.199 : (this.molAbs /= 1000.0);
        try {
            this.wavelength = Double.valueOf(this.getParameter("Wavelength", "400.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.wavelength < (double)380) {
            this.wavelength = 380.0;
        } else if (this.wavelength > (double)780) {
            this.wavelength = 780.0;
        }
        try {
            this.dtime = Double.valueOf(this.getParameter("Dt", "0.02"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.controlPosition = Integer.valueOf(this.getParameter("ControlPosition", "2"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.controlPosition < 0 || this.controlPosition > 3) {
            this.controlPosition = 2;
        }
        try {
            this.bkgScatter = Double.valueOf(this.getParameter("BackgroundScattering", "0.01"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.bkgScatter < 0.0 || this.bkgScatter > 1.0) {
            this.bkgScatter = 0.01;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.showControls) {
            ((Container)((Object)this)).setLayout(this.borderLayout1);
            this.controlPanel.setLayout(this.gridLayout1);
            this.stopButton.setLabel("Stop");
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Spectrophotometer.this.stopButton_actionPerformed(e);
                }
            });
            this.resetButton.setLabel("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Spectrophotometer.this.resetButton_actionPerformed(e);
                }
            });
            this.startTimerButton.setLabel("Start Timer");
            this.startTimerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Spectrophotometer.this.startTimerButton_actionPerformed(e);
                }
            });
            this.startButton.setLabel("Start");
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Spectrophotometer.this.startButton_actionPerformed(e);
                }
            });
            this.stopTimerButton.setLabel("Stop Timer");
            this.stopTimerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Spectrophotometer.this.stopTimerButton_actionPerformed(e);
                }
            });
            switch (this.controlPosition) {
                case 0: {
                    this.gridLayout1.setRows(1);
                    this.gridLayout1.setColumns(5);
                    ((Container)((Object)this)).add(this.controlPanel, "North");
                    break;
                }
                case 1: {
                    this.gridLayout1.setRows(5);
                    this.gridLayout1.setColumns(1);
                    ((Container)((Object)this)).add(this.controlPanel, "East");
                    break;
                }
                case 2: {
                    this.gridLayout1.setRows(1);
                    this.gridLayout1.setColumns(5);
                    ((Container)((Object)this)).add(this.controlPanel, "South");
                    break;
                }
                case 3: {
                    this.gridLayout1.setRows(5);
                    this.gridLayout1.setColumns(1);
                    ((Container)((Object)this)).add(this.controlPanel, "West");
                    break;
                }
                default: {
                    System.out.println("Spectrophotometer.class:  Invalid control position in jbInit");
                    this.gridLayout1.setRows(1);
                    this.gridLayout1.setColumns(5);
                    ((Container)((Object)this)).add(this.controlPanel, "South");
                }
            }
            this.controlPanel.add((Component)this.startButton, null);
            this.controlPanel.add((Component)this.stopButton, null);
            this.controlPanel.add((Component)this.resetButton, null);
            this.controlPanel.add((Component)this.startTimerButton, null);
            this.controlPanel.add((Component)this.stopTimerButton, null);
        }
    }

    private void removePhoton(int val) {
        if (this.n <= 1) {
            this.n = 0;
        } else if (val == this.n) {
            --this.n;
        } else {
            --this.n;
            this.pt[val] = this.pt[this.n];
            this.pX[val] = this.pX[this.n];
            this.pY[val] = this.pY[this.n];
        }
    }

    private void setup() {
        this.bounds = ((Component)((Object)this)).getBounds();
        ((Component)((Object)this)).setBackground(this.backgroundColor);
        if (this.showControls) {
            switch (this.controlPosition) {
                case 0: {
                    this.xSim = 0;
                    this.y = this.startButton.getBounds().height;
                    this.wSim = this.bounds.width;
                    this.h = this.bounds.height - this.startButton.getBounds().height;
                    break;
                }
                case 1: {
                    this.xSim = 0;
                    this.y = 0;
                    this.wSim = this.bounds.width - this.startButton.getBounds().width;
                    this.h = this.bounds.height;
                    break;
                }
                case 2: {
                    this.xSim = 0;
                    this.y = 0;
                    this.wSim = this.bounds.width;
                    this.h = this.bounds.height - this.startButton.getBounds().height;
                    break;
                }
                case 3: {
                    this.xSim = this.startButton.getBounds().width;
                    this.y = 0;
                    this.wSim = this.bounds.width - this.startButton.getBounds().width;
                    this.h = this.bounds.height;
                    break;
                }
                default: {
                    System.out.println("Spectrophotometer.class:  Invalid control position in setup");
                    this.xSim = 0;
                    this.y = 0;
                    this.wSim = this.bounds.width;
                    this.h = this.bounds.height - this.startButton.getBounds().height;
                    break;
                }
            }
        } else {
            this.xSim = 0;
            this.y = 0;
            this.wSim = this.bounds.width;
            this.h = this.bounds.height;
        }
        this.x = this.xSim + this.wD;
        this.w = this.wSim - 2 * this.wD;
        this.hm1 = this.h - 1;
        this.hDia = this.h - this.dia - 1;
        this.image = ((Component)((Object)this)).createImage(this.w, this.h);
        this.gImage = this.image.getGraphics();
        this.gApplet = ((Component)((Object)this)).getGraphics();
        this.xD = this.xSim + this.wSim - this.wD;
        this.dX[0] = this.xSim + this.wSim - this.wD;
        this.dX[1] = this.xSim + this.wSim - this.wD;
        this.dX[2] = this.xSim + this.wSim;
        this.dX[3] = this.xSim + this.wSim;
        this.dX[4] = this.xSim + this.wSim - this.wD;
        this.dY[0] = this.y;
        this.dY[1] = this.y + this.h;
        this.dY[2] = this.y + this.h - this.wD;
        this.dY[3] = this.y + this.wD;
        this.dY[4] = this.y;
        this.sX[0] = this.xSim;
        this.sX[1] = this.xSim;
        this.sX[2] = this.xSim + this.wD;
        this.sX[3] = this.xSim + this.wD;
        this.sX[4] = this.xSim;
        this.sY[0] = this.y + this.wD;
        this.sY[1] = this.y + this.h - this.wD;
        this.sY[2] = this.y + this.h;
        this.sY[3] = this.y;
        this.sY[4] = this.y + this.wD;
        this.cellWidth = (int)Math.round(this.pathLength * this.ppcm);
        this.cellX = (this.w - this.cellWidth) / 2;
        this.cellXX = this.cellX + this.cellWidth;
        this.cellL = this.cellX - this.dia / 2;
        this.cellR = this.cellXX - this.dia / 2;
        this.photonColor = this.getColor(this.wavelength);
        this.stopSimulation();
        this.initPhotons();
        this.prob = this.molAbs * Math.log(10.0) * this.conc / this.ppcm;
        this.cntS = 0L;
        this.cntD = 0L;
        ((Component)((Object)this)).repaint();
        this.isSet = true;
    }

    private void initPhotons() {
        this.max = (int)Math.round(2.0 * this.intensity * (double)this.w / this.speed);
        this.pX = new int[this.max];
        this.pY = new int[this.max];
        this.pt = new double[this.max];
        this.n = 0;
    }

    private double getProb(double val) {
        if (val < 2.0E-4) {
            return val;
        }
        if (val < 0.0243) {
            return val * (1.0 - 0.5 * val);
        }
        if (val < 0.131) {
            return val * (1.0 + val * (-0.5 + val / 6.0));
        }
        return 1.0 - Math.exp(-val);
    }

    private void paintRegion() {
        this.gImage.clearRect(0, 0, this.w, this.h);
        if (this.showCell) {
            this.paintCell();
        }
        this.gImage.setColor(this.photonColor);
        for (int i = 0; i < this.n; ++i) {
            this.gImage.fillOval(this.pX[i], this.pY[i], this.dia, this.dia);
        }
    }

    private void paintCell() {
        this.gImage.setColor(this.sampleColor);
        this.gImage.fillRect(this.cellX, 0, this.cellWidth, this.h);
        this.gImage.setColor(Color.black);
        this.gImage.drawLine(this.cellX, 0, this.cellX, this.hm1);
        this.gImage.drawLine(this.cellXX, 0, this.cellXX, this.hm1);
        this.gImage.drawLine(this.cellX, this.hm1, this.cellXX, this.hm1);
    }

    void startButton_actionPerformed(ActionEvent e) {
        this.startSimulation();
    }

    void stopButton_actionPerformed(ActionEvent e) {
        this.stopSimulation();
    }

    void resetButton_actionPerformed(ActionEvent e) {
        this.resetSimulation();
    }

    void startTimerButton_actionPerformed(ActionEvent e) {
        this.startTimer();
    }

    void stopTimerButton_actionPerformed(ActionEvent e) {
        this.stopTimer();
    }
}

