/*
 * Decompiled with CFR 0.152.
 */
package piston3;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import piston3.DataFormat;

public class Piston3
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    private Color color1;
    private Color color2;
    private Color color3;
    private Color colorBkg;
    private Color colorBarrier;
    private Color colorWall;
    private int widthWall;
    private double volume = 0.0;
    private double volume1 = 0.0;
    private double volume2 = 0.0;
    private double volume3 = 0.0;
    private Image image;
    private Graphics gImage;
    private Graphics gApplet;
    private Rectangle bounds = null;
    private boolean isSet = false;
    private int xPiston;
    private int yPiston;
    private int xBarrier;
    private int xWall;
    private int yWall;
    private int heightBarrier;
    private int widthBarrier;
    private int yBarrier;
    private int yMinBarrier;
    private int widthPiston;
    private int heightPiston;
    private int widthScale = 40;
    private boolean showScale = true;
    private boolean scalePosition = true;
    private int xScale;
    private final int labelOffset = 2;
    private int labelHeight;
    private double scaleMax;
    private double valMajor;
    private int xMajor;
    private int xMinor;
    private int xLabel;
    private int nMajor;
    private int nMinor;
    private int majorWidth;
    private int minorWidth;
    private int tickNbr;
    private int tickMult;
    private int tickExp;
    private int tickMinorNbr;
    private int maxHeight;
    private double maxReading = 10.0;
    private double maxVolume = 10.0;
    private double minVolume = 0.0;
    private int downPos;
    private boolean isOnBarrier = false;
    private boolean isDragable = false;
    private boolean autoUpdate = true;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public Piston3() {
        SApplet.addDataListener((Object)((Object)this));
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        try {
            this.colorBkg = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBkg = null;
        }
        try {
            this.color1 = Color.decode(this.getParameter("Color1", ""));
        }
        catch (NumberFormatException e) {
            this.color1 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.color1 = null;
        }
        try {
            this.color2 = Color.decode(this.getParameter("Color2", ""));
        }
        catch (NumberFormatException e) {
            this.color2 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.color2 = null;
        }
        try {
            this.color3 = Color.decode(this.getParameter("Color3", ""));
        }
        catch (NumberFormatException e) {
            this.color3 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.color3 = null;
        }
        try {
            this.colorWall = Color.decode(this.getParameter("WallColor", "#804000"));
        }
        catch (NumberFormatException e) {
            this.colorWall = new Color(128, 64, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorWall = new Color(128, 64, 0);
        }
        try {
            this.colorBarrier = Color.decode(this.getParameter("BarrierColor", "#808040"));
        }
        catch (NumberFormatException e) {
            this.colorBarrier = new Color(128, 128, 64);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBarrier = new Color(128, 128, 64);
        }
        try {
            this.heightBarrier = Integer.parseInt(this.getParameter("HeightBarrier", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.heightBarrier = 20;
        }
        try {
            this.widthWall = Integer.parseInt(this.getParameter("WallWidth", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthWall = 20;
        }
        try {
            this.widthPiston = Integer.parseInt(this.getParameter("WidthPiston", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthPiston = 0;
        }
        try {
            this.heightPiston = Integer.parseInt(this.getParameter("HeightPiston", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.heightPiston = 0;
        }
        try {
            this.widthScale = Integer.parseInt(this.getParameter("ScaleWidth", "40"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthScale = 40;
        }
        try {
            this.showScale = Boolean.valueOf(this.getParameter("ShowScale", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showScale = false;
        }
        try {
            this.scalePosition = Boolean.valueOf(this.getParameter("ScalePosition", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.scalePosition = true;
        }
        try {
            this.maxVolume = Double.valueOf(this.getParameter("MaximumVolume", "10.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.maxVolume = 10.0;
        }
        try {
            this.minVolume = Double.valueOf(this.getParameter("MinimumVolume", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.minVolume = 0.0;
        }
        try {
            this.maxReading = Double.valueOf(this.getParameter("ScaleMaximum", "10.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.maxReading = 10.0;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
        this.setup();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Piston3.class  version 1.0  Copyright 2001  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BarrierColor", "String", "Color of the movable barrier"}, {"BarrierHeight", "int", "Height in pixels of the barrier"}, {"BGColor", "String", "Background Color"}, {"Color1", "String", "Color of Region 1"}, {"Color2", "String", "Color of Region 2"}, {"Color3", "String", "Color of Region 3"}, {"MaximumVolume", "double", "Maximum volume of the system"}, {"MinimumVolume", "double", "Minimum volume of the system"}, {"PistonHeight", "int", "Height in pixels of the piston"}, {"PistonWidth", "int", "Width in pixels of the piston"}, {"ScaleMaximum", "double", "Maximum scale value"}, {"ScalePosition", "boolean", "true=left   false=right"}, {"ScaleWidth", "int", "Width in pixels of the scale"}, {"ShowScale", "boolean", "Indicates if the scale is to be shown"}, {"WallColor", "String", "Color of the piston wall"}, {"WallWidth", "int", "width in pixels of wall"}};
        return pinfo;
    }

    public void addData(SDataSource ds, int id, double[] xVal, double[] yVal) {
        int _n = xVal.length;
        switch (_n) {
            case 4: {
                if (xVal[3] <= this.maxVolume && xVal[3] >= 0.0) {
                    this.volume3 = xVal[3];
                }
            }
            case 3: {
                if (xVal[2] <= this.maxVolume && xVal[2] >= 0.0) {
                    this.volume2 = xVal[2];
                }
            }
            case 2: {
                if (xVal[1] <= this.maxVolume && xVal[1] >= 0.0) {
                    this.volume1 = xVal[1];
                }
            }
            case 1: {
                if (!(xVal[0] <= this.maxVolume) || !(xVal[0] >= 0.0)) break;
                this.volume = xVal[0];
            }
        }
        double _vol = this.volume1 + this.volume2;
        if (_vol > this.maxVolume) {
            this.volume2 = this.maxVolume - this.volume1;
            this.volume3 = 0.0;
            _vol = this.maxVolume;
        }
        if ((_vol += this.volume3) > this.maxVolume) {
            this.volume3 = this.maxVolume - this.volume1 - this.volume2;
            _vol = this.maxVolume;
        }
        if (_vol > this.volume) {
            this.volume = _vol;
        } else if (_vol < this.volume) {
            this.volume3 = this.volume - this.volume1 - this.volume2;
        }
        this.updateDisplay();
    }

    public void addDatum(SDataSource ds, int id, double xVal, double yVal) {
        this.setVolume(xVal);
        if (!this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void clearSeries(int id) {
    }

    public void deleteSeries(int id) {
    }

    public SApplet getOwner() {
        return this;
    }

    public double[][] getVariables() {
        double[][] ds = new double[4][1];
        double[] _vol = this.getVolumes();
        for (int i = 0; i < 4; ++i) {
            ds[i][0] = _vol[i];
        }
        return ds;
    }

    public String[] getVarStrings() {
        return new String[]{"V", "V1", "V2", "V3"};
    }

    public double getVolume() {
        return this.volume;
    }

    public double getVolume(int _region) {
        switch (_region) {
            case 0: {
                return this.volume;
            }
            case 1: {
                return this.volume1;
            }
            case 2: {
                return this.volume2;
            }
            case 3: {
                return this.volume3;
            }
        }
        return 0.0;
    }

    public double[] getVolumes() {
        double[] _vol = new double[]{this.volume, this.volume1, this.volume2, this.volume3};
        return _vol;
    }

    public boolean mouseDown(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        if (_x >= this.xBarrier && _x <= this.xWall && _y >= this.yBarrier && _y <= this.yBarrier + this.heightBarrier) {
            this.downPos = _y;
            this.isOnBarrier = true;
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        int _newPos = _y - this.downPos + this.yBarrier;
        if (this.isOnBarrier && _newPos <= this.yMinBarrier && _newPos >= this.yPiston) {
            double _height = this.yWall - this.heightBarrier - _newPos;
            this.volume = this.maxVolume * _height / (double)this.maxHeight;
            this.setBarrier(_newPos);
            this.downPos = _y;
        }
        return true;
    }

    public boolean mouseUp(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        this.isOnBarrier = false;
        return true;
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            g.setColor(this.colorWall);
            g.fillRect(this.xPiston, this.yPiston, this.widthWall, this.heightPiston);
            g.fillRect(this.xWall, this.yPiston, this.widthWall, this.heightPiston);
            g.fillRect(this.xBarrier, this.yWall, this.widthBarrier, this.widthWall);
            if (this.showScale) {
                g.setColor(Color.black);
                for (int i = 0; i <= this.tickNbr; ++i) {
                    g.drawLine(this.xMajor, this.yWall - i * this.nMajor, this.xMajor + this.majorWidth, this.yWall - i * this.nMajor);
                    if (i < this.tickNbr) {
                        for (int j = 1; j < this.tickMinorNbr; ++j) {
                            g.drawLine(this.xMinor, this.yWall - i * this.nMajor - j * this.nMinor, this.xMinor + this.minorWidth, this.yWall - i * this.nMajor - j * this.nMinor);
                        }
                    }
                    if (i * this.nMajor + 2 + this.labelHeight >= this.yWall) continue;
                    int nbrLen = (int)Math.ceil(Math.log(this.scaleMax) / DataFormat.ln10);
                    nbrLen = nbrLen < 1 ? 3 : (nbrLen += 2);
                    int nbrDec = (int)(-Math.floor(Math.log(this.scaleMax) / DataFormat.ln10 - 1.0));
                    if (nbrDec < 0) {
                        nbrDec = 0;
                    }
                    g.drawString(DataFormat.formatDec((double)i * this.valMajor, nbrLen + nbrDec, nbrDec), this.xLabel, this.yWall - i * this.nMajor - 2);
                }
                int _i = 1;
                while (this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor > this.yPiston) {
                    g.drawLine(this.xMinor, this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor, this.xMinor + this.minorWidth, this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor);
                    ++_i;
                }
            }
            this.updateDisplay();
        }
    }

    public void setColor(int _region, String _color) {
        Color newColor;
        try {
            newColor = Color.decode(_color);
        }
        catch (NumberFormatException e) {
            return;
        }
        switch (_region) {
            case 1: {
                this.color1 = newColor;
                break;
            }
            case 2: {
                this.color2 = newColor;
                break;
            }
            case 3: {
                this.color3 = newColor;
                break;
            }
            default: {
                return;
            }
        }
        this.updateDisplay();
    }

    public void setAutoUpdate(boolean val) {
        this.autoUpdate = val;
    }

    public void setColor(int _region, int _red, int _green, int _blue) {
        if (_red > 255 || _red < 0 || _green > 255 || _green < 0 || _blue > 255 || _blue < 0) {
            return;
        }
        Color newColor = new Color(_red, _green, _blue);
        switch (_region) {
            case 1: {
                this.color1 = newColor;
                break;
            }
            case 2: {
                this.color2 = newColor;
                break;
            }
            case 3: {
                this.color3 = newColor;
                break;
            }
            default: {
                return;
            }
        }
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void setColors(String _color1, String _color2, String _color3) {
        Color newColor;
        try {
            newColor = Color.decode(_color1);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.color1 = newColor;
        try {
            newColor = Color.decode(_color2);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.color2 = newColor;
        try {
            newColor = Color.decode(_color3);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.color3 = newColor;
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void setColors(int _r1, int _g1, int _b1, int _r2, int _g2, int _b2, int _r3, int _g3, int _b3) {
        if (_r1 > 255 || _r1 < 0 || _g1 > 255 || _g1 < 0 || _b1 > 255 || _b1 < 0) {
            return;
        }
        if (_r2 > 255 || _r2 < 0 || _g2 > 255 || _g2 < 0 || _b2 > 255 || _b2 < 0) {
            return;
        }
        if (_r3 > 255 || _r3 < 0 || _g3 > 255 || _g3 < 0 || _b3 > 255 || _b3 < 0) {
            return;
        }
        this.color1 = new Color(_r1, _g1, _b1);
        this.color2 = new Color(_r2, _g2, _b2);
        this.color3 = new Color(_r3, _g3, _b3);
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void setDragable(boolean val) {
        this.isDragable = val;
    }

    public void setMaxVolume(double _volume) {
        if (_volume > 0.0 && _volume > this.minVolume) {
            this.maxVolume = _volume;
            this.setMinVolume(this.minVolume);
            if (this.volume > this.maxVolume) {
                this.volume = this.maxVolume;
            }
            this.setVolume(this.volume);
        }
    }

    public void setMaxVolume(double _volume, double _scaleReading) {
        if (_volume <= 0.0) {
            return;
        }
        double _valMinor = this.valMajor / (double)this.tickMinorNbr;
        double _nbr = (double)this.nMinor * _scaleReading / _valMinor;
        if (_nbr > (double)this.maxHeight || _nbr <= 0.0) {
            return;
        }
        this.maxVolume = _volume * (double)this.maxHeight / _nbr;
        this.setMinVolume(this.minVolume);
        if (this.volume > this.maxVolume) {
            this.volume = this.maxVolume;
        }
        this.setVolume(this.volume);
    }

    public void setMinVolume(double _volume) {
        if (_volume >= 0.0 && _volume < this.maxVolume) {
            this.minVolume = _volume;
            this.yMinBarrier = _volume == 0.0 ? this.yWall - this.heightBarrier : this.yWall - this.heightBarrier - (int)Math.round((double)this.maxHeight * _volume / this.maxVolume);
            if (this.volume < this.minVolume) {
                this.volume = this.minVolume;
            }
            this.setVolume(this.volume);
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setScaleMaximum(double _max) {
        if (_max > 0.0) {
            this.maxReading = _max;
            this.setScale();
            ((Component)((Object)this)).repaint();
        }
    }

    public void setVolume(double _volume) {
        if (_volume < this.minVolume || _volume > this.maxVolume) {
            return;
        }
        this.volume = _volume;
        if (this.volume1 > this.volume) {
            this.volume1 = this.volume;
            this.volume2 = 0.0;
            this.volume3 = 0.0;
        } else if (this.volume1 + this.volume2 > this.volume) {
            this.volume2 = this.volume - this.volume1;
            this.volume3 = 0.0;
        } else {
            this.volume3 = this.volume1 + this.volume2 + this.volume3 > this.volume ? this.volume - this.volume1 - this.volume2 : this.volume - this.volume1 - this.volume2;
        }
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void setVolume(int _region, double _volume) {
        if (_volume < this.minVolume || _volume > this.maxVolume) {
            return;
        }
        switch (_region) {
            case 1: {
                this.volume1 = _volume;
                break;
            }
            case 2: {
                this.volume2 = _volume;
                break;
            }
            case 3: {
                this.volume3 = _volume;
            }
        }
        double _vol = this.volume1 + this.volume2;
        if (_vol > this.maxVolume) {
            this.volume2 = this.maxVolume - this.volume1;
            this.volume3 = 0.0;
            _vol = this.maxVolume;
        }
        if ((_vol += this.volume3) > this.maxVolume) {
            this.volume3 = this.maxVolume - this.volume1 - this.volume2;
            _vol = this.maxVolume;
        }
        if (_vol > this.volume) {
            this.volume = _vol;
        } else if (_vol < this.volume) {
            this.volume3 = this.volume - this.volume1 - this.volume2;
        }
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void setVolumes(double _volume1, double _volume2, double _volume3) {
        if (_volume1 <= this.maxVolume && _volume1 >= 0.0) {
            this.volume1 = _volume1;
        }
        if (_volume2 <= this.maxVolume && _volume2 >= 0.0) {
            this.volume2 = _volume2;
        }
        if (_volume3 <= this.maxVolume && _volume3 >= 0.0) {
            this.volume3 = _volume3;
        }
        this.volume = this.volume1 + this.volume2;
        if (this.volume > this.maxVolume) {
            this.volume2 = this.maxVolume - this.volume1;
            this.volume3 = 0.0;
            this.volume = this.maxVolume;
        }
        this.volume += this.volume3;
        if (this.volume > this.maxVolume) {
            this.volume3 = this.maxVolume - this.volume1 - this.volume2;
            this.volume = this.maxVolume;
        }
        if (this.autoUpdate) {
            this.updateDisplay();
        }
    }

    public void updateDisplay() {
        int _prevTop;
        if (!this.isSet) {
            return;
        }
        if (this.gImage == null) {
            this.gImage = this.image.getGraphics();
        }
        this.gImage.setColor(this.colorBkg);
        this.gImage.fillRect(0, 0, this.widthBarrier, this.yWall);
        int _height = (int)Math.round((double)this.maxHeight * this.volume1 / this.maxVolume);
        int _top = this.yWall - _height;
        if (_height > 0) {
            this.gImage.setColor(this.color1);
            this.gImage.fillRect(0, _top, this.widthBarrier, _height);
        }
        if ((_height = (_prevTop = _top) - (_top = this.yWall - (int)Math.round((double)this.maxHeight * (this.volume2 + this.volume1) / this.maxVolume))) > 0) {
            this.gImage.setColor(this.color2);
            this.gImage.fillRect(0, _top, this.widthBarrier, _height);
        }
        if ((_height = (_prevTop = _top) - (_top = this.yWall - (int)Math.round((double)this.maxHeight * this.volume / this.maxVolume))) > 0) {
            this.gImage.setColor(this.color3);
            this.gImage.fillRect(0, _top, this.widthBarrier, _height);
        }
        this.yBarrier = _top - this.heightBarrier;
        this.gImage.setColor(this.colorBarrier);
        this.gImage.fillRect(0, this.yBarrier, this.widthBarrier, this.heightBarrier);
        if (this.gApplet == null) {
            this.gApplet = ((Component)((Object)this)).getGraphics();
        }
        this.gApplet.drawImage(this.image, this.xBarrier, 0, null);
    }

    private void setup() {
        this.bounds = ((Component)((Object)this)).getBounds();
        if (this.colorBkg == null) {
            this.colorBkg = ((Component)((Object)this)).getBackground();
        } else {
            ((Component)((Object)this)).setBackground(this.colorBkg);
        }
        if (this.color1 == null) {
            this.color1 = this.colorBkg;
        }
        if (this.color2 == null) {
            this.color2 = this.colorBkg;
        }
        if (this.color3 == null) {
            this.color3 = this.colorBkg;
        }
        if (this.showScale) {
            if (this.widthScale + this.widthPiston >= this.bounds.width) {
                this.widthPiston = 0;
            }
        } else if (this.widthPiston >= this.bounds.width) {
            this.widthPiston = 0;
        }
        if (this.heightPiston >= this.bounds.height) {
            this.heightPiston = 0;
        }
        if (this.widthPiston <= 0) {
            this.widthPiston = this.bounds.width;
            if (this.showScale) {
                this.widthPiston -= this.widthScale;
            }
        }
        if (this.heightPiston <= 0) {
            this.heightPiston = this.bounds.height;
        }
        this.xPiston = this.showScale ? (this.scalePosition ? (this.bounds.width - this.widthPiston + this.widthScale) / 2 : (this.bounds.width - this.widthPiston - this.widthScale) / 2) : (this.bounds.width - this.widthPiston) / 2;
        this.yPiston = (this.bounds.height - this.heightPiston) / 2;
        this.widthBarrier = this.widthPiston - 2 * this.widthWall;
        this.xBarrier = this.xPiston + this.widthWall;
        this.yBarrier = 10;
        this.xWall = this.xBarrier + this.widthBarrier;
        this.yWall = this.yPiston + this.heightPiston - this.widthWall;
        this.maxHeight = this.heightPiston - this.widthWall;
        this.setScale();
        this.majorWidth = this.widthScale;
        this.minorWidth = this.majorWidth / 7;
        if (this.minorWidth < 2) {
            this.minorWidth = 2;
        }
        if (this.scalePosition) {
            this.xMajor = this.xPiston - this.widthScale;
            this.xMinor = this.xMajor + this.majorWidth - this.minorWidth;
            this.xLabel = this.xMajor;
        } else {
            this.xMinor = this.xMajor = this.xWall + this.widthWall;
            this.xLabel = this.xMajor + this.minorWidth;
        }
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(((Component)((Object)this)).getFont());
        this.labelHeight = fontMetrics.getMaxAscent();
        this.setMinVolume(this.minVolume);
        this.setMaxVolume(this.maxVolume);
        this.image = ((Component)((Object)this)).createImage(this.widthBarrier, this.yWall);
        this.gImage = this.image.getGraphics();
        this.gApplet = ((Component)((Object)this)).getGraphics();
        this.isSet = true;
        ((Component)((Object)this)).repaint();
    }

    private void setBarrier(int _position) {
        if (_position <= this.yMinBarrier && _position >= this.yPiston) {
            this.yBarrier = _position;
            this.volume = this.maxVolume * (double)(this.yWall - this.yBarrier - this.heightBarrier) / (double)this.maxHeight;
            if (this.volume < this.volume1) {
                this.volume1 = this.volume;
                this.volume2 = 0.0;
                this.volume3 = 0.0;
            } else if (this.volume < this.volume1 + this.volume2) {
                this.volume2 = this.volume - this.volume1;
                this.volume3 = 0.0;
            } else {
                this.volume3 = this.volume - this.volume1 - this.volume2;
            }
            this.updateDataConnections();
            this.updateDisplay();
        }
    }

    private void setScale() {
        this.tickNbr = 0;
        double[] tmpMult = new double[]{1.0, 2.0, 4.0, 5.0};
        int[] tmpMinor = new int[]{5, 4, 4, 5};
        for (int i = 0; i < tmpMult.length; ++i) {
            int tmpExp = (int)Math.floor(this.log(this.maxReading / tmpMult[i]) - 0.05);
            int tmpNbr = (int)Math.ceil(this.maxReading / (tmpMult[i] * Math.pow(10.0, tmpExp)));
            if (tmpNbr <= this.tickNbr) continue;
            this.tickNbr = tmpNbr;
            this.tickExp = tmpExp;
            this.tickMult = (int)tmpMult[i];
            this.tickMinorNbr = tmpMinor[i];
        }
        if (this.tickNbr == 0 || this.tickMinorNbr == 0 || this.tickMult == 0) {
            System.out.println("Piston:  Scaling Error, max=".concat(String.valueOf(this.scaleMax)));
            return;
        }
        this.valMajor = (double)this.tickMult * Math.pow(10.0, this.tickExp);
        this.scaleMax = (double)this.tickNbr * this.valMajor;
        this.nMajor = (int)Math.floor((double)this.maxHeight / (double)this.tickNbr);
        this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
        this.nMajor = this.tickMinorNbr * this.nMinor;
        while ((double)this.maxHeight > (double)(this.nMajor * (this.tickNbr + 1))) {
            ++this.tickNbr;
            this.scaleMax = (double)this.tickNbr * this.valMajor;
            this.nMajor = (int)Math.floor((double)this.maxHeight / (double)this.tickNbr);
            this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
            this.nMajor = this.tickMinorNbr * this.nMinor;
        }
        this.maxReading = this.scaleMax;
    }

    private double log(double val) {
        return Math.log(val) / Math.log(10.0);
    }
}

