/*
 * Decompiled with CFR 0.152.
 */
package piston3;

public class DataFormat {
    static double ln10 = Math.log(10.0);

    public static String formatDec(double x, int nLength, int nDecimal) {
        String s = "";
        if ((x += Math.exp((double)(-nDecimal) * ln10) / 2.0) < 0.0) {
            s = "-";
            x = -x;
        }
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(Integer.toString((int)Math.floor(x))).concat(".")));
        double b = x - Math.floor(x);
        for (int i = 0; i < nDecimal; ++i) {
            s = String.valueOf(s).concat(String.valueOf(Integer.toString((int)Math.floor(b *= (double)10))));
            b -= Math.floor(b);
        }
        while (nLength > s.length()) {
            s = " ".concat(String.valueOf(s));
        }
        return s;
    }

    public static String formatSci(double x, int nLength, int nDecimal) {
        String s = "";
        if (x < 1.0E-99 && x > -1.0E-99) {
            s = "0.";
            for (int i = 0; i < nDecimal; ++i) {
                s = String.valueOf(s).concat("0");
            }
            s = String.valueOf(s).concat("E+00");
            return s;
        }
        int ex = (int)Math.floor(Math.log(Math.abs(x)) / ln10);
        double m = x * Math.exp((double)(-ex) * ln10);
        if (m + Math.exp((double)(-nDecimal) * ln10) / 2.0 >= (double)10) {
            m /= (double)10;
            ++ex;
        }
        s = String.valueOf(s).concat(String.valueOf(DataFormat.formatDec(m, nLength - 5, nDecimal)));
        if (ex >= 0) {
            s = String.valueOf(s).concat("E+");
        } else {
            s = String.valueOf(s).concat("E-");
            ex = Math.abs(ex);
        }
        String se = Integer.toString(ex);
        s = se.length() == 2 ? String.valueOf(s).concat(String.valueOf(se)) : String.valueOf(s).concat(String.valueOf("0".concat(String.valueOf(se))));
        while (nLength > s.length()) {
            s = " ".concat(String.valueOf(s));
        }
        return s;
    }

    public static boolean isValid(String nbr) {
        try {
            Double d = Double.valueOf(nbr);
        }
        catch (NumberFormatException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }
}

