/*
 * Decompiled with CFR 0.152.
 */
package piston;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import piston.DataFormat;

public class Piston
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    private Color colorBkg;
    private Color colorGas;
    private Color colorBarrier;
    private Color colorWall;
    private int widthWall;
    private double volume = 0.0;
    private Rectangle bounds = null;
    private Graphics graphics = null;
    private boolean isSet = false;
    private int xPiston;
    private int yPiston;
    private int xBarrier;
    private int xWall;
    private int yWall;
    private int heightBarrier;
    private int widthBarrier;
    private int yBarrier;
    private int yMinBarrier;
    private int widthPiston;
    private int heightPiston;
    private int widthScale = 40;
    private boolean showScale = true;
    private boolean scalePosition = true;
    private int xScale;
    private final int labelOffset = 2;
    private int labelHeight;
    private double scaleMax;
    private double valMajor;
    private int xMajor;
    private int xMinor;
    private int xLabel;
    private int nMajor;
    private int nMinor;
    private int majorWidth;
    private int minorWidth;
    private int tickNbr;
    private int tickMult;
    private int tickExp;
    private int tickMinorNbr;
    private int maxHeight;
    private double maxReading = 10.0;
    private double maxVolume = 10.0;
    private double minVolume = 0.0;
    private int downPos;
    private boolean isOnBarrier = false;
    private boolean isDragable = false;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public Piston() {
        SApplet.addDataListener((Object)((Object)this));
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        try {
            this.colorBkg = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBkg = null;
        }
        try {
            this.colorGas = Color.decode(this.getParameter("GasColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorGas = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorGas = null;
        }
        try {
            this.colorWall = Color.decode(this.getParameter("WallColor", "#804000"));
        }
        catch (NumberFormatException e) {
            this.colorWall = new Color(128, 64, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorWall = new Color(128, 64, 0);
        }
        try {
            this.colorBarrier = Color.decode(this.getParameter("BarrierColor", "#808040"));
        }
        catch (NumberFormatException e) {
            this.colorBarrier = new Color(128, 128, 64);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBarrier = new Color(128, 128, 64);
        }
        try {
            this.heightBarrier = Integer.parseInt(this.getParameter("HeightBarrier", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.heightBarrier = 20;
        }
        try {
            this.widthWall = Integer.parseInt(this.getParameter("WallWidth", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthWall = 20;
        }
        try {
            this.widthPiston = Integer.parseInt(this.getParameter("WidthPiston", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthPiston = 0;
        }
        try {
            this.heightPiston = Integer.parseInt(this.getParameter("HeightPiston", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.heightPiston = 0;
        }
        try {
            this.widthScale = Integer.parseInt(this.getParameter("ScaleWidth", "40"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.widthScale = 40;
        }
        try {
            this.showScale = Boolean.valueOf(this.getParameter("ShowScale", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showScale = false;
        }
        try {
            this.scalePosition = Boolean.valueOf(this.getParameter("ScalePosition", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.scalePosition = true;
        }
        try {
            this.maxVolume = Double.valueOf(this.getParameter("MaximumVolume", "10.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.maxVolume = 10.0;
        }
        try {
            this.minVolume = Double.valueOf(this.getParameter("MinimumVolume", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.minVolume = 0.0;
        }
        try {
            this.maxReading = Double.valueOf(this.getParameter("ScaleMaximum", "10.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.maxReading = 10.0;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
        this.setup();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Piston.class  version 1.01  Copyright 2001  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BarrierColor", "String", "Color of the movable barrier"}, {"BarrierHeight", "int", "Height in pixels of the barrier"}, {"BGColor", "String", "Background Color"}, {"GasColor", "String", "Color of the gas in the piston"}, {"MaximumVolume", "double", "Maximum volume of the system"}, {"MinimumVolume", "double", "Minimum volume of the system"}, {"PistonHeight", "int", "Height in pixels of the piston"}, {"PistonWidth", "int", "Width in pixels of the piston"}, {"ScaleMaximum", "double", "Maximum scale value"}, {"ScalePosition", "boolean", "true=left   false=right"}, {"ScaleWidth", "int", "Width in pixels of the scale"}, {"ShowScale", "boolean", "Indicates if the scale is to be shown"}, {"WallColor", "String", "Color of the piston wall"}, {"WallWidth", "int", "width in pixels of wall"}};
        return pinfo;
    }

    public void addData(SDataSource ds, int id, double[] xVal, double[] yVal) {
        this.setVolume(xVal[0]);
    }

    public void addDatum(SDataSource ds, int id, double xVal, double yVal) {
        this.setVolume(xVal);
    }

    public void clearSeries(int id) {
    }

    public void deleteSeries(int id) {
    }

    public SApplet getOwner() {
        return this;
    }

    public double[][] getVariables() {
        double[][] ds = new double[1][1];
        ds[0][0] = this.getVolume();
        return ds;
    }

    public String[] getVarStrings() {
        return new String[]{"V"};
    }

    public double getVolume() {
        return this.volume;
    }

    public boolean mouseDown(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        if (_x >= this.xBarrier && _x <= this.xWall && _y >= this.yBarrier && _y <= this.yBarrier + this.heightBarrier) {
            this.downPos = _y;
            this.isOnBarrier = true;
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        int _newPos = _y - this.downPos + this.yBarrier;
        if (this.isOnBarrier && _newPos <= this.yMinBarrier && _newPos >= this.yPiston) {
            double _height = this.yWall - this.heightBarrier - _newPos;
            this.volume = this.maxVolume * _height / (double)this.maxHeight;
            this.setBarrier(_newPos);
            this.downPos = _y;
        }
        return true;
    }

    public boolean mouseUp(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        this.isOnBarrier = false;
        return true;
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            g.setColor(this.colorWall);
            g.fillRect(this.xPiston, this.yPiston, this.widthWall, this.heightPiston);
            g.fillRect(this.xWall, this.yPiston, this.widthWall, this.heightPiston);
            g.fillRect(this.xBarrier, this.yWall, this.widthBarrier, this.widthWall);
            this.paintBarrier(g);
            if (this.showScale) {
                g.setColor(Color.black);
                for (int i = 0; i <= this.tickNbr; ++i) {
                    g.drawLine(this.xMajor, this.yWall - i * this.nMajor, this.xMajor + this.majorWidth, this.yWall - i * this.nMajor);
                    if (i < this.tickNbr) {
                        for (int j = 1; j < this.tickMinorNbr; ++j) {
                            g.drawLine(this.xMinor, this.yWall - i * this.nMajor - j * this.nMinor, this.xMinor + this.minorWidth, this.yWall - i * this.nMajor - j * this.nMinor);
                        }
                    }
                    if (i * this.nMajor + 2 + this.labelHeight >= this.yWall) continue;
                    int nbrLen = (int)Math.ceil(Math.log(this.scaleMax) / DataFormat.ln10);
                    nbrLen = nbrLen < 1 ? 3 : (nbrLen += 2);
                    int nbrDec = (int)(-Math.floor(Math.log(this.scaleMax) / DataFormat.ln10 - 1.0));
                    if (nbrDec < 0) {
                        nbrDec = 0;
                    }
                    g.drawString(DataFormat.formatDec((double)i * this.valMajor, nbrLen + nbrDec, nbrDec), this.xLabel, this.yWall - i * this.nMajor - 2);
                }
                int _i = 1;
                while (this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor > this.yPiston) {
                    g.drawLine(this.xMinor, this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor, this.xMinor + this.minorWidth, this.yWall - this.tickNbr * this.nMajor - _i * this.nMinor);
                    ++_i;
                }
            }
        }
    }

    public void setDragable(boolean val) {
        this.isDragable = val;
    }

    public void setMaxVolume(double _volume) {
        if (_volume > 0.0 && _volume > this.minVolume) {
            this.maxVolume = _volume;
            this.setMinVolume(this.minVolume);
            if (this.volume > this.maxVolume) {
                this.volume = this.maxVolume;
            }
            this.setVolume(this.volume);
        }
    }

    public void setMaxVolume(double _volume, double _scaleReading) {
        if (_volume <= 0.0) {
            return;
        }
        double _valMinor = this.valMajor / (double)this.tickMinorNbr;
        double _nbr = (double)this.nMinor * _scaleReading / _valMinor;
        if (_nbr > (double)this.maxHeight || _nbr <= 0.0) {
            return;
        }
        this.maxVolume = _volume * (double)this.maxHeight / _nbr;
        this.setMinVolume(this.minVolume);
        if (this.volume > this.maxVolume) {
            this.volume = this.maxVolume;
        }
        this.setVolume(this.volume);
    }

    public void setMinVolume(double _volume) {
        if (_volume >= 0.0 && _volume < this.maxVolume) {
            this.minVolume = _volume;
            this.yMinBarrier = _volume == 0.0 ? this.yWall - this.heightBarrier : this.yWall - this.heightBarrier - (int)Math.round((double)this.maxHeight * _volume / this.maxVolume);
            if (this.volume < this.minVolume) {
                this.volume = this.minVolume;
            }
            this.setVolume(this.volume);
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setScaleMaximum(double _max) {
        if (_max > 0.0) {
            this.maxReading = _max;
            this.setScale();
            this.updateDisplay();
        }
    }

    public void setVolume(double _volume) {
        if (_volume < this.minVolume || _volume > this.maxVolume) {
            return;
        }
        this.volume = _volume;
        int _height = (int)Math.round((double)this.maxHeight * _volume / this.maxVolume);
        this.setBarrier(this.yWall - this.heightBarrier - _height);
    }

    public void updateDisplay() {
        if (this.graphics == null) {
            this.graphics = ((Component)((Object)this)).getGraphics();
        }
        this.paintBarrier(this.graphics);
    }

    private void paintBarrier(Graphics g) {
        g.setColor(this.colorBkg);
        g.fillRect(this.xBarrier, 0, this.widthBarrier, this.yBarrier);
        g.setColor(this.colorBarrier);
        g.fillRect(this.xBarrier, this.yBarrier, this.widthBarrier, this.heightBarrier);
        g.setColor(this.colorGas);
        g.fillRect(this.xBarrier, this.yBarrier + this.heightBarrier, this.widthBarrier, this.yWall - this.yBarrier - this.heightBarrier);
    }

    private void setup() {
        this.bounds = ((Component)((Object)this)).getBounds();
        if (this.colorBkg == null) {
            this.colorBkg = ((Component)((Object)this)).getBackground();
        } else {
            ((Component)((Object)this)).setBackground(this.colorBkg);
        }
        if (this.colorGas == null) {
            this.colorGas = this.colorBkg;
        }
        if (this.showScale) {
            if (this.widthScale + this.widthPiston >= this.bounds.width) {
                this.widthPiston = 0;
            }
        } else if (this.widthPiston >= this.bounds.width) {
            this.widthPiston = 0;
        }
        if (this.heightPiston >= this.bounds.height) {
            this.heightPiston = 0;
        }
        if (this.widthPiston <= 0) {
            this.widthPiston = this.bounds.width;
            if (this.showScale) {
                this.widthPiston -= this.widthScale;
            }
        }
        if (this.heightPiston <= 0) {
            this.heightPiston = this.bounds.height;
        }
        this.xPiston = this.showScale ? (this.scalePosition ? (this.bounds.width - this.widthPiston + this.widthScale) / 2 : (this.bounds.width - this.widthPiston - this.widthScale) / 2) : (this.bounds.width - this.widthPiston) / 2;
        this.yPiston = (this.bounds.height - this.heightPiston) / 2;
        this.widthBarrier = this.widthPiston - 2 * this.widthWall;
        this.xBarrier = this.xPiston + this.widthWall;
        this.yBarrier = 10;
        this.xWall = this.xBarrier + this.widthBarrier;
        this.yWall = this.yPiston + this.heightPiston - this.widthWall;
        this.maxHeight = this.heightPiston - this.widthWall;
        this.setScale();
        this.majorWidth = this.widthScale;
        this.minorWidth = this.majorWidth / 7;
        if (this.minorWidth < 2) {
            this.minorWidth = 2;
        }
        if (this.scalePosition) {
            this.xMajor = this.xPiston - this.widthScale;
            this.xMinor = this.xMajor + this.majorWidth - this.minorWidth;
            this.xLabel = this.xMajor;
        } else {
            this.xMinor = this.xMajor = this.xWall + this.widthWall;
            this.xLabel = this.xMajor + this.minorWidth;
        }
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(((Component)((Object)this)).getFont());
        this.labelHeight = fontMetrics.getMaxAscent();
        this.setMinVolume(this.minVolume);
        this.setMaxVolume(this.maxVolume);
        this.isSet = true;
        ((Component)((Object)this)).repaint();
    }

    private void setBarrier(int _position) {
        if (_position <= this.yMinBarrier && _position >= this.yPiston) {
            this.yBarrier = _position;
            this.updateDataConnections();
            this.updateDisplay();
        }
    }

    private void setScale() {
        this.tickNbr = 0;
        double[] tmpMult = new double[]{1.0, 2.0, 4.0, 5.0};
        int[] tmpMinor = new int[]{5, 4, 4, 5};
        for (int i = 0; i < tmpMult.length; ++i) {
            int tmpExp = (int)Math.floor(this.log(this.maxReading / tmpMult[i]) - 0.05);
            int tmpNbr = (int)Math.ceil(this.maxReading / (tmpMult[i] * Math.pow(10.0, tmpExp)));
            if (tmpNbr <= this.tickNbr) continue;
            this.tickNbr = tmpNbr;
            this.tickExp = tmpExp;
            this.tickMult = (int)tmpMult[i];
            this.tickMinorNbr = tmpMinor[i];
        }
        if (this.tickNbr == 0 || this.tickMinorNbr == 0 || this.tickMult == 0) {
            System.out.println("Piston:  Scaling Error, max=".concat(String.valueOf(this.scaleMax)));
            return;
        }
        this.valMajor = (double)this.tickMult * Math.pow(10.0, this.tickExp);
        this.scaleMax = (double)this.tickNbr * this.valMajor;
        this.nMajor = (int)Math.floor((double)this.maxHeight / (double)this.tickNbr);
        this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
        this.nMajor = this.tickMinorNbr * this.nMinor;
        while ((double)this.maxHeight > (double)(this.nMajor * (this.tickNbr + 1))) {
            ++this.tickNbr;
            this.scaleMax = (double)this.tickNbr * this.valMajor;
            this.nMajor = (int)Math.floor((double)this.maxHeight / (double)this.tickNbr);
            this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
            this.nMajor = this.tickMinorNbr * this.nMinor;
        }
        this.maxReading = this.scaleMax;
    }

    private double log(double val) {
        return Math.log(val) / Math.log(10.0);
    }
}

