/*
 * Decompiled with CFR 0.152.
 */
package manometer;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import manometer.DataFormat;

public class Manometer
extends SApplet
implements SDataListener,
SDataSource {
    boolean isStandalone = false;
    private boolean update = false;
    private int tubeDia = 20;
    private Color colorLiquid = new Color(192, 192, 192);
    private Color colorLine = Color.black;
    private Color colorGas = new Color(200, 200, 255);
    private Color colorLabel = Color.blue;
    private Color colorBkg;
    private Rectangle bounds = null;
    private Graphics graphics = null;
    private int tubeLength;
    private int yT;
    private int yB;
    private int yH;
    private int xR;
    private int tubeWidth;
    private int xHL;
    private int xIBL;
    private int yIBL;
    private int xIBR;
    private int yIBR;
    private int xOBL;
    private int yOBL;
    private int xOBR;
    private int yOBR;
    private int wOB;
    private int wIB;
    private final int labelOffset = 2;
    private int scaleWidth;
    private double scaleMax;
    private double valMajor;
    private int xMajor;
    private int xMinor;
    private int xLabel;
    private int nMajor;
    private int nMinor;
    private int majorWidth;
    private int minorWidth;
    private int tickNbr;
    private int tickMult;
    private int tickExp;
    private int tickMinorNbr;
    private int yL;
    private int yR;
    private double volumeGas;
    private double volGas;
    private double lenLiquid;
    private double volCap;
    private double lenCap;
    private double fractionLiquid;
    private double density;
    private double densityHg = 13.5951;
    private double scale;
    private double scale3;
    private double scale4;
    private int yDown;
    private boolean isOnLiquid = false;
    private boolean isOnLeft = true;
    private boolean isDragable = false;
    private double pressure = 0.0;
    private double vaporPressure = 0.0;
    private double pressureMax = 800.0;
    private double moles = 0.0;
    private double temperature = 298.15;
    private double gasConstant = 0.08206;
    private double area;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public Manometer() {
        SApplet.addDataListener((Object)((Object)this));
        try {
            SApplet.addDataSource((Object)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        try {
            this.pressureMax = Double.valueOf(this.getParameter("Maximum", "1000.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pressureMax <= 0.0) {
            this.pressureMax = 1000.0;
        }
        try {
            this.fractionLiquid = Double.valueOf(this.getParameter("FractionLiquid", "0.60"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fractionLiquid <= 0.0 || this.fractionLiquid >= 1.0) {
            this.fractionLiquid = 0.6;
        }
        try {
            this.density = Double.valueOf(this.getParameter("Density", "13.5951"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.density <= 0.0) {
            this.density = 13.5951;
        }
        try {
            this.temperature = Double.valueOf(this.getParameter("Temperature", "298.15"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.temperature <= 0.0) {
            this.temperature = 298.15;
        }
        try {
            this.moles = Double.valueOf(this.getParameter("Moles", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.moles < 0.0) {
            this.moles = 0.0;
        }
        try {
            this.pressure = Double.valueOf(this.getParameter("Pressure", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pressure < 0.0) {
            this.pressure = 0.0;
        }
        try {
            this.vaporPressure = Double.valueOf(this.getParameter("VaporPressure", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.vaporPressure < 0.0) {
            this.vaporPressure = 0.0;
        }
        try {
            this.tubeDia = Integer.valueOf(this.getParameter("TubeDiameter", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorBkg = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorGas = Color.decode(this.getParameter("GasColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorGas = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorLiquid = Color.decode(this.getParameter("LiquidColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorLiquid = new Color(192, 192, 192);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
        this.setup();
        this.setScale();
        this.updateDisplay();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void paint(Graphics g) {
        if (this.bounds != null) {
            this.paintManometer(g);
            this.updateManometer(g);
        }
    }

    public String getAppletInfo() {
        return "Manometer.class  version 1.2  Copyright 2001  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGGOLOR", "Color", "Background Color"}, {"Density", "double", "Density (g/mL) of the Liquid"}, {"FractionLiquid", "double", "Fraction of Useful Manometer Volume Occupied by Liquid"}, {"GasColor", "Color", "Color of Trapped Gas"}, {"LiquidColor", "Color", "Liquid Color"}, {"Maximum", "double", "Maximum scale value"}, {"Moles", "double", "Moles of Trapped Gas"}, {"Pressure", "double", "Pressure in torr"}, {"Temperature", "double", "Temperature in Kelvin"}, {"TubeDiameter", "int", "Diameter of Tube"}, {"VaporPressure", "double", "Vapor Pressure of the Liquid in torr"}};
        return pinfo;
    }

    public void addData(SDataSource ds, int id, double[] xVal, double[] yVal) {
        switch (id) {
            case 1: {
                if (!(yVal[0] >= 0.0)) break;
                this.pressure = yVal[0];
                break;
            }
            case 2: {
                if (!(yVal[0] >= 0.0)) break;
                this.temperature = yVal[0];
                break;
            }
            case 3: {
                if (!(yVal[0] >= 0.0)) break;
                this.moles = yVal[0];
                break;
            }
            default: {
                return;
            }
        }
        this.updateDataConnections();
        this.updateDisplay();
    }

    public void addDatum(SDataSource ds, int id, double xVal, double yVal) {
        switch (id) {
            case 1: {
                if (!(yVal >= 0.0)) break;
                this.pressure = yVal;
                break;
            }
            case 2: {
                if (!(yVal >= 0.0)) break;
                this.temperature = yVal;
                break;
            }
            case 3: {
                if (!(yVal >= 0.0)) break;
                this.moles = yVal;
                break;
            }
            default: {
                return;
            }
        }
        this.updateDataConnections();
        this.updateDisplay();
    }

    public void clearSeries(int id) {
    }

    public void deleteSeries(int id) {
    }

    public double getDiameter() {
        return (double)this.tubeDia / this.scale;
    }

    public double getFractionLiquid() {
        return this.fractionLiquid;
    }

    public double getLeftHeight() {
        return (double)(this.yB - this.yL) / this.scale;
    }

    public double getMaxVolume() {
        return (this.volCap + this.area * (double)this.tubeLength) / (this.scale3 * 1000000.0);
    }

    public SApplet getOwner() {
        return this;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getRightHeight() {
        return (double)(this.yB - this.yR) / this.scale;
    }

    public double getScaleMaximum() {
        return this.scaleMax;
    }

    public double getVolume() {
        return (this.volCap + this.area * (double)(this.yL - this.yT)) / (this.scale3 * 1000000.0);
    }

    public double[][] getVariables() {
        double[][] ds = new double[2][1];
        ds[0][0] = this.pressure;
        ds[1][0] = this.moles;
        return ds;
    }

    public String[] getVarStrings() {
        return new String[]{"P", "n"};
    }

    public boolean mouseDown(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        if (_x >= 1 && _x <= this.tubeDia + 1 && _y >= this.yL && _y <= this.yB) {
            this.yDown = _y;
            this.isOnLiquid = true;
            this.isOnLeft = true;
        } else if (_x >= this.xR + 1 && _x <= this.xR + this.tubeDia + 1 && _y >= this.yR && _y <= this.yB) {
            this.yDown = _y;
            this.isOnLiquid = true;
            this.isOnLeft = false;
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        double _newPos = _y - this.yDown;
        double _pressure = this.getPressure();
        if (this.isOnLiquid) {
            _pressure = this.isOnLeft ? (_pressure -= _newPos / this.scale) : (_pressure += _newPos / this.scale);
            this.setPressure(_pressure);
            this.yDown = _y;
        }
        return true;
    }

    public boolean mouseUp(Event evt, int _x, int _y) {
        if (!this.isDragable) {
            return true;
        }
        this.isOnLiquid = false;
        return true;
    }

    public void setDensity(double _density) {
        this.density = _density > 0.0 ? _density : 13.5951;
        this.updateDisplay();
    }

    public void setDragable(boolean val) {
        this.isDragable = val;
    }

    public void setFractionLiquid(double _fraction) {
        if (_fraction > 0.0 && _fraction < 1.0) {
            this.fractionLiquid = _fraction;
            this.lenLiquid = this.fractionLiquid * 2.0 * (double)this.tubeLength;
            this.updateDisplay();
        }
    }

    public void setMaximum(double _maximum) {
        if (_maximum > 0.0) {
            this.pressureMax = _maximum;
            this.setScale();
            ((Component)((Object)this)).repaint();
        }
    }

    public void setMoles(double _moles) {
        if (_moles >= 0.0) {
            this.moles = _moles;
            this.updateDisplay();
            this.updateDataConnections();
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setPressure(double _pressure) {
        if (_pressure >= 0.0) {
            this.pressure = _pressure;
            this.updateDisplay();
            this.updateDataConnections();
        }
    }

    public void setTemperature(double _temperature) {
        if (_temperature > 0.0) {
            this.temperature = _temperature;
            this.updateDisplay();
        }
    }

    public void setVaporPressure(double _pressure) {
        this.vaporPressure = _pressure >= 0.0 ? _pressure : 0.0;
        this.updateDisplay();
    }

    public void updateDisplay() {
        if (this.graphics == null) {
            this.graphics = ((Component)((Object)this)).getGraphics();
        }
        this.updateManometer(this.graphics);
    }

    private double log(double val) {
        return Math.log(val) / Math.log(10.0);
    }

    private void paintManometer(Graphics g) {
        g.setColor(this.colorBkg);
        g.fillRect(0, 0, this.bounds.width, this.bounds.height);
        g.setColor(this.colorLiquid);
        g.fillRoundRect(this.xOBL, this.yOBL, 2 * this.tubeDia + this.scaleWidth + 4, 4 * this.tubeDia + 4, this.wOB, this.wOB);
        g.setColor(this.colorBkg);
        g.fillRoundRect(this.xIBL, this.yIBL, this.scaleWidth + 1, 2 * this.tubeDia + 2, this.wIB, this.wIB);
        g.fillRect(this.xOBL, this.yOBL, 2 * this.tubeDia + this.scaleWidth + 4, 2 * this.tubeDia + 2);
        g.setColor(this.colorGas);
        g.fillArc(0, 0, this.tubeDia + 2, this.tubeDia + 2, 0, 180);
        g.setColor(this.colorLine);
        g.drawLine(0, this.yT, 0, this.yB);
        g.drawLine(this.tubeDia + 1, this.yT, this.tubeDia + 1, this.yB);
        g.drawLine(this.xR, 0, this.xR, this.yB);
        g.drawLine(this.xR + this.tubeDia + 1, 0, this.xR + this.tubeDia + 1, this.yB);
        g.drawArc(0, 0, this.tubeDia + 1, this.tubeDia + 1, 0, 180);
        g.drawArc(this.xOBL, this.yOBL, this.wOB, this.wOB, 180, 90);
        g.drawArc(this.xIBL, this.yIBL, this.wIB, this.wIB, 180, 90);
        g.drawLine(this.xHL, this.yH + this.tubeDia + 1, this.xHL + this.tubeWidth, this.yH + this.tubeDia + 1);
        g.drawLine(this.xHL, this.yH, this.xHL + this.tubeWidth, this.yH);
        g.drawArc(this.xOBR, this.yOBR, this.wOB, this.wOB, 270, 90);
        g.drawArc(this.xIBR, this.yIBR, this.wIB, this.wIB, 270, 90);
        g.setColor(this.colorLine);
        for (int i = 0; i <= this.tickNbr; ++i) {
            int nbrLen;
            g.drawLine(this.xMajor, this.yB - i * this.nMajor, this.xMajor + this.majorWidth, this.yB - i * this.nMajor);
            if (i < this.tickNbr) {
                for (int j = 1; j < this.tickMinorNbr; ++j) {
                    g.drawLine(this.xMajor, this.yB - i * this.nMajor - j * this.nMinor, this.xMajor + this.minorWidth, this.yB - i * this.nMajor - j * this.nMinor);
                    g.drawLine(this.xMinor, this.yB - i * this.nMajor - j * this.nMinor, this.xMinor + this.minorWidth, this.yB - i * this.nMajor - j * this.nMinor);
                }
            }
            nbrLen = (nbrLen = (int)Math.ceil(Math.log(this.scaleMax) / DataFormat.ln10)) < 1 ? 3 : (nbrLen += 2);
            int nbrDec = (int)(-Math.floor(Math.log(this.scaleMax) / DataFormat.ln10 - 1.0));
            if (nbrDec < 0) {
                nbrDec = 0;
            }
            if (i > 0) {
                g.drawString(DataFormat.formatDec((double)i * this.valMajor, nbrLen + nbrDec, nbrDec), this.xLabel, this.yB - i * this.nMajor - 2);
                continue;
            }
            g.drawString(" 0 mm", this.xLabel, this.yB - i * this.nMajor - 2);
        }
        int _i = 1;
        while (this.yB - this.tickNbr * this.nMajor - _i * this.nMinor > 0) {
            g.drawLine(this.xMajor, this.yB - this.tickNbr * this.nMajor - _i * this.nMinor, this.xMajor + this.minorWidth, this.yB - this.tickNbr * this.nMajor - _i * this.nMinor);
            g.drawLine(this.xMinor, this.yB - this.tickNbr * this.nMajor - _i * this.nMinor, this.xMinor + this.minorWidth, this.yB - this.tickNbr * this.nMajor - _i * this.nMinor);
            ++_i;
        }
    }

    private void setup() {
        this.bounds = ((Component)((Object)this)).getBounds();
        if (this.colorBkg == null) {
            this.colorBkg = ((Component)((Object)this)).getBackground();
        }
        if (this.colorGas == null) {
            this.colorGas = this.colorBkg;
        }
        this.tubeLength = this.bounds.height - 4 - 5 * this.tubeDia / 2;
        this.scaleWidth = this.bounds.width - 4 - 2 * this.tubeDia;
        this.tubeWidth = this.scaleWidth - 2 * this.tubeDia;
        this.area = (double)this.tubeDia * (double)this.tubeDia * Math.PI / 4.0;
        this.volCap = Math.PI * (double)this.tubeDia * (double)this.tubeDia * (double)this.tubeDia / 12.0;
        this.lenCap = (double)this.tubeDia / 3.0;
        this.lenLiquid = this.fractionLiquid * 2.0 * (double)this.tubeLength;
        this.yT = this.tubeDia / 2;
        this.yB = this.yT + this.tubeLength;
        this.yH = this.bounds.height - 2 - this.tubeDia;
        this.xR = 2 + this.tubeDia + this.scaleWidth;
        this.xHL = 1 + 2 * this.tubeDia;
        this.xIBL = 1 + this.tubeDia;
        this.yIBL = this.yB - this.tubeDia;
        this.xOBL = 0;
        this.yOBL = this.yB - 2 * this.tubeDia - 1;
        this.xIBR = this.xR - 2 * this.tubeDia - 2;
        this.yIBR = this.yB - this.tubeDia - 1;
        this.xOBR = this.xR - 3 * this.tubeDia - 3;
        this.yOBR = this.yB - 2 * this.tubeDia - 2;
        this.wOB = 4 * this.tubeDia + 4;
        this.wIB = 2 * this.tubeDia + 2;
        this.majorWidth = this.scaleWidth - 3;
        this.minorWidth = this.majorWidth / 7;
        if (this.minorWidth < 2) {
            this.minorWidth = 2;
        }
        this.xMajor = this.tubeDia + 3;
        this.xMinor = this.xR - this.minorWidth - 2;
        this.xLabel = 2 + this.minorWidth + (this.bounds.width - this.majorWidth) / 2;
    }

    private void setScale() {
        this.tickNbr = 0;
        double[] tmpMult = new double[]{1.0, 2.0, 4.0, 5.0};
        int[] tmpMinor = new int[]{5, 4, 4, 5};
        for (int i = 0; i < tmpMult.length; ++i) {
            int tmpExp = (int)Math.floor(this.log(this.pressureMax / tmpMult[i]) - 0.05);
            int tmpNbr = (int)Math.ceil(this.pressureMax / (tmpMult[i] * Math.pow(10.0, tmpExp)));
            if (tmpNbr <= this.tickNbr) continue;
            this.tickNbr = tmpNbr;
            this.tickExp = tmpExp;
            this.tickMult = (int)tmpMult[i];
            this.tickMinorNbr = tmpMinor[i];
        }
        if (this.tickNbr == 0 || this.tickMinorNbr == 0 || this.tickMult == 0) {
            System.out.println("Manometer.class:  Scaling Error, max=".concat(String.valueOf(this.scaleMax)));
            return;
        }
        this.valMajor = (double)this.tickMult * Math.pow(10.0, this.tickExp);
        this.scaleMax = (double)this.tickNbr * this.valMajor;
        this.nMajor = (int)Math.floor(this.tubeLength / this.tickNbr);
        this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
        this.nMajor = this.tickMinorNbr * this.nMinor;
        while (this.scaleMax < this.pressureMax) {
            ++this.tickNbr;
            if (this.tickNbr > 20) {
                System.out.print("Manometer.class:  Too many scale expansions.\n");
                break;
            }
            this.scaleMax = (double)this.tickNbr * this.valMajor;
            this.nMajor = (int)Math.floor(this.tubeLength / this.tickNbr);
            this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
            this.nMajor = this.tickMinorNbr * this.nMinor;
        }
        while (this.tubeLength > this.nMajor * (this.tickNbr + 1)) {
            ++this.tickNbr;
            this.scaleMax = (double)this.tickNbr * this.valMajor;
            this.nMajor = (int)Math.floor(this.tubeLength / this.tickNbr);
            this.nMinor = (int)Math.floor(this.nMajor / this.tickMinorNbr);
            this.nMajor = this.tickMinorNbr * this.nMinor;
        }
        this.pressureMax = this.scaleMax;
        this.scale = (double)this.nMajor / this.valMajor;
        this.scale4 = this.scale * this.scale;
        this.scale3 = this.scale4 * this.scale;
        this.scale4 *= this.scale4;
    }

    private void updateManometer(Graphics g) {
        double _P = (this.pressure - this.vaporPressure) * this.scale * this.densityHg / this.density;
        double _a = this.lenLiquid + _P - 2.0 * (double)this.yB;
        double _b = this.moles * this.gasConstant * this.temperature * this.scale4 * 7.6E8 * this.densityHg / (this.density * this.area);
        double _B = _a + 2.0 * this.lenCap - 2.0 * (double)this.yT;
        double _C = _a * (this.lenCap - (double)this.yT) - _b;
        double _root = (-_B + Math.sqrt(_B * _B - (double)8 * _C)) / 4.0;
        this.yL = (int)Math.round(_root);
        this.yR = (int)Math.round(2.0 * (double)this.yB - _root - this.lenLiquid);
        if (this.yL < this.yT || this.yR > this.yB) {
            System.out.println("Manometer.class:  Pressure is too high");
        } else if (this.yL > this.yB || this.yR <= 0) {
            System.out.println("Manometer.class:  Pressure is too low");
        }
        int _yL = this.yL > this.yB ? this.yB : (this.yL < this.yT ? this.yT : this.yL);
        int _yR = this.yR > this.yB ? this.yB : (this.yR < 0 ? 0 : this.yR);
        g.setColor(this.colorGas);
        g.fillRect(1, this.yT, this.tubeDia, _yL - this.yT);
        g.setColor(this.colorBkg);
        g.fillRect(this.xR + 1, 0, this.tubeDia, _yR);
        g.setColor(this.colorLiquid);
        g.fillRect(1, _yL, this.tubeDia, this.yB - _yL + 1);
        g.fillRect(this.xR + 1, _yR, this.tubeDia, this.yB - _yR + 1);
        this.yL = _yL;
        this.yR = _yR;
        this.updateDataConnections();
    }
}

