/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Equilibria;
import edu.davidson.chm.equilibria.HalfReaction;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class Titration {
    private double STD = 0.03;
    private final double DEL = 0.001;
    private final double LNMIN = -200.0;
    private final double TOL = 1.0E-4;
    private final double CHISQTOL = 0.001;
    private final int MAXCNT = 100;
    private final double LAMBDAMIN = 1.0E-8;
    private final double LAMBDAMAX = 10000.0;
    private final double LAMBDAFAC = 0.1;
    private boolean displayIterations = false;
    private boolean displayResults = false;
    private ChemSystem chemSystem;
    private String titrantLabel;
    private String sampleLabel;
    private boolean abortFit = false;
    private String monSpecies;
    private String monHalfReaction;
    private String monRefHalfReaction;
    private int monMode = -1;
    private double minInc = 0.01;
    private double maxInc = 1.0;
    private double target = 0.3;
    private double[] Vt = null;
    private double[] Y = null;
    private double[] std;
    private int nExpt = 0;
    private Vector reactions;
    private Vector species;
    private int nRxn;
    private int nSp;
    private boolean status = false;
    private double tol = 1.0E-4;
    private double chisqTol = 0.001;
    private double LAMBDA = 0.01;
    private double MAXDEL = 6.0;
    private double lambdaFac = 0.1;
    private double equilTol = 1.0E-7;
    private String[] rLabels;
    private String[] pLabels;
    private String[] sLabels;
    private double ochisq = 0.0;
    private double chisq = 0.0;
    private int nUnk = 0;
    private double[] del;
    private double[][] covar;
    private double[][] alpha;
    private double[] beta;
    private double lambda;
    private double[] par = null;
    private double[][] y;

    public Titration() {
    }

    public Titration(ChemSystem _chemSystem, String _titrantLabel, String _sampleLabel) {
        this.chemSystem = _chemSystem;
        this.titrantLabel = _titrantLabel;
        this.sampleLabel = _sampleLabel;
        this.reactions = new Vector();
        this.species = new Vector();
        this.nExpt = 0;
        this.nUnk = 0;
        this.status = false;
    }

    public void addReaction(Reaction _rxn) {
        this.reactions.addElement(_rxn);
    }

    public void addSpecies(Species _species) {
        this.species.addElement(_species);
    }

    public void apply() {
        int i;
        if (!this.status) {
            return;
        }
        if (this.reactions.size() > 0) {
            for (i = 0; i < this.reactions.size(); ++i) {
                Reaction _rxn = (Reaction)this.reactions.elementAt(i);
                _rxn.setK(Math.exp(this.par[i]));
            }
        }
        if (this.species.size() > 0) {
            for (i = 0; i < this.species.size(); ++i) {
                Species _sp = (Species)this.species.elementAt(i);
                _sp.setAnalMoles(Math.exp(this.par[i + this.reactions.size()]));
            }
        }
    }

    public double[][] calcCurve(double _finalVol) {
        Vector<Double> _Vt = new Vector<Double>();
        Vector<Double> _val = new Vector<Double>();
        double _vol = 0.0;
        ChemSystem _cs = this.chemSystem.copyOf("titration");
        Phase _titrant = _cs.getPhase(this.titrantLabel);
        Phase _sample = _cs.getPhase(this.sampleLabel);
        if (_titrant == null) {
            System.out.println("Titration.calcCurve:  Titrant does not exist");
            return null;
        }
        if (_sample == null) {
            System.out.println("Titration.calcCurve:  Sample does not exist");
            return null;
        }
        if (_titrant.getVolume() <= _finalVol / 1000.0) {
            System.out.println("Titration.calcCurve:  Insufficient titrant available");
            return null;
        }
        Equilibria equil = new Equilibria(_cs);
        equil.setUsePrevious(false);
        equil.setTolerance(this.equilTol);
        if (!equil.solveProblem()) {
            System.out.println("Titration.calcCurve:  Error solving equilibrium problem");
            String[] _mes = equil.getMessages();
            if (!_mes[0].equals("no messages")) {
                for (int i = 0; i < _mes.length; ++i) {
                    System.out.println(_mes[i]);
                }
            }
            return null;
        }
        equil.setUsePrevious(true);
        double _yOld = this.getValue(_cs, _sample);
        _Vt.addElement(new Double(0.0));
        _val.addElement(new Double(_yOld));
        _cs.transferSolution(_titrant, _sample, this.minInc / 1000.0);
        if (!equil.solveProblem()) {
            System.out.println("Titration.calcCurve:  Error solving equilibrium problem");
            String[] _mes = equil.getMessages();
            if (!_mes[0].equals("no messages")) {
                for (int i = 0; i < _mes.length; ++i) {
                    System.out.println(_mes[i]);
                }
            }
            return null;
        }
        double _y = this.getValue(_cs, _sample);
        _Vt.addElement(new Double(this.minInc));
        _val.addElement(new Double(_y));
        double _del = Math.abs(_y - _yOld);
        _yOld = _y;
        double _inc = this.minInc;
        _vol = this.minInc;
        while (_vol < _finalVol) {
            if (_del > this.target) {
                _inc *= 0.1;
            } else if (_del < 0.5 * this.target) {
                _inc *= 2.0;
            }
            if (_inc < this.minInc) {
                _inc = this.minInc;
            } else if (_inc > this.maxInc) {
                _inc = this.maxInc;
            }
            if (_vol + _inc > _finalVol) {
                _inc = _finalVol - _vol;
            }
            _cs.transferSolution(_titrant, _sample, _inc / 1000.0);
            if (!equil.solveProblem()) {
                System.out.println("Titration.calcCurve:  Error solving equilibrium problem");
                String[] _mes = equil.getMessages();
                if (!_mes[0].equals("no messages")) {
                    for (int i = 0; i < _mes.length; ++i) {
                        System.out.println(_mes[i]);
                    }
                }
                return null;
            }
            _y = this.getValue(_cs, _sample);
            _Vt.addElement(new Double(_vol += _inc));
            _val.addElement(new Double(_y));
            _del = Math.abs(_y - _yOld);
            _yOld = _y;
        }
        double[][] _data = new double[_Vt.size()][2];
        for (int i = 0; i < _Vt.size(); ++i) {
            _data[i][0] = (Double)_Vt.elementAt(i);
            _data[i][1] = (Double)_val.elementAt(i);
        }
        return _data;
    }

    public double[] calc(double[] _Vt) {
        Phase _titrant = this.chemSystem.getPhase(this.titrantLabel);
        if (_titrant == null) {
            System.out.println("Titration.calc:  Titrant does not exist");
            return null;
        }
        if (this.chemSystem.getPhase(this.sampleLabel) == null) {
            System.out.println("Titration.calc:  Sample does not exist");
            return null;
        }
        if (_Vt == null) {
            return null;
        }
        double _max = 0.0;
        if (_Vt.length > 1) {
            for (int i = 1; i < _Vt.length; ++i) {
                if (_Vt[i] > _max) {
                    _max = _Vt[i];
                }
                if (!(_Vt[i] <= _Vt[i - 1])) continue;
                System.out.println("Titration.calc:  _Vt must contain increasing volumes");
                return null;
            }
        }
        if (_max / 1000.0 >= _titrant.getVolume()) {
            System.out.println(String.valueOf(new StringBuffer("Titration.calc:  Titrant has insufficient volume:  max Vt = ").append(_max).append(" mL and total volume of titrant = ").append(_titrant.getVolume() * 1000.0).append(" mL")));
            return null;
        }
        ChemSystem _cs = this.chemSystem.copyOf("titration");
        return this.calc(_Vt, _cs);
    }

    public void clearReactions() {
        this.reactions = new Vector();
    }

    public void clearSpecies() {
        this.species = new Vector();
    }

    public boolean fit() {
        int i;
        boolean state = true;
        this.abortFit = false;
        this.nRxn = this.reactions.size();
        this.nSp = this.species.size();
        this.nUnk = this.nRxn + this.nSp;
        if (this.chemSystem.getPhase(this.titrantLabel) == null) {
            System.out.println("Titration.fit:  Titrant does not exist");
            return false;
        }
        if (this.chemSystem.getPhase(this.sampleLabel) == null) {
            System.out.println("Titration.fit:  Sample does not exist");
            return false;
        }
        if (this.nUnk == 0) {
            System.out.println("Titration.fit:  No unknown parameters have been defined.");
            return false;
        }
        this.par = new double[this.nUnk];
        if (this.nRxn > 0) {
            this.rLabels = new String[this.nRxn];
            for (i = 0; i < this.nRxn; ++i) {
                Reaction _rxn = (Reaction)this.reactions.elementAt(i);
                this.rLabels[i] = _rxn.getLabel();
                this.par[i] = Math.log(_rxn.getK());
            }
        }
        if (this.nSp > 0) {
            this.pLabels = new String[this.nSp];
            this.sLabels = new String[this.nSp];
            for (i = 0; i < this.nSp; ++i) {
                Species _sp = (Species)this.species.elementAt(i);
                this.pLabels[i] = _sp.getPhase().getLabel();
                this.sLabels[i] = _sp.getLabel();
                double _analMoles = _sp.getAnalMoles();
                this.par[this.nRxn + i] = _analMoles == 0.0 ? -200.0 : Math.log(_analMoles);
            }
        }
        if (this.Vt == null) {
            System.out.println("Titration.fit:  No data has been provided.");
            return false;
        }
        if (this.nExpt <= this.nUnk) {
            System.out.println("Titration.fit:  Insufficient data");
            return false;
        }
        this.y = new double[this.nExpt][this.nUnk + 1];
        this.alpha = new double[this.nUnk][this.nUnk];
        this.beta = new double[this.nUnk];
        this.covar = new double[this.nUnk][this.nUnk];
        this.del = new double[this.nUnk];
        this.mrqcof(this.par);
        if (this.abortFit) {
            System.out.println("Titration.fit:  Error encountered during curve-fitting");
            return false;
        }
        this.ochisq = this.chisq;
        this.lambda = this.LAMBDA;
        boolean converged = false;
        double olambda = this.lambda;
        int cnt = 0;
        while (!converged) {
            int i2;
            this.mrqmin();
            if (this.abortFit) {
                System.out.println("Titration.fit:  Error encountered during curve-fitting");
                return false;
            }
            converged = true;
            if (this.lambda > olambda) {
                converged = false;
            }
            if (Math.abs((this.chisq - this.ochisq) / this.chisq) > this.chisqTol) {
                converged = false;
            }
            for (i2 = 0; i2 < this.nUnk; ++i2) {
                if (!(Math.abs(this.del[i2]) > this.tol)) continue;
                converged = false;
            }
            if (cnt++ > 100) {
                System.out.println("Titration.fit:  Maximum number of iterations exceeded");
                System.out.println("Titration.fit:  Procedure terminating, results are not reliable");
                converged = true;
                state = false;
            }
            if (this.lambda < 1.0E-8) {
                this.lambda = 1.0E-8;
            } else if (this.lambda > 10000.0) {
                this.lambda = 10000.0;
            }
            olambda = this.lambda;
            if (!this.displayIterations) continue;
            System.out.println("Iteration: ".concat(String.valueOf(cnt)));
            System.out.println(String.valueOf(new StringBuffer("  chi-square = ").append(this.chisq).append("     goodness-of-fit = ").append(this.chisq / (double)(this.nExpt - this.nUnk)).append("     lambda = ").append(this.lambda)));
            System.out.println("  Equilibrium Constants");
            for (i2 = 0; i2 < this.nRxn; ++i2) {
                System.out.println(String.valueOf(new StringBuffer("    ").append(this.rLabels[i2]).append("     ln K = ").append(this.par[i2]).append(" (").append(this.del[i2]).append(")     K = ").append(Math.exp(this.par[i2]))));
            }
            System.out.println("  Species");
            for (i2 = 0; i2 < this.nSp; ++i2) {
                System.out.println(String.valueOf(new StringBuffer("    ").append(this.sLabels[i2]).append(" (").append(this.pLabels[i2]).append(")     ln n = ").append(this.par[i2 + this.nRxn]).append(" (").append(this.del[i2 + this.nRxn]).append(")     n = ").append(Math.exp(this.par[i2 + this.nRxn]))));
            }
        }
        this.lambda = 0.0;
        this.mrqmin();
        if (this.abortFit) {
            System.out.println("Titration.fit:  Error encountered during curve-fitting");
            return false;
        }
        if (this.displayResults) {
            System.out.println(String.valueOf(new StringBuffer("Best-Fit Parameters,  ").append(cnt).append(" iterations,  ").append(this.nExpt).append(" data points,  ").append(this.nUnk).append(" parameters")));
            System.out.println(String.valueOf(new StringBuffer("     chi-square = ").append(this.chisq).append("     goodness-of-fit = ").append(this.chisq / (double)(this.nExpt - this.nUnk))));
        }
        double[][] p = new double[this.nUnk][2];
        for (int i3 = 0; i3 < this.nUnk; ++i3) {
            p[i3][0] = this.par[i3];
            p[i3][1] = Math.sqrt(Math.abs(this.covar[i3][i3]));
            if (!this.displayResults) continue;
            if (i3 < this.nRxn) {
                System.out.println(String.valueOf(new StringBuffer("    ").append(this.rLabels[i3]).append("     ln K = ").append(p[i3][0]).append(" (").append(p[i3][1]).append(")     K = ").append(Math.exp(p[i3][0])).append(" (").append(Math.exp(p[i3][0]) * p[i3][1]).append(")")));
                continue;
            }
            System.out.println(String.valueOf(new StringBuffer("    ").append(this.sLabels[i3 - this.nRxn]).append(" (").append(this.pLabels[i3 - this.nRxn]).append(")     ln n = ").append(p[i3][0]).append(" (").append(p[i3][1]).append(")     n = ").append(Math.exp(p[i3][0])).append(" (").append(Math.exp(p[i3][0]) * p[i3][1]).append(")")));
        }
        this.status = state;
        return state;
    }

    public double getChiSq() {
        return this.chisq;
    }

    public double[][] getCovariance() {
        return this.covar;
    }

    public double getDerivative(int _idx) {
        if (this.Vt == null) {
            System.out.println("Titration.getDerivative:  No experimental data is available");
            return 0.0;
        }
        if (_idx < 0 || _idx >= this.nExpt) {
            System.out.println("Titration.getDerivative:  Index out of range");
            return 0.0;
        }
        if (_idx == 0) {
            return ((this.Y[1] - this.Y[0]) * (this.Vt[2] - this.Vt[0]) / (this.Vt[1] - this.Vt[0]) - (this.Y[2] - this.Y[0]) * (this.Vt[1] - this.Vt[0]) / (this.Vt[2] - this.Vt[0])) / (this.Vt[2] - this.Vt[1]);
        }
        if (_idx == this.nExpt - 1) {
            return ((this.Y[_idx - 2] - this.Y[_idx - 1]) * (this.Vt[_idx - 3] - this.Vt[_idx - 1]) / (this.Vt[_idx - 2] - this.Vt[_idx - 1]) - (this.Y[_idx - 3] - this.Y[_idx - 1]) * (this.Vt[_idx - 2] - this.Vt[_idx - 1]) / (this.Vt[_idx - 3] - this.Vt[_idx - 1])) / (this.Vt[_idx - 3] - this.Vt[_idx - 2]);
        }
        return ((this.Y[_idx - 1] - this.Y[_idx]) * (this.Vt[_idx + 1] - this.Vt[_idx]) / (this.Vt[_idx - 1] - this.Vt[_idx]) - (this.Y[_idx + 1] - this.Y[_idx]) * (this.Vt[_idx - 1] - this.Vt[_idx]) / (this.Vt[_idx + 1] - this.Vt[_idx])) / (this.Vt[_idx + 1] - this.Vt[_idx - 1]);
    }

    public double getDerivative2(int _idx) {
        if (this.Vt == null) {
            System.out.println("Titration.getDerivative2:  No experimental data is available");
            return 0.0;
        }
        if (_idx < 0 || _idx >= this.nExpt) {
            System.out.println("Titration.getDerivative2:  Index out of range");
            return 0.0;
        }
        if (_idx == 0) {
            return 2.0 * ((this.Y[2] - this.Y[0]) / (this.Vt[2] - this.Vt[0]) - (this.Y[1] - this.Y[0]) / (this.Vt[1] - this.Vt[0])) / (this.Vt[2] - this.Vt[1]);
        }
        if (_idx == this.nExpt - 1) {
            return 2.0 * ((this.Y[_idx - 3] - this.Y[_idx - 1]) / (this.Vt[_idx - 3] - this.Vt[_idx - 1]) - (this.Y[_idx - 2] - this.Y[_idx - 1]) / (this.Vt[_idx - 2] - this.Vt[_idx - 1])) / (this.Vt[_idx - 3] - this.Vt[_idx - 2]);
        }
        return 2.0 * ((this.Y[_idx + 1] - this.Y[_idx]) / (this.Vt[_idx + 1] - this.Vt[_idx]) - (this.Y[_idx - 1] - this.Y[_idx]) / (this.Vt[_idx - 1] - this.Vt[_idx])) / (this.Vt[_idx + 1] - this.Vt[_idx - 1]);
    }

    public double getGoodnessOfFit() {
        if (this.Vt == null) {
            return 0.0;
        }
        if (this.nExpt - this.nUnk > 0) {
            return this.chisq / (double)(this.nExpt - this.nUnk);
        }
        return 0.0;
    }

    public String getInfo() {
        return "Titration.class version 1.0  copyright 2001 David N. Blauch";
    }

    public double[] getPar() {
        return this.par;
    }

    public double[] getParStd() {
        if (this.par == null) {
            return null;
        }
        double[] _std = new double[this.par.length];
        for (int i = 0; i < this.par.length; ++i) {
            _std[i] = Math.sqrt(this.covar[i][i]);
        }
        return _std;
    }

    public void setChiSqTolerance(double _tol) {
        if (_tol > 0.0) {
            this.chisqTol = _tol;
        }
    }

    public void setData(double[] _Vt, double[] _Y) {
        double[] _std = new double[_Vt.length];
        for (int i = 0; i < _std.length; ++i) {
            _std[i] = this.STD;
        }
        this.setData(_Vt, _Y, _std);
    }

    public void setData(double[] _Vt, double[] _Y, double[] _std) {
        int i;
        if (_Vt.length != _Y.length || _Vt.length != _std.length) {
            System.out.println("Titration.setData:  Arrays are not of the same length");
            return;
        }
        if (_Vt[0] < 0.0) {
            System.out.println("Titration.setData:  Titrant volume cannot be negative");
            return;
        }
        for (i = 1; i < _Vt.length; ++i) {
            if (_Vt[i] <= _Vt[i - 1]) {
                System.out.println(String.valueOf(new StringBuffer("Titration.setData:  Vt must contain increasing volumes of titrant: ").append(i).append("  ").append(_Vt[i]).append("  ").append(_Vt[i - 1])));
                return;
            }
            if (!(_Vt[i] < 0.0)) continue;
            System.out.println("Titration.setData:  Titrant volume cannot be negative");
            return;
        }
        this.Vt = new double[_Vt.length];
        this.Y = new double[_Vt.length];
        this.std = new double[_Vt.length];
        this.nExpt = this.Vt.length;
        for (i = 0; i < this.nExpt; ++i) {
            this.Vt[i] = _Vt[i];
            this.Y[i] = _Y[i];
            this.std[i] = _std[i];
        }
    }

    public void setDisplayIterations(boolean _val) {
        this.displayIterations = _val;
    }

    public void setDisplayResults(boolean _val) {
        this.displayResults = _val;
    }

    public void setEquilibriaTolerance(double _tol) {
        if (_tol > 0.0) {
            this.equilTol = _tol;
        }
    }

    public void setLambda(double _lambda) {
        if (_lambda > 0.0) {
            this.LAMBDA = _lambda;
        }
    }

    public void setLambdaScaleFactor(double _factor) {
        if (_factor < 1.0 && _factor > 0.0) {
            this.lambdaFac = _factor;
        }
    }

    public void setMaxIncrement(double _val) {
        if (_val > 0.0) {
            this.MAXDEL = _val;
        }
    }

    public void setMinMaxIncrement(double _min, double _max) {
        if (_min >= 0.0 && _max > _min) {
            this.minInc = _min;
            this.maxInc = _max;
        }
    }

    public void setMonitor(String _chemSpecies) {
        if (this.chemSystem.getPhase(this.sampleLabel).getSpecies(_chemSpecies) == null) {
            System.out.println("Titration.setMonitor:  ChemSpecies not found in Sample Solution");
        } else {
            this.monMode = 0;
            this.monSpecies = _chemSpecies;
            this.target = 0.2;
            this.STD = 0.03;
        }
    }

    public void setMonitor(String _label, String _refLabel) {
        int i;
        HalfReaction[] _hr = this.chemSystem.getHalfReactions();
        boolean _flag = true;
        for (i = 0; i < _hr.length; ++i) {
            if (!_hr[i].getPhase().getLabel().equals(_label)) continue;
            this.monHalfReaction = _label;
            _flag = false;
            break;
        }
        if (_flag) {
            System.out.println("Titration.setMonitor:  No half-reaction defined for phase ".concat(String.valueOf(_label)));
            return;
        }
        if (_refLabel != null) {
            _flag = true;
            for (i = 0; i < _hr.length; ++i) {
                if (!_hr[i].getPhase().getLabel().equals(_refLabel)) continue;
                this.monRefHalfReaction = _refLabel;
                _flag = false;
                break;
            }
            if (_flag) {
                System.out.println("Titration.setMonitor:  No half-reaction defined for phase ".concat(String.valueOf(_refLabel)));
                return;
            }
            this.monMode = 2;
        } else {
            this.monMode = 1;
        }
        this.target = 0.01;
        this.STD = 0.005;
    }

    public void setStandardDeviation(double _std) {
        if (_std > 0.0) {
            this.STD = _std;
        }
    }

    public void setTargetIncrement(double _target) {
        if (_target > 0.0) {
            this.target = _target;
        }
    }

    public void setTolerance(double _tol) {
        if (_tol > 0.0) {
            this.tol = _tol;
        }
    }

    private void getY(double[] a) {
        int i;
        ChemSystem _cs = this.chemSystem.copyOf("Titration");
        for (i = 0; i < this.nRxn; ++i) {
            _cs.getReaction(this.rLabels[i]).setK(Math.exp(a[i]));
        }
        for (i = 0; i < this.nSp; ++i) {
            _cs.getPhase(this.pLabels[i]).getSpecies(this.sLabels[i]).setAnalMoles(Math.exp(a[this.nRxn + i]));
        }
        double[] _y = this.calc(this.Vt, _cs);
        if (this.abortFit) {
            return;
        }
        for (i = 0; i < this.nExpt; ++i) {
            this.y[i][0] = _y[i];
        }
        for (int j = 0; j < this.nUnk; ++j) {
            int i2;
            _cs = this.chemSystem.copyOf("Titration");
            for (i2 = 0; i2 < this.nRxn; ++i2) {
                if (i2 == j) {
                    _cs.getReaction(this.rLabels[i2]).setK(Math.exp(a[i2] * 1.001));
                    continue;
                }
                _cs.getReaction(this.rLabels[i2]).setK(Math.exp(a[i2]));
            }
            for (i2 = 0; i2 < this.nSp; ++i2) {
                if (i2 + this.nRxn == j) {
                    _cs.getPhase(this.pLabels[i2]).getSpecies(this.sLabels[i2]).setAnalMoles(Math.exp(a[this.nRxn + i2] * 1.001));
                    continue;
                }
                _cs.getPhase(this.pLabels[i2]).getSpecies(this.sLabels[i2]).setAnalMoles(Math.exp(a[this.nRxn + i2]));
            }
            _y = this.calc(this.Vt, _cs);
            if (this.abortFit) {
                return;
            }
            for (i2 = 0; i2 < this.nExpt; ++i2) {
                this.y[i2][j + 1] = _y[i2];
            }
        }
    }

    private void mrqcof(double[] a) {
        int j;
        double[] dyda = new double[this.nUnk];
        for (j = 0; j < this.nUnk; ++j) {
            this.beta[j] = 0.0;
            for (int k = 0; k < j; ++k) {
                this.alpha[j][k] = 0.0;
            }
        }
        this.chisq = 0.0;
        this.getY(a);
        if (this.abortFit) {
            return;
        }
        for (int i = 0; i < this.nExpt; ++i) {
            double w = 1.0 / (this.std[i] * this.std[i]);
            double dy = this.Y[i] - this.y[i][0];
            for (int j2 = 0; j2 < this.nUnk; ++j2) {
                dyda[j2] = (this.y[i][j2 + 1] - this.y[i][0]) / (0.001 * a[j2]);
                double wt = dyda[j2] * w;
                int n = j2;
                this.beta[n] = this.beta[n] + dy * wt;
                for (int k = 0; k <= j2; ++k) {
                    double[] dArray = this.alpha[j2];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + wt * dyda[k];
                }
            }
            this.chisq += dy * dy * w;
        }
        for (j = 1; j < this.nUnk; ++j) {
            for (int k = 0; k < j; ++k) {
                this.alpha[k][j] = this.alpha[j][k];
            }
        }
    }

    private void mrqmin() {
        int j;
        double[] atry = new double[this.nUnk];
        for (j = 0; j < this.nUnk; ++j) {
            for (int k = 0; k < this.nUnk; ++k) {
                this.covar[j][k] = this.alpha[j][k];
            }
            this.covar[j][j] = this.alpha[j][j] * (1.0 + this.lambda);
            this.del[j] = this.beta[j];
        }
        if (this.abortFit) {
            return;
        }
        this.gaussj();
        for (j = 0; j < this.nUnk; ++j) {
            double _del = this.del[j];
            if (_del > this.MAXDEL) {
                _del = this.MAXDEL;
            } else if (_del < -this.MAXDEL) {
                _del = -this.MAXDEL;
            }
            atry[j] = this.par[j] + _del;
        }
        this.mrqcof(atry);
        if (this.abortFit) {
            return;
        }
        if (this.chisq < this.ochisq) {
            this.lambda *= this.lambdaFac;
            this.ochisq = this.chisq;
            for (j = 0; j < this.nUnk; ++j) {
                this.par[j] = atry[j];
            }
        } else {
            this.lambda /= this.lambdaFac;
            this.chisq = this.ochisq;
        }
    }

    private void gaussj() {
        int[] indxc = new int[this.nUnk];
        int[] indxr = new int[this.nUnk];
        int[] ipiv = new int[this.nUnk];
        int irow = 0;
        int icol = 0;
        for (int j = 0; j < this.nUnk; ++j) {
            ipiv[j] = 0;
        }
        for (int i = 0; i < this.nUnk; ++i) {
            int l;
            double big = 0.0;
            for (int j = 0; j < this.nUnk; ++j) {
                if (ipiv[j] == 1) continue;
                for (int k = 0; k < this.nUnk; ++k) {
                    if (ipiv[k] == 0) {
                        if (!(Math.abs(this.covar[j][k]) >= big)) continue;
                        big = Math.abs(this.covar[j][k]);
                        irow = j;
                        icol = k;
                        continue;
                    }
                    if (ipiv[k] <= 1) continue;
                    System.out.println("Titration.gaussj:  Singular Matrix (1)");
                    this.abortFit = true;
                    return;
                }
            }
            int n = icol;
            ipiv[n] = ipiv[n] + 1;
            if (irow != icol) {
                double tmp = this.del[irow];
                this.del[irow] = this.del[icol];
                this.del[icol] = tmp;
                for (l = 0; l < this.nUnk; ++l) {
                    tmp = this.covar[irow][l];
                    this.covar[irow][l] = this.covar[icol][l];
                    this.covar[icol][l] = tmp;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (this.covar[icol][icol] == 0.0) {
                System.out.println("Titration.gaussj:  Singular Matrix (2)");
                this.abortFit = true;
                return;
            }
            double pivinv = 1.0 / this.covar[icol][icol];
            this.covar[icol][icol] = 1.0;
            int n2 = icol;
            this.del[n2] = this.del[n2] * pivinv;
            l = 0;
            while (l < this.nUnk) {
                double[] dArray = this.covar[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            for (int ll = 0; ll < this.nUnk; ++ll) {
                if (ll == icol) continue;
                double dum = this.covar[ll][icol];
                this.covar[ll][icol] = 0.0;
                int n4 = ll;
                this.del[n4] = this.del[n4] - this.del[icol] * dum;
                for (int l2 = 0; l2 < this.nUnk; ++l2) {
                    double[] dArray = this.covar[ll];
                    int n5 = l2;
                    dArray[n5] = dArray[n5] - this.covar[icol][l2] * dum;
                }
            }
        }
        for (int l = this.nUnk - 1; l >= 0; --l) {
            if (indxr[l] == indxc[l]) continue;
            for (int k = 0; k < this.nUnk; ++k) {
                double tmp = this.covar[k][indxr[l]];
                this.covar[k][indxr[l]] = this.covar[k][indxc[l]];
                this.covar[k][indxc[l]] = tmp;
            }
        }
    }

    private double getValue(ChemSystem _cs, Phase _sample) {
        switch (this.monMode) {
            case 0: {
                double _X = _sample.getSpecies(this.monSpecies).getActivity();
                if (_X > 0.0) {
                    return -Math.log(_X) / Math.log(10.0);
                }
                return 200.0 / Math.log(10.0);
            }
            case 1: {
                HalfReaction _hr = this.getHalfReaction(_cs, this.monHalfReaction);
                return _hr.getPotential();
            }
            case 2: {
                HalfReaction _hr = this.getHalfReaction(_cs, this.monHalfReaction);
                HalfReaction _hrRef = this.getHalfReaction(_cs, this.monRefHalfReaction);
                return _hr.getPotential() - _hrRef.getPotential();
            }
        }
        return 0.0;
    }

    private HalfReaction getHalfReaction(ChemSystem _cs, String _phaseLabel) {
        HalfReaction[] _hr = _cs.getHalfReactions();
        for (int i = 0; i < _hr.length; ++i) {
            if (!_hr[i].getPhase().getLabel().equals(_phaseLabel)) continue;
            return _hr[i];
        }
        return null;
    }

    private double[] calc(double[] _Vt, ChemSystem _chemSystem) {
        double[] _val = new double[_Vt.length];
        Phase _titrant = _chemSystem.getPhase(this.titrantLabel);
        Phase _sample = _chemSystem.getPhase(this.sampleLabel);
        Equilibria equil = new Equilibria(_chemSystem);
        equil.setUsePrevious(false);
        equil.setTolerance(this.equilTol);
        if (_Vt[0] > 0.0) {
            _chemSystem.transferSolution(_titrant, _sample, _Vt[0] / 1000.0);
        }
        if (!equil.solveProblem()) {
            String[] _mes = equil.getMessages();
            if (!_mes[0].equals("no messages")) {
                for (int i = 0; i < _mes.length; ++i) {
                    System.out.println(_mes[i]);
                }
            }
            this.abortFit = true;
            _val[0] = 0.0;
        } else {
            _val[0] = this.getValue(_chemSystem, _sample);
        }
        equil.setUsePrevious(true);
        for (int i = 1; i < _Vt.length; ++i) {
            _chemSystem.transferSolution(_titrant, _sample, (_Vt[i] - _Vt[i - 1]) / 1000.0);
            if (!equil.solveProblem()) {
                String[] _mes = equil.getMessages();
                if (!_mes[0].equals("no messages")) {
                    for (int ii = 0; ii < _mes.length; ++ii) {
                        System.out.println(_mes[ii]);
                    }
                }
                this.abortFit = true;
                _val[i] = 0.0;
                continue;
            }
            _val[i] = this.getValue(_chemSystem, _sample);
        }
        return _val;
    }
}

