/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.PhysicalConstants;

public class Species
implements PhysicalConstants {
    protected final double FW = 100.0;
    protected final char PHYSSTATE = 'd';
    protected final double IONSIZE = 4.5;
    protected final String[] RESERVED = new String[]{"acid", "base"};
    protected ChemSpecies chemSpecies;
    protected Phase phase;
    protected ChemSystem chemSystem;
    protected boolean isSolvent = false;
    protected boolean isReactive;
    protected int index = 0;
    protected boolean isAcid = false;
    protected boolean isBase = false;
    protected double moles;
    protected double analMoles;

    public Species() {
    }

    public Species(ChemSpecies _chemSpecies, Phase _phase) {
        this.chemSpecies = _chemSpecies;
        this.phase = _phase;
        this.chemSystem = this.phase.getChemSystem();
        this.isSolvent = false;
        this.setAnalMoles(0.0);
    }

    public Species(ChemSpecies _chemSpecies, Phase _phase, double _moles) {
        this.chemSpecies = _chemSpecies;
        this.phase = _phase;
        this.chemSystem = this.phase.getChemSystem();
        this.isSolvent = false;
        this.setAnalMoles(_moles);
    }

    public double getActivityCoefficient() {
        if (this.chemSystem.getIsIdeal() || this.getPhysicalState() != 'd') {
            return 1.0;
        }
        double u = Math.sqrt(this.phase.getIonicStrength());
        double _charge = this.chemSpecies.getCharge();
        double lnf = -this.phase.getEDHEa() * _charge * u / (1.0 + this.phase.getEDHEb() * this.chemSpecies.getIonSize() * u);
        return Math.exp(lnf);
    }

    public double getActivity() {
        if (this.getPhysicalState() == 'd') {
            return this.getConc() * this.getActivityCoefficient();
        }
        if (this.getPhysicalState() == 'g') {
            return this.getPressure() * this.getActivityCoefficient();
        }
        return 1.0;
    }

    public double getAnalConc() {
        return this.analMoles / this.phase.getVolume();
    }

    public double getAnalMass() {
        return this.analMoles * this.chemSpecies.getFW();
    }

    public double getAnalMoles() {
        return this.analMoles;
    }

    public double getAnalPressure() {
        if (this.getPhysicalState() == 'g') {
            return this.analMoles * 0.08205783 * this.chemSystem.getTemperature() / this.phase.getVolume();
        }
        return this.chemSystem.getPressure();
    }

    public double getCharge() {
        return this.chemSpecies.getCharge();
    }

    public ChemSpecies getChemSpecies() {
        return this.chemSpecies;
    }

    public ChemSystem getChemSystem() {
        return this.chemSystem;
    }

    public double getConc() {
        return this.moles / this.phase.getVolume();
    }

    public double getFW() {
        return this.chemSpecies.getFW();
    }

    public String getInfo() {
        return "Species.class version 2.0  copyright 2000-2001 David N. Blauch";
    }

    public double getIonSize() {
        return this.chemSpecies.getIonSize();
    }

    public String getLabel() {
        return this.chemSpecies.getLabel();
    }

    public double getMass() {
        return this.moles * this.chemSpecies.getFW();
    }

    public double getMoles() {
        return this.moles;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public char getPhysicalState() {
        if (this.isSolvent) {
            return 'l';
        }
        return this.phase.getPhysicalState();
    }

    public double getPressure() {
        if (this.getPhysicalState() == 'g') {
            return this.phase.getPressure(this.moles, this.phase.getVolume());
        }
        return this.chemSystem.getPressure();
    }

    public boolean isEquivalent(Species _sp) {
        ChemSpecies _solv2;
        if (!this.chemSpecies.equals(_sp.getChemSpecies())) {
            return false;
        }
        if (!String.valueOf(this.getPhysicalState()).equals(String.valueOf(_sp.getPhysicalState()))) {
            return false;
        }
        if (this.getPhysicalState() != 'd') {
            return true;
        }
        ChemSpecies _solv1 = this.getPhase().getSolvent().getChemSpecies();
        return _solv1.equals(_solv2 = _sp.getPhase().getSolvent().getChemSpecies());
    }

    public void setAnalConc(double _analConc) {
        if (_analConc >= 0.0) {
            this.analMoles = _analConc * this.phase.getVolume();
        }
    }

    public void setAnalMass(double _analMass) {
        if (_analMass >= 0.0) {
            this.analMoles = _analMass / this.chemSpecies.getFW();
        }
    }

    public void setAnalMoles(double _analMoles) {
        if (_analMoles >= 0.0) {
            this.analMoles = _analMoles;
        }
    }

    public void setAnalPressure(double _analPressure) {
        if (_analPressure >= 0.0 && this.getPhysicalState() == 'g') {
            this.analMoles = _analPressure * this.phase.getVolume() / (0.08205783 * this.chemSystem.getTemperature());
        }
    }

    public void setFW(double _fw) {
        this.chemSpecies.setFW(_fw);
    }

    public void setIonSize(double _ionSize) {
        this.chemSpecies.setIonSize(_ionSize);
    }

    public void setLabel(String _label) {
        this.chemSpecies.setLabel(_label);
    }

    protected int getIndex() {
        return this.index;
    }

    protected boolean getIsAcid() {
        return this.isAcid;
    }

    protected boolean getIsBase() {
        return this.isBase;
    }

    protected boolean getIsReactive() {
        return this.isReactive;
    }

    protected boolean getIsSolvent() {
        return this.isSolvent;
    }

    protected void setIndex(int _index) {
        this.index = _index;
    }

    protected void setIsAcid(boolean _isAcid) {
        this.isAcid = _isAcid;
    }

    protected void setIsBase(boolean _isBase) {
        this.isBase = _isBase;
    }

    protected void setIsReactive(boolean _isReactive) {
        this.isReactive = _isReactive;
    }

    protected void setIsSolvent(boolean _isSolvent) {
        this.isSolvent = _isSolvent;
    }

    protected void setMoles(double _moles) {
        if (_moles >= 0.0) {
            this.moles = _moles;
        }
    }
}

