/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class Solution
extends Phase {
    protected Species acid = null;
    protected Species base = null;
    protected Species solvent = null;
    protected Reaction autodissociation = null;

    public Solution() {
    }

    public Solution(String _label, ChemSystem _chemSystem, ChemSpecies _chemSpecies) {
        this.chemSystem = _chemSystem;
        this.label = _label;
        this.physState = (char)100;
        this.solvent = new Species(_chemSpecies, this);
        this.species = new Vector();
        this.species.addElement(this.solvent);
        this.density = 1.0;
        this.volume = 1.0;
        this.isProtic = false;
        this.solvent.setIsSolvent(true);
        this.solvent.setAnalMoles(1000.0 / this.solvent.getFW());
        this.addSpecies(_chemSystem.getCationCounterion(), 0.0);
        this.addSpecies(_chemSystem.getAnionCounterion(), 0.0);
    }

    public Solution(String _label, ChemSystem _chemSystem, ChemSpecies _chemSpecies, double _Kauto) {
        this.chemSystem = _chemSystem;
        this.solvent = new Species(_chemSpecies, this);
        this.label = _label;
        this.physState = (char)100;
        this.species = new Vector();
        this.species.addElement(this.solvent);
        this.density = 1.0;
        this.volume = 1.0;
        this.isProtic = true;
        this.solvent.setIsSolvent(true);
        this.solvent.setAnalMoles(1000.0 / this.solvent.getFW());
        ChemSpecies _chemAcid = new ChemSpecies("acid_".concat(String.valueOf(this.solvent.getLabel())), 1.0, this.solvent.getFW() + 1.00797);
        this.acid = new Species(_chemAcid, this);
        this.acid.setIsAcid(true);
        this.species.addElement(this.acid);
        ChemSpecies _chemBase = new ChemSpecies("base_".concat(String.valueOf(this.solvent.getLabel())), -1.0, this.solvent.getFW() - 1.00797);
        this.base = new Species(_chemBase, this);
        this.base.setIsBase(true);
        this.species.addElement(this.base);
        Species[] _sp = new Species[3];
        double[] _coef = new double[3];
        _sp[0] = this.solvent;
        _sp[1] = this.acid;
        _sp[2] = this.base;
        _coef[0] = -1.0;
        _coef[1] = 1.0;
        _coef[2] = 1.0;
        this.autodissociation = new Reaction("autodissociation", _sp, _coef, _Kauto);
        this.autodissociation.setIsAuto(true);
        this.chemSystem.addReaction(this.autodissociation);
        this.addSpecies(_chemSystem.getCationCounterion(), 0.0);
        this.addSpecies(_chemSystem.getAnionCounterion(), 0.0);
    }

    public Solution(String _label, ChemSystem _chemSystem, ChemSpecies _chemSpecies, ChemSpecies _acid, ChemSpecies _base, double _Kauto) {
        this.chemSystem = _chemSystem;
        this.solvent = new Species(_chemSpecies, this);
        this.acid = new Species(_acid, this);
        this.base = new Species(_base, this);
        this.label = _label;
        this.physState = (char)100;
        this.species = new Vector();
        this.species.addElement(this.solvent);
        this.density = 1.0;
        this.volume = 1.0;
        this.isProtic = true;
        this.solvent.setIsSolvent(true);
        this.solvent.setAnalMoles(1000.0 / this.solvent.getFW());
        this.acid.setIsAcid(true);
        this.species.addElement(this.acid);
        this.base.setIsBase(true);
        this.species.addElement(this.base);
        Species[] _sp = new Species[3];
        double[] _coef = new double[3];
        _sp[0] = this.solvent;
        _sp[1] = this.acid;
        _sp[2] = this.base;
        _coef[0] = -1.0;
        _coef[1] = 1.0;
        _coef[2] = 1.0;
        this.autodissociation = new Reaction("autodissociation", _sp, _coef, _Kauto);
        this.autodissociation.setIsAuto(true);
        this.chemSystem.addReaction(this.autodissociation);
        this.addSpecies(_chemSystem.getCationCounterion(), 0.0);
        this.addSpecies(_chemSystem.getAnionCounterion(), 0.0);
    }

    public Phase copyOf(ChemSystem _chemSystem) {
        Species _newSp;
        Solution _soln;
        Species _sp = this.getSolvent();
        if (this.getIsProtic()) {
            _soln = new Solution(this.getLabel(), _chemSystem, this.getSolvent().getChemSpecies(), this.getAcid().getChemSpecies(), this.getBase().getChemSpecies(), this.getAutodissociation().getK());
            _soln.setDensity(this.getDensity());
            _newSp = _soln.getSolvent();
            _newSp.setAnalMoles(_sp.getAnalMoles());
            _newSp.setMoles(_sp.getMoles());
            Reaction _rxn = this.getAutodissociation();
            Reaction _newRxn = _soln.getAutodissociation();
            _newRxn.setReferenceTemperature(_rxn.getReferenceTemperature());
            double[] _val = _rxn.getTemperatureDependence();
            _newRxn.setTemperatureDependence(_val[0], _val[1]);
        } else {
            _soln = new Solution(this.getLabel(), _chemSystem, this.getSolvent().getChemSpecies());
            _soln.setDensity(this.getDensity());
            _newSp = _soln.getSolvent();
            _newSp.setAnalMoles(_sp.getAnalMoles());
            _newSp.setMoles(_sp.getMoles());
        }
        _soln.removeSpecies(_soln.getSpecies("X+"));
        _soln.removeSpecies(_soln.getSpecies("X-"));
        for (int i = 0; i < this.species.size(); ++i) {
            _sp = (Species)this.species.elementAt(i);
            if (_sp.getIsSolvent()) continue;
            _newSp = _soln.addSpecies(_sp.getChemSpecies(), _sp.getAnalMoles());
            _newSp.setMoles(_sp.getMoles());
        }
        _soln.setVolume(this.getVolume());
        _soln.setAutoChargeBalance(this.getAutoChargeBalance());
        _soln.setDielectricConstant(this.getDielectricConstant());
        return _soln;
    }

    public Species getAcid() {
        return this.acid;
    }

    public Reaction getAutodissociation() {
        return this.autodissociation;
    }

    public Species getBase() {
        return this.base;
    }

    public String getInfo() {
        return "Solution.class version 1.2  copyright 2000-2001 David N. Blauch";
    }

    public double getIonicStrength() {
        double u = 0.0;
        for (int i = 0; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            double _charge = _sp.getCharge();
            u += _sp.getConc() * _charge * _charge;
        }
        return u /= 2.0;
    }

    public double getpH() {
        if (this.isProtic) {
            return -Math.log(this.acid.getActivity()) / Math.log(10.0);
        }
        return 0.0;
    }

    public double getpOH() {
        if (this.isProtic) {
            return -Math.log(this.base.getActivity()) / Math.log(10.0);
        }
        return 0.0;
    }

    public double getPressure() {
        return this.chemSystem.getPressure();
    }

    public Species getSolvent() {
        return this.solvent;
    }

    public void scale(double _factor) {
        double _vol = this.getVolume();
        super.scale(_factor);
        this.setVolume(_factor * _vol);
    }

    public void setDensity(double _density) {
        if (_density <= 0.0) {
            return;
        }
        this.density = _density;
        this.volume = this.getMass() / (1000.0 * this.density);
    }

    public double getVolume() {
        return this.volume;
    }

    public void setMass(double _mass) {
        if (_mass < 0.0) {
            return;
        }
        Species _solvent = (Species)this.species.elementAt(0);
        _solvent.setAnalMoles(_mass / _solvent.getFW());
        this.volume = this.getMass() / (1000.0 * this.density);
    }

    public void setVolume(double _volume) {
        if (_volume <= 0.0) {
            return;
        }
        double mass = 0.0;
        for (int i = 1; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            mass += _sp.getMass();
        }
        Species _solvent = (Species)this.species.elementAt(0);
        double _mass = this.density * _volume * 1000.0 - mass;
        _solvent.setAnalMoles(_mass / _solvent.getFW());
        this.volume = _volume;
    }
}

