/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Species;

public class Reaction {
    private String label;
    private Species[] species;
    private double[] coef;
    private double K;
    private double a = 0.0;
    private double b = 0.0;
    private double refTemperature = 298.15;
    private boolean isAuto = false;
    private boolean isHomogeneous = true;
    private Phase phase = null;
    private boolean isValid = true;
    private int index = 0;

    public Reaction() {
    }

    public Reaction(Species[] _species, double[] _coef, double _K) {
        int i;
        this.label = " ";
        int n = _species.length;
        this.species = new Species[n];
        this.coef = new double[n];
        for (i = 0; i < n; ++i) {
            this.species[i] = _species[i];
            this.coef[i] = _coef[i];
        }
        this.K = _K;
        this.isAuto = false;
        this.setIsValid(true);
        this.phase = this.species[0].getPhase();
        this.isHomogeneous = true;
        for (i = 1; i < this.species.length; ++i) {
            if (this.phase.equals(this.species[i].getPhase())) continue;
            this.isHomogeneous = false;
            break;
        }
    }

    public Reaction(String _label, Species[] _species, double[] _coef, double _K) {
        int i;
        this.label = _label;
        int n = _species.length;
        this.species = new Species[n];
        this.coef = new double[n];
        for (i = 0; i < n; ++i) {
            this.species[i] = _species[i];
            this.coef[i] = _coef[i];
        }
        this.K = _K;
        this.isAuto = false;
        this.setIsValid(true);
        this.phase = this.species[0].getPhase();
        this.isHomogeneous = true;
        for (i = 1; i < this.species.length; ++i) {
            if (this.phase.equals(this.species[i].getPhase())) continue;
            this.isHomogeneous = false;
            break;
        }
    }

    public Reaction copyOf(ChemSystem _chemSystem) {
        Species[] _sp = new Species[this.species.length];
        double[] _coef = new double[this.coef.length];
        for (int i = 0; i < this.species.length; ++i) {
            String _label = this.species[i].getPhase().getLabel();
            Phase _ph = _chemSystem.getPhase(_label);
            if (_ph == null) {
                return null;
            }
            _sp[i] = _ph.getSpecies(this.species[i].getChemSpecies());
            if (_sp[i] == null) {
                return null;
            }
            _coef[i] = this.coef[i];
        }
        Reaction _rxn = new Reaction(this.getLabel(), _sp, _coef, this.getK());
        _rxn.setReferenceTemperature(this.getReferenceTemperature());
        double[] _val = this.getTemperatureDependence();
        _rxn.setTemperatureDependence(_val[0], _val[1]);
        _rxn.setIsAuto(this.getIsAuto());
        return _rxn;
    }

    public double getCoefficient(Species _species) {
        double c = 0.0;
        for (int i = 0; i < this.species.length; ++i) {
            if (_species != this.species[i]) continue;
            c = this.coef[i];
            break;
        }
        return c;
    }

    public double getCoefficient(String _label) {
        double c = 0.0;
        for (int i = 0; i < this.species.length; ++i) {
            if (_label != this.species[i].getLabel()) continue;
            c = this.coef[i];
            break;
        }
        return c;
    }

    public double[] getCoefficients() {
        return this.coef;
    }

    public String getEquation() {
        String _reactants = "";
        String _products = "";
        for (int i = 0; i < this.species.length; ++i) {
            if (this.coef[i] < 0.0) {
                if (!_reactants.equals("")) {
                    _reactants = String.valueOf(_reactants).concat(" + ");
                }
                if (this.coef[i] != -1.0) {
                    _reactants = String.valueOf(_reactants).concat(String.valueOf(String.valueOf(Double.toString(-this.coef[i])).concat(" ")));
                }
                _reactants = String.valueOf(_reactants).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(this.species[i].getLabel())).append(" (").append(this.species[i].getPhase().getLabel()).append(")"))));
                continue;
            }
            if (!_products.equals("")) {
                _products = String.valueOf(_products).concat(" + ");
            }
            if (this.coef[i] != 1.0) {
                _products = String.valueOf(_products).concat(String.valueOf(String.valueOf(Double.toString(this.coef[i])).concat(" ")));
            }
            _products = String.valueOf(_products).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(this.species[i].getLabel())).append(" (").append(this.species[i].getPhase().getLabel()).append(")"))));
        }
        return String.valueOf(new StringBuffer(String.valueOf(_reactants)).append(" = ").append(_products));
    }

    public String getInfo() {
        return "Reaction.class version 2.2  copyright 2000-2001 David N. Blauch";
    }

    public boolean getIsAuto() {
        return this.isAuto;
    }

    public boolean getIsHomogeneous() {
        return this.isHomogeneous;
    }

    public double getK() {
        return this.K;
    }

    public double getK(double _temperature) {
        if (_temperature <= 0.0) {
            return 0.0;
        }
        double _ln = this.a * (1.0 / _temperature - 1.0 / this.refTemperature) + this.b * Math.log(_temperature / this.refTemperature);
        return this.K * Math.exp(_ln);
    }

    public int getNbrSpecies() {
        return this.species.length;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public double getpK() {
        return -Math.log(this.K) / Math.log(10.0);
    }

    public double getpK(double _temperature) {
        return -Math.log(this.getK(_temperature)) / Math.log(10.0);
    }

    public String getLabel() {
        return this.label;
    }

    public double getReferenceTemperature() {
        return this.refTemperature;
    }

    public Species[] getSpecies() {
        return this.species;
    }

    public void setReferenceTemperature(double _temperature) {
        if (_temperature > 0.0) {
            this.refTemperature = _temperature;
        }
    }

    public void setTemperatureDependence(double _a, double _b) {
        this.a = _a;
        this.b = _b;
    }

    public double[] getTemperatureDependence() {
        double[] val = new double[]{this.a, this.b};
        return val;
    }

    public boolean isEquivalent(Reaction _rxn) {
        int i;
        if (_rxn.getK() != this.K) {
            return false;
        }
        double[] _KT = _rxn.getTemperatureDependence();
        if (_KT[0] != this.a) {
            return false;
        }
        if (_KT[1] != this.b) {
            return false;
        }
        Species[] _sp = _rxn.getSpecies();
        double[] _coef = _rxn.getCoefficients();
        if (_sp.length != this.species.length) {
            return false;
        }
        boolean[] sFlag = new boolean[_sp.length];
        for (i = 0; i < sFlag.length; ++i) {
            sFlag[i] = true;
        }
        for (i = 0; i < this.species.length; ++i) {
            boolean flag = true;
            for (int j = 0; j < _sp.length; ++j) {
                if (!sFlag[j] || !this.species[i].isEquivalent(_sp[j]) || this.coef[i] != _coef[j]) continue;
                sFlag[j] = false;
                flag = false;
                j = _sp.length;
            }
            if (!flag) continue;
            return false;
        }
        for (i = 0; i < _sp.length; ++i) {
            if (!sFlag[i]) continue;
            return false;
        }
        return true;
    }

    public void setIsAuto(boolean _isAuto) {
        this.isAuto = _isAuto;
    }

    public void setK(double _K) {
        if (_K > 0.0) {
            this.K = _K;
        }
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    protected int getIndex() {
        return this.index;
    }

    protected boolean getIsValid() {
        return this.isValid;
    }

    protected void setIndex(int _index) {
        this.index = _index;
    }

    protected void setIsValid(boolean _isValid) {
        this.isValid = _isValid;
    }
}

