/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.PhysicalConstants;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public abstract class Phase
implements PhysicalConstants {
    protected String label;
    protected Vector species;
    protected ChemSystem chemSystem;
    protected char physState;
    protected boolean isProtic = false;
    protected double density;
    protected double dielectricConstant = 78.4;
    protected double volume;
    protected boolean autoChargeBalance = false;

    public void addSpecies(Species _species) {
        Species[] _sp = this.getSpecies();
        for (int i = 0; i < _sp.length; ++i) {
            if (!_sp[i].getChemSpecies().equals(_species.getChemSpecies())) continue;
            this.removeSpecies(_sp[i]);
            break;
        }
        if (this.getPhysicalState() == 's' || this.getPhysicalState() == 'l') {
            this.species.removeAllElements();
        }
        this.species.addElement(_species);
    }

    public Species addSpecies(ChemSpecies _chemSpecies, double _moles) {
        Species _sp = this.getSpecies(_chemSpecies);
        if (_sp == null) {
            if (this.getPhysicalState() == 's' || this.getPhysicalState() == 'l') {
                this.species.removeAllElements();
            }
            _sp = new Species(_chemSpecies, this, _moles);
            this.species.addElement(_sp);
        } else {
            double _m = _sp.getAnalMoles() + _moles;
            _sp.setAnalMoles(_m);
        }
        return _sp;
    }

    public Species addSpecies(String _chemSpeciesLabel, double _moles) {
        Species _s = this.getSpecies(_chemSpeciesLabel);
        if (_s == null) {
            return null;
        }
        double _m = _s.getAnalMoles() + _moles;
        _s.setAnalMoles(_m);
        return _s;
    }

    public Species[] createSpecies(ChemSpecies[] _chemSpecies, double[] _moles) {
        Species[] _sp = new Species[_chemSpecies.length];
        if (_chemSpecies.length != _moles.length) {
            return null;
        }
        for (int i = 0; i < _chemSpecies.length; ++i) {
            _sp[i] = this.createSpecies(_chemSpecies[i], _moles[i]);
        }
        return _sp;
    }

    public abstract Phase copyOf(ChemSystem var1);

    public Species createSpecies(ChemSpecies _chemSpecies, double _moles) {
        Species _sp = this.getSpecies(_chemSpecies);
        if (_sp == null) {
            if (this.getPhysicalState() == 's' || this.getPhysicalState() == 'l') {
                this.species.removeAllElements();
            }
            _sp = new Species(_chemSpecies, this, _moles);
            this.species.addElement(_sp);
        } else {
            double _m = _sp.getAnalMoles() + _moles;
            _sp.setAnalMoles(_m);
        }
        return _sp;
    }

    public abstract Species getAcid();

    public boolean getAutoChargeBalance() {
        return this.autoChargeBalance;
    }

    public abstract Species getBase();

    public ChemSystem getChemSystem() {
        return this.chemSystem;
    }

    public double getDensity() {
        return this.density;
    }

    public double getDielectricConstant() {
        return this.dielectricConstant;
    }

    public double getEDHEa() {
        double temp = this.chemSystem.getTemperature();
        double _x = Math.sqrt(3.7838200831266955E27);
        double _y = 2.5669721967659287E-38 / (Math.PI * 4 * this.dielectricConstant * 8.854187817E-12 * 1.380658E-23 * temp);
        return _x * _y * Math.sqrt(_y);
    }

    public double getEDHEb() {
        double temp = this.chemSystem.getTemperature();
        return 1.60217733E-29 * Math.sqrt(3.7838200831266955E27 / (this.dielectricConstant * 8.854187817E-12 * 1.380658E-23 * temp));
    }

    public String getInfo() {
        return "Phase.class version 2.2  copyright 2000-2001 David N. Blauch";
    }

    public abstract double getIonicStrength();

    public boolean getIsProtic() {
        return this.isProtic;
    }

    public String getLabel() {
        return this.label;
    }

    public double getMass() {
        double mass = 0.0;
        for (int i = 0; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            mass += _sp.getMass();
        }
        return mass;
    }

    public double getMoles() {
        double _moles = 0.0;
        for (int i = 0; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            _moles += _sp.getMoles();
        }
        return _moles;
    }

    public int getNbrSpecies() {
        return this.species.size();
    }

    public double getpH() {
        return 0.0;
    }

    public char getPhysicalState() {
        return this.physState;
    }

    public double getpOH() {
        return 0.0;
    }

    public abstract double getPressure();

    public double getPressure(double _moles, double _volume) {
        return this.chemSystem.getPressure();
    }

    public abstract Species getSolvent();

    public Species getSpecies(String _label) {
        Species s = null;
        for (int i = 0; i < this.species.size(); ++i) {
            Species ss = (Species)this.species.elementAt(i);
            if (!ss.getLabel().equals(_label)) continue;
            s = ss;
            break;
        }
        return s;
    }

    public Species getSpecies(ChemSpecies _chemSpecies) {
        Species _sp = null;
        for (int i = 0; i < this.species.size(); ++i) {
            Species _s = (Species)this.species.elementAt(i);
            if (!_s.getChemSpecies().equals(_chemSpecies)) continue;
            _sp = _s;
            break;
        }
        return _sp;
    }

    public Species[] getSpecies() {
        if (this.species.size() == 0) {
            return null;
        }
        Object[] s = new Species[this.species.size()];
        this.species.copyInto(s);
        return s;
    }

    public Species getSpeciesAt(int _index) {
        if (_index >= 0 && _index < this.species.size()) {
            Species s = (Species)this.species.elementAt(_index);
            return s;
        }
        return null;
    }

    public abstract double getVolume();

    public boolean removeSpecies(Species _species) {
        if (this.getNbrSpecies() <= 1) {
            System.out.println("Phase.removeSpecies:  Cannot remove last Species in a Phase");
            return false;
        }
        boolean deleted = this.species.removeElement(_species);
        return deleted;
    }

    public boolean removeSpecies(String _label) {
        if (this.getNbrSpecies() <= 1) {
            System.out.println("Phase.removeSpecies:  Cannot remove last Species in a Phase");
            return false;
        }
        int i = 0;
        while (i < this.species.size()) {
            Species s = (Species)this.species.elementAt(i);
            if (s.getLabel() != _label) continue;
            this.species.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void scale(double _factor) {
        for (int i = 0; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            _sp.setAnalMoles(_factor * _sp.getAnalMoles());
            _sp.setMoles(_factor * _sp.getMoles());
        }
    }

    public void setAutoChargeBalance(boolean _val) {
        this.autoChargeBalance = _val;
    }

    public abstract void setDensity(double var1);

    public void setDielectricConstant(double _dielectricConstant) {
        if (_dielectricConstant > 0.0) {
            this.dielectricConstant = _dielectricConstant;
        }
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    public abstract void setMass(double var1);

    public abstract void setVolume(double var1);
}

