/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class Liquid
extends Phase {
    public Liquid() {
    }

    public Liquid(String _label, ChemSystem _chemSystem, ChemSpecies _chemSpecies) {
        this.label = _label;
        this.physState = (char)108;
        this.chemSystem = _chemSystem;
        Species _species = new Species(_chemSpecies, this);
        this.species = new Vector();
        this.species.addElement(_species);
        this.density = 1.0;
        this.volume = 1.0;
        _species.setAnalMoles(1000.0 / _species.getFW());
        this.isProtic = false;
    }

    public Phase copyOf(ChemSystem _chemSystem) {
        Liquid _liquid = new Liquid(this.getLabel(), _chemSystem, this.getSpeciesAt(0).getChemSpecies());
        _liquid.setDensity(this.getDensity());
        Species _sp = this.getSpeciesAt(0);
        Species _newSp = _liquid.getSpeciesAt(0);
        _newSp.setAnalMoles(_sp.getAnalMoles());
        _newSp.setMoles(_sp.getMoles());
        _liquid.setAutoChargeBalance(this.getAutoChargeBalance());
        _liquid.setDielectricConstant(this.getDielectricConstant());
        return _liquid;
    }

    public String getInfo() {
        return "Liquid.class version 1.1  copyright 2000-2001 David N. Blauch";
    }

    public Species getAcid() {
        return null;
    }

    public Species getBase() {
        return null;
    }

    public double getIonicStrength() {
        return 0.0;
    }

    public double getMass() {
        Species _species = (Species)this.species.elementAt(0);
        return _species.getMass();
    }

    public double getPressure() {
        return this.chemSystem.getPressure();
    }

    public Species getSolvent() {
        return null;
    }

    public double getVolume() {
        return this.getMass() / (1000.0 * this.density);
    }

    public void setDensity(double _density) {
        if (_density <= 0.0) {
            return;
        }
        this.density = _density;
    }

    public void setMass(double _mass) {
        if (_mass < 0.0) {
            return;
        }
        Species _species = (Species)this.species.elementAt(0);
        _species.setAnalMoles(_mass / _species.getFW());
    }

    public void setVolume(double _volume) {
        if (_volume <= 0.0) {
            return;
        }
        Species _species = (Species)this.species.elementAt(0);
        double _mass = this.density * _volume * 1000.0;
        _species.setAnalMoles(_mass / _species.getFW());
    }
}

