/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.PhysicalConstants;
import edu.davidson.chm.equilibria.Species;

public class HalfReaction
implements PhysicalConstants {
    private String label;
    private Species[] species;
    private double[] coef;
    private double nEquiv;
    private Phase phase = null;
    private double Eo;
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double refTemperature = 298.15;
    private boolean isValid = true;

    public HalfReaction() {
    }

    public HalfReaction(String _label, Species[] _species, double[] _coef, double _Eo, double _nEquiv, Phase _phase) {
        this.label = _label;
        int n = _species.length;
        this.species = new Species[n];
        this.coef = new double[n];
        for (int i = 0; i < n; ++i) {
            this.species[i] = _species[i];
            this.coef[i] = _coef[i];
        }
        this.Eo = _Eo;
        this.nEquiv = _nEquiv;
        this.phase = _phase;
    }

    public HalfReaction(Species[] _species, double[] _coef, double _Eo, double _nEquiv, Phase _phase) {
        this.label = " ";
        int n = _species.length;
        this.species = new Species[n];
        this.coef = new double[n];
        for (int i = 0; i < n; ++i) {
            this.species[i] = _species[i];
            this.coef[i] = _coef[i];
        }
        this.Eo = _Eo;
        this.nEquiv = _nEquiv;
        this.phase = _phase;
    }

    public HalfReaction copyOf(ChemSystem _chemSystem) {
        Phase _ph;
        String _label;
        Species[] _sp = new Species[this.species.length];
        double[] _coef = new double[this.coef.length];
        for (int i = 0; i < this.species.length; ++i) {
            _label = this.species[i].getPhase().getLabel();
            _ph = _chemSystem.getPhase(_label);
            if (_ph == null) {
                return null;
            }
            _sp[i] = _ph.getSpecies(this.species[i].getChemSpecies());
            if (_sp[i] == null) {
                return null;
            }
            _coef[i] = this.coef[i];
        }
        _label = this.phase.getLabel();
        _ph = _chemSystem.getPhase(_label);
        if (_ph == null) {
            return null;
        }
        HalfReaction _rxn = new HalfReaction(this.getLabel(), _sp, _coef, this.getStandardPotential(), this.getEquivalents(), _ph);
        _rxn.setReferenceTemperature(this.getReferenceTemperature());
        double[] _val = this.getTemperatureDependence();
        _rxn.setTemperatureDependence(_val[0], _val[1], _val[2]);
        return _rxn;
    }

    public double getCoefficient(Species _species) {
        double c = 0.0;
        for (int i = 0; i < this.species.length; ++i) {
            if (_species != this.species[i]) continue;
            c = this.coef[i];
            break;
        }
        return c;
    }

    public double getCoefficient(String _label) {
        double c = 0.0;
        for (int i = 0; i < this.species.length; ++i) {
            if (_label != this.species[i].getLabel()) continue;
            c = this.coef[i];
            break;
        }
        return c;
    }

    public double[] getCoefficients() {
        return this.coef;
    }

    public String getEquation() {
        String _reactants = "";
        String _products = "";
        for (int i = 0; i < this.species.length; ++i) {
            if (this.coef[i] < 0.0) {
                if (!_reactants.equals("")) {
                    _reactants = String.valueOf(_reactants).concat(" + ");
                }
                if (this.coef[i] != -1.0) {
                    _reactants = String.valueOf(_reactants).concat(String.valueOf(String.valueOf(Double.toString(-this.coef[i])).concat(" ")));
                }
                _reactants = String.valueOf(_reactants).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(this.species[i].getLabel())).append(" (").append(this.species[i].getPhase().getLabel()).append(")"))));
                continue;
            }
            if (!_products.equals("")) {
                _products = String.valueOf(_products).concat(" + ");
            }
            if (this.coef[i] != 1.0) {
                _products = String.valueOf(_products).concat(String.valueOf(String.valueOf(Double.toString(this.coef[i])).concat(" ")));
            }
            _products = String.valueOf(_products).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(this.species[i].getLabel())).append(" (").append(this.species[i].getPhase().getLabel()).append(")"))));
        }
        String _str = String.valueOf(new StringBuffer(String.valueOf(_reactants)).append(" + ").append(Double.toString(this.nEquiv)).append(" e- "));
        if (this.phase != null) {
            _str = String.valueOf(_str).concat(String.valueOf(String.valueOf(new StringBuffer("(").append(this.phase.getLabel()).append(")"))));
        }
        return String.valueOf(new StringBuffer(String.valueOf(_str)).append(" = ").append(_products));
    }

    public double getEquivalents() {
        return this.nEquiv;
    }

    public String getInfo() {
        return "HalfReaction.class version 1.0  copyright 2000-2001 David N. Blauch";
    }

    public String getLabel() {
        return this.label;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public double getPotential() {
        double _temperature = this.species[0].getChemSystem().getTemperature();
        double _E = 0.0;
        for (int i = 0; i < this.species.length; ++i) {
            _E += this.coef[i] * Math.log(this.species[i].getActivity());
        }
        return (_E *= -8.3145112119486 * _temperature / (this.nEquiv * 96485.3089890101)) + this.getStandardPotential(_temperature);
    }

    public double getReferenceTemperature() {
        return this.refTemperature;
    }

    public Species[] getSpecies() {
        return this.species;
    }

    public double getStandardPotential() {
        return this.Eo;
    }

    public double getStandardPotential(double _temperature) {
        if (_temperature <= 0.0) {
            return 0.0;
        }
        double _T = _temperature - this.refTemperature;
        return this.Eo + _T * (this.a + _T * (this.b + _T * this.c));
    }

    public double[] getTemperatureDependence() {
        double[] val = new double[]{this.a, this.b, this.c};
        return val;
    }

    public void setReferenceTemperature(double _temperature) {
        if (_temperature > 0.0) {
            this.refTemperature = _temperature;
        }
    }

    public void setStandardPotential(double _Eo) {
        this.Eo = _Eo;
    }

    public void setTemperatureDependence(double _a, double _b, double _c) {
        this.a = _a;
        this.b = _b;
        this.c = _c;
    }

    protected boolean getIsValid() {
        return this.isValid;
    }

    protected void setIsValid(boolean _isValid) {
        this.isValid = _isValid;
    }
}

