/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class Gas
extends Phase {
    public Gas() {
    }

    public Gas(String _label, ChemSystem _chemSystem) {
        this.label = _label;
        this.physState = (char)103;
        this.chemSystem = _chemSystem;
        this.species = new Vector();
        this.isProtic = false;
        this.volume = 1.0;
    }

    public Phase copyOf(ChemSystem _chemSystem) {
        Gas _gas = new Gas(this.getLabel(), _chemSystem);
        _gas.setVolume(this.getVolume());
        for (int i = 0; i < this.species.size(); ++i) {
            Species _sp = (Species)this.species.elementAt(i);
            Species _newSp = _gas.addSpecies(_sp.getChemSpecies(), _sp.getAnalMoles());
            _newSp.setMoles(_sp.getMoles());
        }
        _gas.setAutoChargeBalance(this.getAutoChargeBalance());
        _gas.setDielectricConstant(this.getDielectricConstant());
        return _gas;
    }

    public Species getAcid() {
        return null;
    }

    public Species getBase() {
        return null;
    }

    public double getDensity() {
        return this.getMass() / this.getVolume();
    }

    public String getInfo() {
        return "Gas.class version 1.1  copyright 2000-2001 David N. Blauch";
    }

    public double getPressure() {
        if (this.chemSystem.getIsIsobaric()) {
            return this.chemSystem.getPressure();
        }
        return this.getPressure(this.getMoles(), this.getVolume());
    }

    public double getPressure(double _moles, double _volume) {
        if (_moles <= 0.0 || _volume <= 0.0) {
            return 0.0;
        }
        return _moles * 0.08205783 * this.chemSystem.getTemperature() / _volume;
    }

    public double getIonicStrength() {
        return 0.0;
    }

    public void scale(double _factor) {
        super.scale(_factor);
        this.setVolume(_factor * this.getVolume());
    }

    public void setDensity(double _density) {
    }

    public double getVolume() {
        if (this.chemSystem.getIsIsobaric()) {
            return this.getMoles() * 0.08205783 * this.chemSystem.getTemperature() / this.chemSystem.getPressure();
        }
        return this.volume;
    }

    public void setMass(double _mass) {
    }

    public Species getSolvent() {
        return null;
    }

    public void setVolume(double _volume) {
        if (_volume > 0.0 && !this.chemSystem.getIsIsobaric()) {
            this.volume = _volume;
        }
    }
}

