/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.HalfReaction;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.PhysicalConstants;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class Equilibria
implements PhysicalConstants {
    private final double RES = 1.0E-15;
    private final double TOL = 1.0E-5;
    private final double EQNTOL = 1.0E-8;
    private final double REDUNDANT_TOL = 0.05;
    private final int MAXCNT = 50;
    private final double MAXINC = 10.0;
    private final double SVDTHRESHOLD = 1.0E-30;
    private final double SEED = 1.0E-9;
    private final double LNMIN = -700.0;
    private Vector mes = new Vector();
    private ChemSystem chemSystem;
    private Reaction[] reactions;
    private Species[] species;
    private Phase[] phases;
    private HalfReaction[] halfReactions;
    private Species[] uSpecies;
    private double[][] A;
    private int n;
    private int nSpecies;
    private int nAcidBase;
    private int nAuto;
    private int nRxn;
    private int nUnreactive;
    private int nMB;
    private Phase[] CB;
    private double[] func;
    private double[][] deriv;
    private double[] maxTerm;
    private double tol = 1.0E-5;
    private double eqnTol = 1.0E-8;
    private int maxCnt = 50;
    private double maxInc = 10.0;
    private double svdThreshold = 1.0E-30;
    private boolean usePrevious = false;
    private double redundantTol = 0.05;
    private boolean displayIterations = false;
    private boolean displayResults = false;
    private boolean displayLinearSystem = false;
    private boolean displayTime = false;

    public Equilibria() {
    }

    public Equilibria(ChemSystem _chemSystem) {
        this.chemSystem = _chemSystem;
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
    }

    public boolean parse() {
        int i;
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
        if (this.reactions != null) {
            for (i = 0; i < this.reactions.length; ++i) {
                this.reactions[i].setIsValid(true);
            }
        }
        if (this.halfReactions != null) {
            for (i = 0; i < this.halfReactions.length; ++i) {
                this.halfReactions[i].setIsValid(true);
            }
        }
        this.clearMessages();
        boolean _step0 = this.parse0();
        boolean _step1 = this.parse1();
        this.setReactions();
        return _step0 && _step1;
    }

    public String getInfo() {
        return "Equilibria.class version 2.3  copyright 2000-2001  David N. Blauch";
    }

    public void clearMessages() {
        this.mes = new Vector();
    }

    public String getChargeBalance(Phase _soln) {
        if (_soln.getSolvent() == null) {
            return null;
        }
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
        String _cation = "";
        String _anion = "";
        for (int i = 0; i < this.chemSystem.getNbrPhases(); ++i) {
            Phase _p = this.chemSystem.getPhase(i);
            if (!_p.equals(_soln)) continue;
            Species[] _sp = _p.getSpecies();
            for (int j = 0; j < _sp.length; ++j) {
                double _charge = _sp[j].getCharge();
                if (_charge < 0.0) {
                    if (!_anion.equals("")) {
                        _anion = String.valueOf(_anion).concat(" + ");
                    }
                    if (_charge != -1.0) {
                        _anion = String.valueOf(_anion).concat(String.valueOf(String.valueOf(Double.toString(-_charge)).concat(" ")));
                    }
                    _anion = String.valueOf(_anion).concat(String.valueOf(_sp[j].getLabel()));
                    continue;
                }
                if (!(_charge > 0.0)) continue;
                if (!_cation.equals("")) {
                    _cation = String.valueOf(_cation).concat(" + ");
                }
                if (_charge != 1.0) {
                    _cation = String.valueOf(_cation).concat(String.valueOf(String.valueOf(Double.toString(_charge)).concat(" ")));
                }
                _cation = String.valueOf(_cation).concat(String.valueOf(_sp[j].getLabel()));
            }
            return String.valueOf(new StringBuffer(String.valueOf(_cation)).append("  = ").append(_anion));
        }
        System.out.println("Equilibria.getChargeBalance:  Invalid Phase");
        return null;
    }

    public String[] getMassBalance() {
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
        if (!this.parse()) {
            System.out.println("Equilibria.getMassBalance:  Problems found in the Chemical System;  Cannot return mass balance equations.");
            String[] _mes = this.getMessages();
            for (int i = 1; i < _mes.length; ++i) {
                System.out.println(_mes[i]);
            }
            return null;
        }
        if (!this.createEquations()) {
            System.out.println("Equilibria.getMassBalance:  Error creating equations");
            return null;
        }
        String[] mb = new String[this.nMB];
        for (int i = 0; i < this.nMB; ++i) {
            int j;
            String _rt = "  ";
            double _anal = 0.0;
            double _sgn = 1.0;
            for (j = 0; j < this.nSpecies; ++j) {
                _anal += this.A[i][j] * this.uSpecies[j].getAnalMoles();
            }
            if (_anal < 0.0) {
                _anal = Math.abs(_anal);
                _sgn = -1.0;
            }
            for (j = 0; j < this.nSpecies; ++j) {
                double _c = _sgn * this.A[i][j];
                if (_c == 0.0) continue;
                if (_c > 0.0 && !_rt.equals("  ")) {
                    _rt = String.valueOf(_rt).concat(" + ");
                } else if (_c < 0.0) {
                    _rt = String.valueOf(_rt).concat(" - ");
                }
                _c = Math.abs(_c);
                if (_c != 1.0) {
                    _rt = String.valueOf(_rt).concat(String.valueOf(String.valueOf(Double.toString(_c)).concat(" ")));
                }
                _rt = String.valueOf(_rt).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(this.uSpecies[j].getLabel())).append(" (").append(this.uSpecies[j].getPhase().getLabel()).append(")"))));
            }
            mb[i] = String.valueOf(new StringBuffer(String.valueOf(Double.toString(_anal))).append(" mole  =").append(_rt));
        }
        return mb;
    }

    public String[] getMessages() {
        if (this.mes.size() == 0) {
            this.mes.addElement("no messages");
        }
        Object[] _mes = new String[this.mes.size()];
        this.mes.copyInto(_mes);
        return _mes;
    }

    public double getMinValue() {
        return Math.exp(-700.0);
    }

    public int getNbrMassBalance() {
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
        if (!this.parse()) {
            System.out.println("Equilibria.getNbrMassBalance:  Problems found in the Chemical System;  Cannot return mass balance equations.");
            String[] _mes = this.getMessages();
            for (int i = 1; i < _mes.length; ++i) {
                System.out.println(_mes[i]);
            }
            return 0;
        }
        if (!this.createEquations()) {
            System.out.println("Equilibria.getNbrMassBalance:  Error creating equations");
            return 0;
        }
        return this.nMB;
    }

    public double getTolerance() {
        return 1.0E-5;
    }

    public void printMessages() {
        String[] _mes = this.getMessages();
        for (int i = 0; i < _mes.length; ++i) {
            System.out.println(_mes[i]);
        }
    }

    public void setChemicalSystem(ChemSystem _chemSystem) {
        this.chemSystem = _chemSystem;
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
    }

    public void setDisplayIterations(boolean _displayIterations) {
        this.displayIterations = _displayIterations;
    }

    public void setDisplayLinearSystem(boolean _displayLinearSystem) {
        this.displayLinearSystem = _displayLinearSystem;
    }

    public void setDisplayResults(boolean _displayResults) {
        this.displayResults = _displayResults;
    }

    public void setDisplayTime(boolean _displayTime) {
        this.displayTime = _displayTime;
    }

    public void setEquationTolerance(double _eqnTol) {
        if (_eqnTol > 0.0) {
            this.eqnTol = _eqnTol;
        }
    }

    public void setMaxCnt(int _maxCnt) {
        if (_maxCnt > 0) {
            this.maxCnt = _maxCnt;
        }
    }

    public void setMaxInc(double _maxInc) {
        if (_maxInc > 0.0) {
            this.maxInc = _maxInc;
        }
    }

    public void setRedundantTolerance(double _tol) {
        if (_tol > 0.0) {
            this.redundantTol = _tol;
        }
    }

    public void setSVDThreshold(double _svdThreshold) {
        if (_svdThreshold > 0.0) {
            this.svdThreshold = _svdThreshold;
        }
    }

    public void setTolerance(double _tol) {
        if (_tol > 0.0) {
            this.tol = _tol;
        }
    }

    public void setUsePrevious(boolean _usePrevious) {
        this.usePrevious = _usePrevious;
    }

    public boolean solveProblem() {
        boolean converged;
        long time = 0L;
        if (this.displayTime) {
            time = System.currentTimeMillis();
        }
        this.reactions = this.chemSystem.getReactions();
        this.species = this.chemSystem.getSpecies();
        this.phases = this.chemSystem.getPhases();
        this.halfReactions = this.chemSystem.getHalfReactions();
        if (!this.parse()) {
            System.out.println("Equilibria.solveProblem:  Problems found in the Chemical System;  Problem cannot be Solved.");
            String[] _mes = this.getMessages();
            for (int i = 1; i < _mes.length; ++i) {
                System.out.println(_mes[i]);
            }
            return false;
        }
        if (!this.createEquations()) {
            System.out.println("Equilibria.solveProblem:  Error creating equations");
            return false;
        }
        boolean[] idx = this.checkSpecies();
        if (idx != null) {
            int i;
            for (i = 0; i < this.nSpecies; ++i) {
                if (!idx[i]) continue;
                this.uSpecies[i].setMoles(0.0);
            }
            block2: for (i = 0; i < this.reactions.length; ++i) {
                Species[] _sp = this.reactions[i].getSpecies();
                for (int j = 0; j < _sp.length; ++j) {
                    for (int k = 0; k < this.nSpecies; ++k) {
                        if (!_sp[j].equals(this.uSpecies[k]) || !idx[k]) continue;
                        this.reactions[i].setIsValid(false);
                        continue block2;
                    }
                }
            }
            if (!this.parse1()) {
                System.out.println("Equilibria.solveProblem:  Problems found in the Chemical System;  Problem cannot be Solved.");
                String[] _mes = this.getMessages();
                for (int i2 = 1; i2 < _mes.length; ++i2) {
                    System.out.println(_mes[i2]);
                }
                return false;
            }
            this.setReactions();
            if (!this.createEquations()) {
                System.out.println("Equilibria.solveProblem:  Error creating equations");
                return false;
            }
        }
        if (!(converged = this.solve())) {
            System.out.println("Equilibria.solveProblem:  Solution may not be valid.");
            return false;
        }
        if (this.displayTime) {
            time = System.currentTimeMillis() - time;
            double tm = (double)time / 1000.0;
            System.out.println(String.valueOf(new StringBuffer("Equilibria.solveProblem execution time = ").append(tm).append(" sec")));
        }
        return true;
    }

    protected boolean createEquations() {
        int j;
        int i;
        for (i = 0; i < this.species.length; ++i) {
            this.species[i].setIndex(-1);
        }
        for (i = 0; i < this.reactions.length; ++i) {
            this.reactions[i].setIndex(-1);
        }
        this.nAuto = 0;
        Vector<Species> _vec = new Vector<Species>();
        Vector<Phase> _vecP = new Vector<Phase>();
        for (i = 0; i < this.phases.length; ++i) {
            if (!this.phases[i].getIsProtic()) continue;
            _vec.addElement(this.phases[i].getAcid());
            _vec.addElement(this.phases[i].getBase());
            _vecP.addElement(this.phases[i]);
            ++this.nAuto;
        }
        this.nAcidBase = 2 * this.nAuto;
        this.CB = new Phase[this.nAuto];
        _vecP.copyInto(this.CB);
        this.nSpecies = 0;
        for (i = 0; i < this.species.length; ++i) {
            if (this.species[i].getIsSolvent()) {
                this.species[i].setIsReactive(false);
                continue;
            }
            if (!this.species[i].getIsReactive() || this.species[i].getIsAcid() || this.species[i].getIsBase()) continue;
            _vec.insertElementAt(this.species[i], 0);
            ++this.nSpecies;
        }
        this.uSpecies = new Species[this.nSpecies + this.nAcidBase];
        _vec.copyInto(this.uSpecies);
        for (i = 0; i < this.nSpecies + this.nAcidBase; ++i) {
            this.uSpecies[i].setIndex(i);
        }
        double[][] _A = new double[this.nSpecies][this.nSpecies];
        for (i = 0; i < this.nSpecies; ++i) {
            for (j = 0; j < this.nSpecies; ++j) {
                _A[i][j] = 0.0;
            }
            _A[i][i] = 1.0;
        }
        this.nRxn = this.reactions.length;
        int _nRxn = this.nRxn - this.nAuto;
        double[][] _V = new double[this.nSpecies][_nRxn];
        int _iRxn = 0;
        for (i = 0; i < this.nRxn; ++i) {
            if (this.reactions[i].getIsAuto()) continue;
            for (j = 0; j < this.nSpecies; ++j) {
                _V[j][_iRxn] = this.reactions[i].getCoefficient(this.uSpecies[j]);
            }
            ++_iRxn;
        }
        int[] _p = new int[this.nSpecies];
        for (i = 0; i < this.nSpecies; ++i) {
            _p[i] = i;
        }
        for (i = 0; i < _nRxn; ++i) {
            for (int ii = i + 1; _V[_p[i]][i] == 0.0 && ii < this.nSpecies; ++ii) {
                int _ii = _p[i];
                _p[i] = _p[ii];
                _p[ii] = _ii;
            }
            if (_V[_p[i]][i] == 0.0) {
                System.out.println("Equilibria.createEquations:  Cannot find pivot for variable ".concat(String.valueOf(i)));
                return false;
            }
            for (int j2 = 0; j2 < this.nSpecies; ++j2) {
                int jj;
                if (j2 == _p[i]) continue;
                double _tmp = _V[j2][i] / _V[_p[i]][i];
                for (jj = 0; jj < this.nSpecies; ++jj) {
                    double[] dArray = _A[j2];
                    int n = jj;
                    dArray[n] = dArray[n] - _tmp * _A[_p[i]][jj];
                }
                for (jj = 0; jj < _nRxn; ++jj) {
                    double[] dArray = _V[j2];
                    int n = jj;
                    dArray[n] = dArray[n] - _tmp * _V[_p[i]][jj];
                }
            }
        }
        this.nMB = this.nSpecies - _nRxn;
        this.A = new double[this.nMB][this.nSpecies];
        for (i = 0; i < this.nMB; ++i) {
            for (j = 0; j < this.nSpecies; ++j) {
                this.A[i][j] = _A[_p[i + _nRxn]][j];
            }
        }
        this.n = this.nSpecies + this.nAcidBase;
        this.func = new double[this.n];
        this.deriv = new double[this.n][this.n];
        this.maxTerm = new double[this.n];
        if (this.n != this.nMB + this.nAuto + this.nRxn) {
            System.out.println("Equilibria.createEquations:  Inconsistent numbers of variables and equations");
            System.out.println(String.valueOf(new StringBuffer("nSpecies = ").append(this.nSpecies).append("  nAcidBase = ").append(this.nAcidBase)));
            System.out.println(String.valueOf(new StringBuffer("nMB = ").append(this.nMB).append("  nAuto = ").append(this.nAuto).append("  nRxn = ").append(this.nRxn)));
            System.out.println("n = ".concat(String.valueOf(this.n)));
            return false;
        }
        return true;
    }

    protected boolean solve() {
        boolean converged;
        block38: {
            int i;
            converged = false;
            boolean cnOkay = false;
            int nCN = 0;
            int _w = -1;
            int cnt = 0;
            double[][] _M = new double[this.n][this.n];
            double[][] _V = new double[this.n][this.n];
            double[] _W = new double[this.n];
            double[] _b = new double[this.n];
            double[] _bb = new double[this.n];
            if (this.nSpecies + this.nAcidBase == 0) {
                return true;
            }
            for (i = 0; i < this.species.length; ++i) {
                if (this.getIndex(this.uSpecies, this.species[i]) >= 0) {
                    if (!this.usePrevious) {
                        this.species[i].setMoles(this.species[i].getAnalMoles());
                    }
                    if (this.species[i].getMoles() != 0.0) continue;
                    this.species[i].setMoles(1.0E-9);
                    continue;
                }
                this.species[i].setMoles(this.species[i].getAnalMoles());
            }
            while (!converged && cnt < 50) {
                double _val;
                int j;
                ++cnt;
                this.calc();
                for (i = 0; i < this.n; ++i) {
                    for (j = 0; j < this.n; ++j) {
                        _M[i][j] = this.deriv[i][j];
                    }
                    _b[i] = -this.func[i];
                }
                if (this.displayLinearSystem) {
                    for (i = 0; i < this.n; ++i) {
                        for (j = 0; j < this.n; ++j) {
                            System.out.print(String.valueOf(_M[i][j]).concat(" "));
                        }
                        System.out.println("= ".concat(String.valueOf(_b[i])));
                    }
                }
                this.svd(_M, _W, _V);
                cnOkay = false;
                nCN = 0;
                while (!cnOkay) {
                    double _cn = -1.0;
                    _val = -1.0;
                    for (_w = 0; _w < this.n; ++_w) {
                        if (_W[_w] == 0.0) continue;
                        _cn = Math.abs(_W[_w]);
                        _val = Math.abs(_W[_w]);
                        break;
                    }
                    if (_cn < 0.0) {
                        System.out.println("Equilibria.solve:  All diagonal elements are zero");
                        return false;
                    }
                    for (i = 1; i < this.n; ++i) {
                        if (_W[i] == 0.0) continue;
                        if (Math.abs(_W[i]) > _cn) {
                            _cn = Math.abs(_W[i]);
                        }
                        if (!(Math.abs(_W[i]) < _val)) continue;
                        _val = Math.abs(_W[i]);
                        _w = i;
                    }
                    _cn /= _val;
                    if (this.displayLinearSystem) {
                        System.out.println(String.valueOf(new StringBuffer("Iteration ").append(cnt).append("  condition number = ").append(_cn).append("  [").append(_w).append("  ").append(_val).append("]")));
                    }
                    if (_cn * this.svdThreshold > 1.0) {
                        _W[_w] = 0.0;
                        ++nCN;
                        continue;
                    }
                    cnOkay = true;
                }
                for (i = 0; i < this.n; ++i) {
                    _val = 0.0;
                    if (_W[i] > 0.0) {
                        for (j = 0; j < this.n; ++j) {
                            _val += _M[j][i] * _b[j];
                        }
                        _val /= _W[i];
                    }
                    _bb[i] = _val;
                }
                for (i = 0; i < this.n; ++i) {
                    _val = 0.0;
                    for (j = 0; j < this.n; ++j) {
                        _val += _V[i][j] * _bb[j];
                    }
                    _b[i] = _val;
                }
                converged = true;
                for (i = 0; i < this.n; ++i) {
                    if (!(Math.abs(_b[i]) > this.tol)) continue;
                    converged = false;
                }
                for (i = 0; i < this.n; ++i) {
                    double _sum = 0.0;
                    if (!(this.maxTerm[i] * this.eqnTol < Math.abs(this.func[i]))) continue;
                    converged = false;
                }
                for (i = 0; i < this.n; ++i) {
                    _val = this.uSpecies[i].getMoles();
                    _val = _val <= 0.0 ? -700.0 : Math.log(_val);
                    _val = Math.abs(_b[i]) <= this.maxInc ? (_val += _b[i]) : (_b[i] < 0.0 ? (_val -= this.maxInc) : (_val += this.maxInc));
                    if (_val < -700.0) {
                        _val = -700.0;
                    } else if (_val > 700.0) {
                        _val = 700.0;
                    }
                    this.uSpecies[i].setMoles(Math.exp(_val));
                }
                if (!this.displayIterations) continue;
                System.out.println("Equilibria.solve:  Values after iteration ".concat(String.valueOf(cnt)));
                for (i = 0; i < this.uSpecies.length; ++i) {
                    System.out.print(String.valueOf(new StringBuffer("   ").append(this.uSpecies[i].getLabel()).append(" (").append(this.uSpecies[i].getPhase().getLabel()).append(")   increment = ").append(_b[i])));
                    if (this.uSpecies[i].getPhysicalState() == 'g') {
                        System.out.print(String.valueOf(new StringBuffer("   pressure = ").append(this.uSpecies[i].getPressure()).append(" atm")));
                    } else if (this.uSpecies[i].getPhysicalState() == 'd') {
                        System.out.print(String.valueOf(new StringBuffer("   concentration = ").append(this.uSpecies[i].getConc()).append(" mole/L")));
                    } else {
                        System.out.print(String.valueOf(new StringBuffer("   amount = ").append(this.uSpecies[i].getMoles()).append(" moles")));
                    }
                    System.out.println(String.valueOf(new StringBuffer("  f[").append(i).append("] = ").append(this.func[i]).append("  (").append(this.maxTerm[i]).append(")")));
                }
            }
            if (!converged) {
                System.out.println("Equilibria.solve:  Maximum number of iterations exceeded without reaching a solution");
            }
            if (this.displayResults) {
                System.out.println(String.valueOf(new StringBuffer("Equilibria.solve:  Solution obtained after ").append(cnt).append(" iterations")));
                for (i = 0; i < this.species.length; ++i) {
                    System.out.print(String.valueOf(new StringBuffer("   ").append(this.species[i].getLabel()).append(" (").append(this.species[i].getPhase().getLabel()).append(")")));
                    if (this.species[i].getPhysicalState() == 'g') {
                        System.out.println(String.valueOf(new StringBuffer("   ").append(this.species[i].getPressure()).append(" atm")));
                        continue;
                    }
                    if (this.species[i].getPhysicalState() == 'd') {
                        System.out.println(String.valueOf(new StringBuffer("   ").append(this.species[i].getConc()).append(" mole/L")));
                        continue;
                    }
                    System.out.println(String.valueOf(new StringBuffer("   ").append(this.species[i].getMoles()).append(" mole")));
                }
            }
            if (nCN <= 0) break block38;
            System.out.println("Equilibria.solve:  Solution converged with zeroed pivots");
            converged = false;
        }
        return converged;
    }

    private void printArray(double[][] a) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                System.out.print(" ".concat(String.valueOf(a[i][j])));
            }
            System.out.println(" ");
        }
    }

    private void printArray(double[][] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                System.out.print(" ".concat(String.valueOf(a[i][j])));
            }
            System.out.println(" * ".concat(String.valueOf(b[i])));
        }
    }

    private void printArray(double[][] a, int[] pr, int[] pc) {
        for (int i = 0; i < pr.length; ++i) {
            for (int j = 0; j < pc.length; ++j) {
                if (a[pr[i]][pc[j]] >= 0.0) {
                    System.out.print("  ".concat(String.valueOf(a[pr[i]][pc[j]])));
                    continue;
                }
                System.out.print(" ".concat(String.valueOf(a[pr[i]][pc[j]])));
            }
            System.out.println(" ");
        }
    }

    private void printSpecies(Species[] s) {
        for (int i = 0; i < s.length; ++i) {
            System.out.println(" ".concat(String.valueOf(s[i].getLabel())));
        }
    }

    private void calc() {
        int j;
        double _sum;
        int i;
        for (i = 0; i < this.nMB; ++i) {
            this.func[i] = 0.0;
            _sum = 0.0;
            for (int j2 = 0; j2 < this.nSpecies; ++j2) {
                int n = i;
                this.func[n] = this.func[n] + this.A[i][j2] * (this.uSpecies[j2].getAnalMoles() - this.uSpecies[j2].getMoles());
                this.deriv[i][j2] = -this.A[i][j2] * this.uSpecies[j2].getMoles();
                _sum += Math.abs(this.A[i][j2]) * (this.uSpecies[j2].getAnalMoles() + this.uSpecies[j2].getMoles());
            }
            this.maxTerm[i] = _sum;
        }
        for (i = 0; i < this.nAuto; ++i) {
            this.func[i + this.nMB] = 0.0;
            _sum = 0.0;
            for (int j3 = 0; j3 < this.n; ++j3) {
                this.deriv[i + this.nMB][j3] = 0.0;
            }
            Species[] _sp = this.CB[i].getSpecies();
            for (j = 0; j < _sp.length; ++j) {
                double _charge = _sp[j].getCharge();
                if (_charge == 0.0) continue;
                int n = i + this.nMB;
                this.func[n] = this.func[n] + _charge * _sp[j].getMoles();
                _sum += Math.abs(_charge * _sp[j].getMoles());
                if (_sp[j].getIndex() < 0) continue;
                this.deriv[i + this.nMB][_sp[j].getIndex()] = _charge * _sp[j].getMoles();
            }
            this.maxTerm[i + this.nMB] = _sum;
        }
        for (i = 0; i < this.nRxn; ++i) {
            this.func[i + this.nMB + this.nAuto] = -Math.log(this.reactions[i].getK(this.chemSystem.getTemperature()));
            _sum = Math.abs(Math.log(this.reactions[i].getK(this.chemSystem.getTemperature())));
            for (int j4 = 0; j4 < this.n; ++j4) {
                this.deriv[i + this.nMB + this.nAuto][j4] = 0.0;
            }
            Species[] _sp = this.reactions[i].getSpecies();
            for (j = 0; j < _sp.length; ++j) {
                if (_sp[j].getPhysicalState() == 'g') {
                    int n = i + this.nMB + this.nAuto;
                    this.func[n] = this.func[n] + this.reactions[i].getCoefficient(_sp[j]) * Math.log(_sp[j].getActivity());
                    _sum += Math.abs(this.reactions[i].getCoefficient(_sp[j]) * Math.log(_sp[j].getActivity()));
                    this.deriv[i + this.nMB + this.nAuto][_sp[j].getIndex()] = this.reactions[i].getCoefficient(_sp[j]);
                    continue;
                }
                if (_sp[j].getPhysicalState() != 'd') continue;
                int n = i + this.nMB + this.nAuto;
                this.func[n] = this.func[n] + this.reactions[i].getCoefficient(_sp[j]) * Math.log(_sp[j].getActivity());
                _sum += Math.abs(this.reactions[i].getCoefficient(_sp[j]) * Math.log(_sp[j].getActivity()));
                this.deriv[i + this.nMB + this.nAuto][_sp[j].getIndex()] = this.reactions[i].getCoefficient(_sp[j]);
            }
            this.maxTerm[i + this.nMB + this.nAuto] = _sum;
        }
    }

    private int getIndex(Object[] _array, Object _target) {
        for (int i = 0; i < _array.length; ++i) {
            if (!_array[i].equals(_target)) continue;
            return i;
        }
        return -1;
    }

    private void setReactions() {
        int i;
        int _i = 0;
        for (i = 0; i < this.chemSystem.getNbrReactions(); ++i) {
            if (!this.chemSystem.getReaction(i).getIsValid()) continue;
            ++_i;
        }
        this.reactions = new Reaction[_i];
        _i = 0;
        for (i = 0; i < this.chemSystem.getNbrReactions(); ++i) {
            if (!this.chemSystem.getReaction(i).getIsValid()) continue;
            this.reactions[_i++] = this.chemSystem.getReaction(i);
        }
    }

    private boolean[] checkSpecies() {
        int k;
        int j;
        int j2;
        int _n = this.nSpecies - this.nMB;
        int _ptr = 0;
        boolean[] _cs = new boolean[this.nSpecies];
        boolean _csFlag = false;
        int[] _f = new int[this.nSpecies];
        int[] _b = new int[this.nMB];
        for (j2 = 0; j2 < this.nSpecies; ++j2) {
            _f[j2] = j2;
        }
        for (j2 = 0; j2 < this.nMB; ++j2) {
            _b[j2] = -j2 - 1;
        }
        double[][] _T = new double[this.nMB + 1][this.nSpecies + 1];
        for (int k2 = 0; k2 < this.nMB; ++k2) {
            _T[k2][this.nSpecies] = 0.0;
            for (j = 0; j < this.nSpecies; ++j) {
                _T[k2][j] = -this.A[k2][j];
                double[] dArray = _T[k2];
                int n = this.nSpecies;
                dArray[n] = dArray[n] + this.A[k2][j] * this.uSpecies[j].getAnalMoles();
            }
            if (!(_T[k2][this.nSpecies] < 0.0)) continue;
            for (j = 0; j <= this.nSpecies; ++j) {
                _T[k2][j] = -_T[k2][j];
            }
        }
        for (j2 = 0; j2 <= this.nSpecies; ++j2) {
            _T[this.nMB][j2] = -_T[0][j2];
        }
        for (j2 = 1; j2 < this.nMB; ++j2) {
            for (k = 0; k <= this.nSpecies; ++k) {
                double[] dArray = _T[this.nMB];
                int n = k;
                dArray[n] = dArray[n] - _T[j2][k];
            }
        }
        this.simplex(_T, _f, _b, true);
        for (int ii = 0; ii < this.nMB; ++ii) {
            int j3;
            if (_b[ii] >= 0) continue;
            int _pt = -1;
            for (int j4 = 0; j4 < this.nSpecies; ++j4) {
                if (_f[j4] < 0 || _T[ii][j4] == 0.0 || _T[ii][this.nSpecies] != 0.0) continue;
                _pt = j4;
                break;
            }
            if (_pt < 0) {
                System.out.println("Equilibria.checkSpecies:  Cannot eliminate artificial variables");
                return null;
            }
            double _tmp = _T[ii][_pt];
            for (j3 = 0; j3 < this.nMB; ++j3) {
                if (j3 == ii || _T[j3][_pt] == 0.0) continue;
                double _tmpz = _T[j3][_pt] / _tmp;
                for (int k3 = 0; k3 <= this.nSpecies; ++k3) {
                    double[] dArray = _T[j3];
                    int n = k3;
                    dArray[n] = dArray[n] - _tmpz * _T[ii][k3];
                }
                _T[j3][_pt] = _tmpz;
            }
            j3 = 0;
            while (j3 <= this.nSpecies) {
                double[] dArray = _T[ii];
                int n = j3++;
                dArray[n] = dArray[n] / -_tmp;
            }
            _T[ii][_pt] = 1.0 / _tmp;
            int jj = _f[_pt];
            _f[_pt] = _b[ii];
            _b[ii] = jj;
        }
        double[][] _TT = new double[this.nMB + 1][_n + 1];
        int[] _ff = new int[_n];
        int[] _bb = new int[this.nMB];
        _ptr = 0;
        for (j2 = 0; j2 < this.nSpecies; ++j2) {
            if (_f[j2] < 0) continue;
            for (k = 0; k < this.nMB; ++k) {
                _TT[k][_ptr] = _T[k][j2];
            }
            _ff[_ptr++] = _f[j2];
        }
        for (j2 = 0; j2 < this.nMB; ++j2) {
            _TT[j2][_n] = _T[j2][this.nSpecies];
        }
        for (j2 = 0; j2 < this.nMB; ++j2) {
            _bb[j2] = _b[j2];
        }
        _T = new double[this.nMB + 1][_n + 1];
        _f = new int[_n];
        _b = new int[this.nMB];
        for (int i = 0; i < this.nSpecies; ++i) {
            if (this.uSpecies[i].getAnalMoles() > 0.0) continue;
            for (j = 0; j <= _n; ++j) {
                for (int k4 = 0; k4 < this.nMB; ++k4) {
                    _T[k4][j] = _TT[k4][j];
                }
            }
            for (j = 0; j < _n; ++j) {
                _f[j] = _ff[j];
            }
            _ptr = -1;
            for (j = 0; j < this.nMB; ++j) {
                _b[j] = _bb[j];
                if (_b[j] != i) continue;
                _ptr = j;
            }
            if (_ptr < 0) {
                for (j = 0; j < _n; ++j) {
                    _T[this.nMB][j] = _f[j] == i ? 1.0 : 0.0;
                }
                _T[this.nMB][_n] = 0.0;
            } else {
                for (j = 0; j <= _n; ++j) {
                    _T[this.nMB][j] = _T[_ptr][j];
                }
            }
            this.simplex(_T, _f, _b, false);
            if (_T[this.nMB][_n] == 0.0) {
                _csFlag = true;
                _cs[i] = true;
                continue;
            }
            if (_T[this.nMB][_n] < 0.0) {
                System.out.println("Equilibria.checkSpecies:  Negative amount");
                return null;
            }
            _cs[i] = false;
        }
        return _cs;
    }

    private void simplex(double[][] _T, int[] _f, int[] _b, boolean _flag) {
        int cnt = 0;
        int maxCnt = this.nSpecies + this.nMB;
        int _n = _f.length;
        boolean _pts = false;
        int[][] _ex = new int[this.nSpecies][this.nSpecies];
        int _maxEx = 2;
        for (int i = 0; i < this.nSpecies; ++i) {
            for (int j = 0; j < this.nSpecies; ++j) {
                _ex[i][j] = 0;
            }
        }
        while (cnt < maxCnt) {
            int i;
            int j;
            if (_flag) {
                int _ptr = 0;
                int _ptc = 0;
                while (_ptr >= 0 && _ptc >= 0) {
                    int i2;
                    int i3;
                    _ptr = -1;
                    _ptc = -1;
                    for (i3 = 0; i3 < this.nMB; ++i3) {
                        if (_b[i3] < 0) {
                            _ptc = i3;
                        }
                        if (_T[i3][_n] != 0.0 || _b[i3] >= 0) continue;
                        _ptr = i3;
                    }
                    if (_ptc < 0) {
                        return;
                    }
                    if (_ptr < 0) continue;
                    _ptc = 0;
                    for (i3 = 0; i3 < _n; ++i3) {
                        if (_T[_ptr][i3] == 0.0 || _f[i3] < 0) continue;
                        _ptc = i3;
                        break;
                    }
                    if (_ptc < 0) continue;
                    double _tmp = _T[_ptr][_ptc];
                    for (i2 = 0; i2 <= this.nMB; ++i2) {
                        if (i2 == _ptr || _T[i2][_ptc] == 0.0) continue;
                        double _tmpz = _T[i2][_ptc] / _tmp;
                        for (int j2 = 0; j2 < _n; ++j2) {
                            double[] dArray = _T[i2];
                            int n = j2;
                            dArray[n] = dArray[n] - _tmpz * _T[_ptr][j2];
                        }
                        _T[i2][_ptc] = _tmpz;
                    }
                    int j3 = 0;
                    while (j3 < _n) {
                        double[] dArray = _T[_ptr];
                        int n = j3++;
                        dArray[n] = dArray[n] / -_tmp;
                    }
                    _T[_ptr][_ptc] = 1.0 / _tmp;
                    i2 = _f[_ptc];
                    _f[_ptc] = _b[_ptr];
                    _b[_ptr] = i2;
                    int[] nArray = _ex[Math.abs(_b[_ptr])];
                    int n = Math.abs(_f[_ptc]);
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = _ex[Math.abs(_f[_ptc])];
                    int n2 = Math.abs(_b[_ptr]);
                    nArray2[n2] = nArray2[n2] + 1;
                }
            }
            int _pc = -1;
            int _prTmp = -1;
            int _pr = -1;
            double _max = 0.0;
            for (int i4 = 0; i4 < _n; ++i4) {
                if (_T[this.nMB][i4] <= 0.0) continue;
                double _tmpMin = -1.0;
                for (j = 0; j < this.nMB; ++j) {
                    if (_T[j][i4] >= 0.0) continue;
                    double _tmp = -_T[j][_n] * _T[this.nMB][i4] / _T[j][i4];
                    if (_tmpMin < 0.0) {
                        _tmpMin = _tmp;
                        _prTmp = j;
                        continue;
                    }
                    if (!(_tmp < _tmpMin)) continue;
                    _tmpMin = _tmp;
                    _prTmp = j;
                }
                if (_tmpMin < 0.0) {
                    _T[this.nMB][_n] = 1.0;
                    return;
                }
                if (!(_tmpMin >= _max)) continue;
                _max = _tmpMin;
                _pc = i4;
                _pr = _prTmp;
            }
            if (_pc == -1) {
                int i5;
                int _ptr = -1;
                for (int i6 = 0; i6 < this.nMB; ++i6) {
                    if (_T[i6][_n] != 0.0) continue;
                    _ptr = i6;
                    break;
                }
                if (_ptr < 0) {
                    return;
                }
                int _ptc = -1;
                for (int i7 = 0; i7 < _n; ++i7) {
                    if (_ex[Math.abs(_b[_ptr])][Math.abs(_f[i7])] > _maxEx || _T[_ptr][i7] == 0.0) continue;
                    _ptc = i7;
                    break;
                }
                if (_ptc < 0) {
                    return;
                }
                double _tmp = _T[_ptr][_ptc];
                for (i5 = 0; i5 <= this.nMB; ++i5) {
                    if (i5 == _ptr || _T[i5][_ptc] == 0.0) continue;
                    double _tmpz = _T[i5][_ptc] / _tmp;
                    for (int j4 = 0; j4 < _n; ++j4) {
                        double[] dArray = _T[i5];
                        int n = j4;
                        dArray[n] = dArray[n] - _tmpz * _T[_ptr][j4];
                    }
                    _T[i5][_ptc] = _tmpz;
                }
                int j5 = 0;
                while (j5 < _n) {
                    double[] dArray = _T[_ptr];
                    int n = j5++;
                    dArray[n] = dArray[n] / -_tmp;
                }
                _T[_ptr][_ptc] = 1.0 / _tmp;
                i5 = _f[_ptc];
                _f[_ptc] = _b[_ptr];
                _b[_ptr] = i5;
                int[] nArray = _ex[Math.abs(_b[_ptr])];
                int n = Math.abs(_f[_ptc]);
                nArray[n] = nArray[n] + 1;
                int[] nArray3 = _ex[Math.abs(_f[_ptc])];
                int n3 = Math.abs(_b[_ptr]);
                nArray3[n3] = nArray3[n3] + 1;
                continue;
            }
            double _pivot = _T[_pr][_pc];
            double[] _pivCol = new double[this.nMB + 1];
            for (i = 0; i <= this.nMB; ++i) {
                _pivCol[i] = _T[i][_pc];
            }
            i = 0;
            while (i <= _n) {
                double[] dArray = _T[_pr];
                int n = i++;
                dArray[n] = dArray[n] / -_pivot;
            }
            for (i = 0; i <= this.nMB; ++i) {
                if (i == _pr || _T[i][_pc] == 0.0) continue;
                _max = _T[i][_pc];
                for (int j6 = 0; j6 <= _n; ++j6) {
                    double[] dArray = _T[i];
                    int n = j6;
                    dArray[n] = dArray[n] + _max * _T[_pr][j6];
                }
            }
            for (i = 0; i <= this.nMB; ++i) {
                _T[i][_pc] = i == _pr ? 1.0 / _pivot : _pivCol[i] / _pivot;
            }
            j = _f[_pc];
            _f[_pc] = _b[_pr];
            _b[_pr] = j;
            ++cnt;
        }
    }

    private void svd(double[][] _A, double[] _W, double[][] _V) {
        int k;
        int j;
        int i;
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double g = 0.0;
        double scale = 0.0;
        int _n = _A.length;
        double[] rv1 = new double[_n];
        for (i = 0; i < _n; ++i) {
            rv1[i] = 0.0;
        }
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        double s = 0.0;
        double h = 0.0;
        double f = 0.0;
        double c = 0.0;
        for (i = 0; i < _n; ++i) {
            int k2;
            l = i + 1;
            rv1[i] = scale * g;
            g = 0.0;
            s = 0.0;
            scale = 0.0;
            if (i < _n) {
                for (k2 = i; k2 < _n; ++k2) {
                    scale += Math.abs(_A[k2][i]);
                }
                if (scale != 0.0) {
                    for (k2 = i; k2 < _n; ++k2) {
                        double[] dArray = _A[k2];
                        int n = i;
                        dArray[n] = dArray[n] / scale;
                        s += _A[k2][i] * _A[k2][i];
                    }
                    f = _A[i][i];
                    g = f >= 0.0 ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    _A[i][i] = f - g;
                    if (i != _n - 1) {
                        for (j = l; j < _n; ++j) {
                            s = 0.0;
                            for (k = i; k < _n; ++k) {
                                s += _A[k][i] * _A[k][j];
                            }
                            f = s / h;
                            for (k = i; k < _n; ++k) {
                                double[] dArray = _A[k];
                                int n = j;
                                dArray[n] = dArray[n] + f * _A[k][i];
                            }
                        }
                    }
                    for (k2 = i; k2 < _n; ++k2) {
                        double[] dArray = _A[k2];
                        int n = i;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            _W[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < _n - 1) {
                for (k2 = l; k2 < _n; ++k2) {
                    scale += Math.abs(_A[i][k2]);
                }
                if (scale != 0.0) {
                    for (k2 = l; k2 < _n; ++k2) {
                        double[] dArray = _A[i];
                        int n = k2;
                        dArray[n] = dArray[n] / scale;
                        s += _A[i][k2] * _A[i][k2];
                    }
                    f = _A[i][l];
                    g = f >= 0.0 ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    _A[i][l] = f - g;
                    for (k2 = l; k2 < _n; ++k2) {
                        rv1[k2] = _A[i][k2] / h;
                    }
                    if (i < _n - 1) {
                        for (j = l; j < _n; ++j) {
                            s = 0.0;
                            for (k = l; k < _n; ++k) {
                                s += _A[j][k] * _A[i][k];
                            }
                            for (k = l; k < _n; ++k) {
                                double[] dArray = _A[j];
                                int n = k;
                                dArray[n] = dArray[n] + s * rv1[k];
                            }
                        }
                    }
                    k2 = l;
                    while (k2 < _n) {
                        double[] dArray = _A[i];
                        int n = k2++;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(_W[i]) + Math.abs(rv1[i]));
        }
        i = _n - 1;
        while (i >= 0) {
            if (i < _n - 1) {
                if (g != 0.0) {
                    for (j = l; j < _n; ++j) {
                        _V[j][i] = _A[i][j] / _A[i][l] / g;
                    }
                    for (j = l; j < _n; ++j) {
                        s = 0.0;
                        for (k = l; k < _n; ++k) {
                            s += _A[i][k] * _V[k][j];
                        }
                        for (k = l; k < _n; ++k) {
                            double[] dArray = _V[k];
                            int n = j;
                            dArray[n] = dArray[n] + s * _V[k][i];
                        }
                    }
                }
                for (j = l; j < _n; ++j) {
                    _V[j][i] = 0.0;
                    _V[i][j] = 0.0;
                }
            }
            _V[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = _n - 1;
        while (i >= 0) {
            l = i + 1;
            g = _W[i];
            if (i < _n - 1) {
                for (j = l; j < _n; ++j) {
                    _A[i][j] = 0.0;
                }
            }
            if (g != 0.0) {
                g = 1.0 / g;
                if (i < _n - 1) {
                    for (j = l; j < _n; ++j) {
                        s = 0.0;
                        for (k = l; k < _n; ++k) {
                            s += _A[k][i] * _A[k][j];
                        }
                        f = s / _A[i][i] * g;
                        for (k = i; k < _n; ++k) {
                            double[] dArray = _A[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * _A[k][i];
                        }
                    }
                }
                for (j = i; j < _n; ++j) {
                    double[] dArray = _A[j];
                    int n = i;
                    dArray[n] = dArray[n] * g;
                }
            } else {
                for (j = i; j < _n; ++j) {
                    _A[j][i] = 0.0;
                }
            }
            double[] dArray = _A[i];
            int n = i--;
            dArray[n] = dArray[n] + 1.0;
        }
        block28: for (int k3 = _n - 1; k3 >= 0; --k3) {
            for (int its = 1; its <= 30; ++its) {
                boolean flag = true;
                for (l = k3; l >= 0; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(_W[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (int i2 = l; i2 <= k3; ++i2) {
                        f = s * rv1[i2];
                        if (Math.abs(f) + anorm == anorm) continue;
                        g = _W[i2];
                        _W[i2] = h = this.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (int j2 = 0; j2 < _n; ++j2) {
                            y = _A[j2][nm];
                            z = _A[j2][i2];
                            _A[j2][nm] = y * c + z * s;
                            _A[j2][i2] = z * c - y * s;
                        }
                    }
                }
                z = _W[k3];
                if (l == k3) {
                    if (!(z < 0.0)) continue block28;
                    _W[k3] = -z;
                    for (int j3 = 0; j3 < _n; ++j3) {
                        _V[j3][k3] = -_V[j3][k3];
                    }
                    continue block28;
                }
                if (its == 30) {
                    System.out.println("Equilibria.svd:  Failed to converge before maximum number of iterations exceeded");
                    return;
                }
                x = _W[l];
                nm = k3 - 1;
                y = _W[nm];
                g = rv1[nm];
                h = rv1[k3];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                double _tmp = g = this.pythag(f, 1.0);
                if (f < 0.0) {
                    _tmp = -g;
                }
                f = ((x - z) * (x + z) + h * (y / (f + _tmp) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (int j4 = l; j4 <= nm; ++j4) {
                    int jj;
                    int i3 = j4 + 1;
                    g = rv1[i3];
                    y = _W[i3];
                    h = s * g;
                    g = c * g;
                    rv1[j4] = z = this.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < _n; ++jj) {
                        x = _V[jj][j4];
                        z = _V[jj][i3];
                        _V[jj][j4] = x * c + z * s;
                        _V[jj][i3] = z * c - x * s;
                    }
                    _W[j4] = z = this.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < _n; ++jj) {
                        y = _A[jj][j4];
                        z = _A[jj][i3];
                        _A[jj][j4] = y * c + z * s;
                        _A[jj][i3] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k3] = f;
                _W[k3] = x;
            }
        }
    }

    private double pythag(double _a, double _b) {
        double bt;
        double at = Math.abs(_a);
        if (at > (bt = Math.abs(_b))) {
            double ct = bt / at;
            return at * Math.sqrt(1.0 + ct * ct);
        }
        if (bt != 0.0) {
            double ct = at / bt;
            return bt * Math.sqrt(1.0 + ct * ct);
        }
        return 0.0;
    }

    private void printTableau(String _label, double[][] _T, int[] _b, int[] _f) {
        int i;
        int nr = _b.length;
        int nc = _f.length;
        System.out.println("\n".concat(String.valueOf(_label)));
        System.out.print("    ");
        for (i = 0; i < nc; ++i) {
            System.out.print(String.valueOf(_f[i]).concat("  "));
        }
        System.out.println();
        for (i = 0; i <= nr; ++i) {
            if (i < nr) {
                System.out.print(String.valueOf(_b[i]).concat("  "));
            } else {
                System.out.print("    ");
            }
            for (int j = 0; j <= nc; ++j) {
                System.out.print(String.valueOf(_T[i][j]).concat("  "));
            }
            System.out.println();
        }
    }

    private boolean parse0() {
        int k;
        int j;
        boolean hasProduct;
        boolean hasReactant;
        int j2;
        double[] _c;
        Species[] _s;
        double tmp;
        int i;
        int nR = this.reactions == null ? 0 : this.reactions.length;
        int nHR = this.halfReactions == null ? 0 : this.halfReactions.length;
        if (nR == 0 && nHR == 0) {
            return true;
        }
        boolean reply = true;
        for (i = 0; i < nR; ++i) {
            tmp = 0.0;
            _s = this.reactions[i].getSpecies();
            _c = this.reactions[i].getCoefficients();
            for (j2 = 0; j2 < _s.length; ++j2) {
                tmp += _c[j2] * _s[j2].getCharge();
            }
            if (tmp == 0.0) continue;
            this.mes.addElement(new String("Reaction Charges not Balanced:  ".concat(String.valueOf(this.reactions[i].getLabel()))));
            reply = false;
        }
        for (i = 0; i < nHR; ++i) {
            tmp = this.halfReactions[i].getEquivalents();
            _s = this.halfReactions[i].getSpecies();
            _c = this.halfReactions[i].getCoefficients();
            for (j2 = 0; j2 < _s.length; ++j2) {
                tmp += _c[j2] * _s[j2].getCharge();
            }
            if (tmp == 0.0) continue;
            this.mes.addElement(new String("Half-Reaction Charges not Balanced:  ".concat(String.valueOf(this.halfReactions[i].getLabel()))));
            reply = false;
        }
        for (i = 0; i < nR; ++i) {
            _s = this.reactions[i].getSpecies();
            _c = this.reactions[i].getCoefficients();
            hasReactant = false;
            hasProduct = false;
            for (j = 0; j < _s.length; ++j) {
                if (_c[j] < 0.0) {
                    hasReactant = true;
                } else if (_c[j] > 0.0) {
                    hasProduct = true;
                } else {
                    this.mes.addElement(new String(String.valueOf(new StringBuffer("Reaction has a Species with a Stoichiometric Coefficient of Zero:  ").append(this.reactions[i].getLabel()).append("  ").append(_s[j].getLabel()))));
                    reply = false;
                }
                for (k = j + 1; k < _s.length; ++k) {
                    if (!_s[j].equals(_s[k])) continue;
                    this.mes.addElement(new String(String.valueOf(new StringBuffer("Species appears Multiple Times in the same Reaction:  ").append(this.reactions[i].getLabel()).append("  ").append(_s[j].getLabel()))));
                    reply = false;
                }
            }
            if (!hasReactant) {
                this.mes.addElement(new String("Reaction does not have a Reactant  ".concat(String.valueOf(this.reactions[i].getLabel()))));
                reply = false;
            }
            if (hasProduct) continue;
            this.mes.addElement(new String("Reaction does not have a Product  ".concat(String.valueOf(this.reactions[i].getLabel()))));
            reply = false;
        }
        for (i = 0; i < nHR; ++i) {
            _s = this.halfReactions[i].getSpecies();
            _c = this.halfReactions[i].getCoefficients();
            hasReactant = false;
            hasProduct = false;
            for (j = 0; j < _s.length; ++j) {
                if (_c[j] < 0.0) {
                    hasReactant = true;
                } else if (_c[j] > 0.0) {
                    hasProduct = true;
                } else {
                    this.mes.addElement(new String(String.valueOf(new StringBuffer("Half-Reaction has a Species with a Stoichiometric Coefficient of Zero:  ").append(this.halfReactions[i].getLabel()).append("  ").append(_s[j].getLabel()))));
                    reply = false;
                }
                for (k = j + 1; k < _s.length; ++k) {
                    if (!_s[j].equals(_s[k])) continue;
                    this.mes.addElement(new String(String.valueOf(new StringBuffer("Species appears Multiple Times in the same Half-Reaction:  ").append(this.halfReactions[i].getLabel()).append("  ").append(_s[j].getLabel()))));
                    reply = false;
                }
            }
            if (!hasReactant) {
                this.mes.addElement(new String("Half-Reaction does not have a Reactant  ".concat(String.valueOf(this.halfReactions[i].getLabel()))));
                reply = false;
            }
            if (hasProduct) continue;
            this.mes.addElement(new String("Half-Reaction does not have a Product  ".concat(String.valueOf(this.halfReactions[i].getLabel()))));
            reply = false;
        }
        for (i = 0; i < this.phases.length; ++i) {
            tmp = 0.0;
            if (this.phases[i].getPhysicalState() == 'd') {
                Species _cation = this.phases[i].getSpecies("X+");
                Species _anion = this.phases[i].getSpecies("X-");
                _cation.setAnalMoles(0.0);
                _anion.setAnalMoles(0.0);
                Species[] _s2 = this.phases[i].getSpecies();
                for (int j3 = 0; j3 < _s2.length; ++j3) {
                    tmp += _s2[j3].getAnalMoles() * _s2[j3].getCharge();
                }
                if (Math.abs(tmp) > 1.0E-15 && this.phases[i].getAutoChargeBalance()) {
                    if (tmp > 0.0) {
                        _anion.setAnalMoles(tmp);
                    } else {
                        _cation.setAnalMoles(Math.abs(tmp));
                    }
                    tmp = 0.0;
                }
            } else {
                _s = this.phases[i].getSpecies();
                for (int j4 = 0; j4 < _s.length; ++j4) {
                    tmp += _s[j4].getAnalMoles() * _s[j4].getCharge();
                }
            }
            if (!(Math.abs(tmp) > 1.0E-15)) continue;
            this.mes.addElement(new String("Phase is not Electroneutral:  ".concat(String.valueOf(this.phases[i].getLabel()))));
            reply = false;
        }
        return reply;
    }

    private boolean parse1() {
        int j;
        double tmp;
        int m;
        boolean test;
        int j2;
        int j3;
        int i;
        int imax;
        int i2;
        boolean reply = true;
        int nHR = 0;
        int nR = 0;
        if (this.reactions == null) {
            nR = 0;
        } else {
            for (i2 = 0; i2 < this.reactions.length; ++i2) {
                if (!this.reactions[i2].getIsValid()) continue;
                ++nR;
            }
        }
        if (this.halfReactions == null) {
            nHR = 0;
        } else {
            for (i2 = 0; i2 < this.halfReactions.length; ++i2) {
                if (!this.halfReactions[i2].getIsValid()) continue;
                ++nHR;
            }
        }
        if (nR == 0 && nHR == 0) {
            return true;
        }
        double[][] a = new double[nR + nHR][this.species.length];
        double[] K = new double[nR + nHR];
        double[] eq = new double[nR + nHR];
        int[] pr = new int[nR + nHR];
        int[] ps = new int[this.species.length];
        Reaction[] _rxn = new Reaction[nR];
        HalfReaction[] _hrxn = new HalfReaction[nHR];
        if (nR > 0) {
            imax = 0;
            for (i = 0; i < this.reactions.length; ++i) {
                if (!this.reactions[i].getIsValid()) continue;
                _rxn[imax++] = this.reactions[i];
            }
        }
        if (nHR > 0) {
            imax = 0;
            for (i = 0; i < this.halfReactions.length; ++i) {
                if (!this.halfReactions[i].getIsValid()) continue;
                _hrxn[imax++] = this.halfReactions[i];
            }
        }
        imax = nR;
        int jmax = this.species.length;
        for (i = 0; i < nR; ++i) {
            pr[i] = i;
            for (j3 = 0; j3 < this.species.length; ++j3) {
                a[i][j3] = _rxn[i].getCoefficient(this.species[j3]);
            }
            K[i] = _rxn[i].getK();
            eq[i] = 0.0;
        }
        for (i = 0; i < nHR; ++i) {
            pr[i + imax] = i + imax;
            for (j3 = 0; j3 < this.species.length; ++j3) {
                a[i + imax][j3] = _hrxn[i].getCoefficient(this.species[j3]);
            }
            K[i + imax] = Math.exp(_hrxn[i].getEquivalents() * 1.60217733E-19 * _hrxn[i].getStandardPotential() / 4.116431827E-21);
            eq[i + imax] = -_hrxn[i].getEquivalents();
        }
        for (j2 = 0; j2 < this.species.length; ++j2) {
            ps[j2] = j2;
            this.species[j2].setIsReactive(true);
        }
        for (j2 = 0; j2 < jmax; ++j2) {
            test = true;
            for (int i3 = 0; i3 < imax; ++i3) {
                if (a[pr[i3]][ps[j2]] == 0.0) continue;
                test = false;
                break;
            }
            if (!test) continue;
            int k = ps[j2];
            this.species[k].setIsReactive(false);
            ps[j2] = ps[jmax - 1];
            ps[jmax - 1] = k;
            --jmax;
            --j2;
        }
        for (i = 0; i < imax; ++i) {
            if (a[pr[i]][ps[i]] == 0.0) {
                test = true;
                for (int k = i + 1; k < imax; ++k) {
                    if (a[pr[k]][ps[i]] == 0.0) continue;
                    m = pr[k];
                    pr[k] = pr[i];
                    pr[i] = m;
                    test = false;
                    break;
                }
                if (test) {
                    test = true;
                    for (int j4 = i + 1; j4 < jmax; ++j4) {
                        if (a[pr[i]][ps[j4]] == 0.0) continue;
                        m = ps[j4];
                        ps[j4] = ps[i];
                        ps[i] = m;
                        test = false;
                        break;
                    }
                    if (test) break;
                }
            }
            tmp = a[pr[i]][ps[i]];
            for (j3 = i; j3 < jmax; ++j3) {
                double[] dArray = a[pr[i]];
                int n = ps[j3];
                dArray[n] = dArray[n] / tmp;
            }
            K[pr[i]] = Math.pow(K[pr[i]], 1.0 / tmp);
            for (int k = i + 1; k < imax; ++k) {
                double temp = a[pr[k]][ps[i]];
                for (j = i; j < jmax; ++j) {
                    double[] dArray = a[pr[k]];
                    int n = ps[j];
                    dArray[n] = dArray[n] - temp * a[pr[i]][ps[j]];
                }
                int n = pr[k];
                K[n] = K[n] / Math.pow(K[pr[i]], temp);
            }
        }
        for (i = 0; i < imax; ++i) {
            test = true;
            for (int j5 = 0; j5 < jmax; ++j5) {
                if (a[pr[i]][ps[j5]] == 0.0) continue;
                test = false;
                break;
            }
            if (!test) continue;
            if (Math.abs(K[pr[i]] - 1.0) < this.redundantTol) {
                this.mes.addElement(new String(String.valueOf(new StringBuffer("Redundant Reaction:  ").append(_rxn[pr[i]].getLabel()).append("  K = ").append(K[pr[i]]))));
                _rxn[pr[i]].setIsValid(false);
                continue;
            }
            this.mes.addElement(new String(String.valueOf(new StringBuffer("Redundant Reaction with an Inconsistent Equilibrium Constant:  ").append(_rxn[pr[i]].getLabel()).append("  K = ").append(K[pr[i]]))));
            reply = false;
        }
        if (nHR > 0) {
            int rmax;
            for (rmax = 0; rmax < nR && a[pr[rmax]][ps[rmax]] != 0.0; ++rmax) {
                for (i = nR; i < nR + nHR; ++i) {
                    double temp = a[pr[i]][ps[rmax]] / a[pr[rmax]][ps[rmax]];
                    for (int j6 = 0; j6 < jmax; ++j6) {
                        double[] dArray = a[pr[i]];
                        int n = ps[j6];
                        dArray[n] = dArray[n] - temp * a[pr[rmax]][ps[j6]];
                    }
                    int n = pr[i];
                    K[n] = K[n] / Math.pow(K[pr[rmax]], temp);
                }
            }
            imax = nHR;
            jmax = this.species.length;
            for (i = 0; i < imax; ++i) {
                if (a[pr[i + nR]][ps[i + rmax]] == 0.0) {
                    boolean test2 = true;
                    for (int k = i + 1; k < imax; ++k) {
                        if (a[pr[k + nR]][ps[i + rmax]] == 0.0) continue;
                        m = pr[k + nR];
                        pr[k + nR] = pr[i + nR];
                        pr[i + nR] = m;
                        test2 = false;
                        break;
                    }
                    if (test2) {
                        test2 = true;
                        for (int j7 = i + rmax + 1; j7 < jmax; ++j7) {
                            if (a[pr[i + nR]][ps[j7]] == 0.0) continue;
                            m = ps[j7];
                            ps[j7] = ps[i + rmax];
                            ps[i + rmax] = m;
                            test2 = false;
                            break;
                        }
                        if (test2) break;
                    }
                }
                tmp = a[pr[i + nR]][ps[i + rmax]];
                for (int j8 = i + rmax; j8 < jmax; ++j8) {
                    double[] dArray = a[pr[i + nR]];
                    int n = ps[j8];
                    dArray[n] = dArray[n] / tmp;
                }
                K[pr[i + nR]] = Math.pow(K[pr[i + nR]], 1.0 / tmp);
                for (int k = i + 1; k < imax; ++k) {
                    double temp = a[pr[k + nR]][ps[i + rmax]];
                    for (j = i + rmax; j < jmax; ++j) {
                        double[] dArray = a[pr[k + nR]];
                        int n = ps[j];
                        dArray[n] = dArray[n] - temp * a[pr[i + nR]][ps[j]];
                    }
                    int n = pr[k + nR];
                    eq[n] = eq[n] - temp * eq[pr[i + nR]];
                    int n2 = pr[k + nR];
                    K[n2] = K[n2] / Math.pow(K[pr[i + nR]], temp);
                }
            }
            for (i = 0; i < imax; ++i) {
                boolean test3 = true;
                for (int j9 = 0; j9 < jmax; ++j9) {
                    if (a[pr[i + nR]][ps[j9]] == 0.0) continue;
                    test3 = false;
                    break;
                }
                if (!test3) continue;
                if (Math.abs(K[pr[i + nR]] - 1.0) < this.redundantTol) {
                    this.mes.addElement(new String(String.valueOf(new StringBuffer("Redundant Half-Reaction:  ").append(_hrxn[pr[i + nR] - nR].getLabel()).append("  K = ").append(K[pr[i + nR]]))));
                    _hrxn[pr[i + nR] - nR].setIsValid(false);
                    continue;
                }
                this.mes.addElement(new String(String.valueOf(new StringBuffer("Redundant Half-Reaction with an Inconsistent K:  ").append(_hrxn[pr[i + nR] - nR].getLabel()).append("  K = ").append(K[pr[i + nR]]))));
                reply = false;
            }
        }
        return reply;
    }
}

