/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.AqueousSolution;
import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.Gas;
import edu.davidson.chm.equilibria.HalfReaction;
import edu.davidson.chm.equilibria.Hydrogen_Ion;
import edu.davidson.chm.equilibria.Hydroxide_Ion;
import edu.davidson.chm.equilibria.Liquid;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Solid;
import edu.davidson.chm.equilibria.Solution;
import edu.davidson.chm.equilibria.Species;
import edu.davidson.chm.equilibria.Water;
import java.util.Vector;

public class ChemSystem {
    private final double TEMP = 298.15;
    private final double PRESSURE = 1.0;
    private final boolean ISISOBARIC = true;
    private String label;
    private double temp = 298.15;
    private double pressure = 1.0;
    private boolean isIsobaric = true;
    private boolean isIdeal = true;
    private Vector phases;
    private Vector reactions;
    private Vector halfReactions;
    private Water water = new Water();
    private Hydrogen_Ion hydrogen_ion = new Hydrogen_Ion();
    private Hydroxide_Ion hydroxide_ion = new Hydroxide_Ion();
    private ChemSpecies cation_counterion = new ChemSpecies("X+", 1.0, 1.0);
    private ChemSpecies anion_counterion = new ChemSpecies("X-", -1.0, 1.0);
    private Species[] newSpecies;
    private double[] newCoef;
    private double newEquiv;
    private Phase newPhase;

    public ChemSystem() {
        this.temp = 298.15;
        this.pressure = 1.0;
        this.label = " ";
        this.phases = new Vector();
        this.reactions = new Vector();
        this.halfReactions = new Vector();
    }

    public ChemSystem(String _label) {
        this.label = _label;
        this.temp = 298.15;
        this.pressure = 1.0;
        this.phases = new Vector();
        this.reactions = new Vector();
        this.halfReactions = new Vector();
        this.isIsobaric = true;
    }

    public ChemSystem(String _label, double _temp, double _pressure) {
        this.label = _label;
        this.temp = _temp > 0.0 ? _temp : 298.15;
        this.pressure = _pressure > 0.0 ? _pressure : 1.0;
        this.phases = new Vector();
        this.reactions = new Vector();
        this.halfReactions = new Vector();
        this.isIsobaric = true;
    }

    public void addPhase(Phase _phase) {
        this.phases.addElement(_phase);
    }

    public void addHalfReaction(HalfReaction _halfReaction) {
        this.halfReactions.addElement(_halfReaction);
    }

    public HalfReaction addHalfReaction(String _rxn, String _label, double _Eo) {
        double _stdPot = _Eo;
        if (!this.parse(_rxn)) {
            return null;
        }
        if (this.newEquiv == 0.0) {
            System.out.println("ChemSystem.addHalfReaction:  Use the addReaction method to add a reaction");
            return null;
        }
        if (this.newEquiv < 0.0) {
            this.newEquiv = -this.newEquiv;
            _stdPot = -_stdPot;
            for (int i = 0; i < this.newCoef.length; ++i) {
                this.newCoef[i] = -this.newCoef[i];
            }
        }
        HalfReaction _r = new HalfReaction(_label, this.newSpecies, this.newCoef, _stdPot, this.newEquiv, this.newPhase);
        this.addHalfReaction(_r);
        return _r;
    }

    public void addReaction(Reaction _reaction) {
        this.reactions.addElement(_reaction);
    }

    public Reaction addReaction(String _rxn, String _label, double _K) {
        if (!this.parse(_rxn)) {
            return null;
        }
        if (this.newEquiv != 0.0) {
            System.out.println("ChemSystem.addReaction:  Use the addHalfReaction method to add a half-reaction");
            return null;
        }
        Reaction _r = new Reaction(_label, this.newSpecies, this.newCoef, _K);
        this.addReaction(_r);
        return _r;
    }

    public ChemSystem copyOf(String _label) {
        Object _newRxn;
        Object _rxn;
        int i;
        ChemSystem _cs = new ChemSystem(_label, this.getTemperature(), this.getPressure());
        _cs.setIsIdeal(this.getIsIdeal());
        _cs.setIsIsobaric(this.getIsIsobaric());
        for (i = 0; i < this.phases.size(); ++i) {
            Phase _ph = (Phase)this.phases.elementAt(i);
            _cs.addPhase(_ph.copyOf(_cs));
        }
        for (i = 0; i < this.reactions.size(); ++i) {
            _rxn = (Reaction)this.reactions.elementAt(i);
            if (((Reaction)_rxn).getIsAuto()) continue;
            _newRxn = ((Reaction)_rxn).copyOf(_cs);
            if (_newRxn == null) {
                System.out.println("ChemSystem.copyOf:  Unable to copy Reaction ".concat(String.valueOf(((Reaction)_rxn).getLabel())));
                continue;
            }
            _cs.addReaction((Reaction)_newRxn);
        }
        for (i = 0; i < this.halfReactions.size(); ++i) {
            _rxn = (HalfReaction)this.halfReactions.elementAt(i);
            _newRxn = ((HalfReaction)_rxn).copyOf(_cs);
            if (_newRxn == null) {
                System.out.println("ChemSystem.copyOf:  Unable to copy HalfReaction ".concat(String.valueOf(((HalfReaction)_rxn).getLabel())));
                continue;
            }
            _cs.addHalfReaction((HalfReaction)_newRxn);
        }
        return _cs;
    }

    public Species[] createAcidBaseSpecies(Phase _phase, ChemSpecies[] _chemSpecies, double[] _moles, double[] _Ka, String _reactionLabel) {
        if (_chemSpecies.length != _moles.length) {
            return null;
        }
        if (_Ka.length + 1 != _chemSpecies.length) {
            return null;
        }
        if (!_phase.getIsProtic()) {
            return null;
        }
        Species[] _sp = _phase.createSpecies(_chemSpecies, _moles);
        Species[] _s = new Species[3];
        double[] _c = new double[3];
        _s[1] = _sp[_sp.length - 1];
        _s[2] = _phase.getAcid();
        _c[0] = -1.0;
        _c[1] = 1.0;
        _c[2] = 1.0;
        for (int i = 0; i < _Ka.length; ++i) {
            _s[0] = _s[1];
            _s[1] = _sp[_sp.length - 2 - i];
            String _label = String.valueOf(_reactionLabel).concat(String.valueOf(Integer.toString(i + 1)));
            Reaction _r = new Reaction(_label, _s, _c, _Ka[i]);
            this.addReaction(_r);
        }
        return _sp;
    }

    public Species[] createComplexationSpecies(Phase _phase, ChemSpecies[] _chemSpecies, double[] _moles, double[] _Kf, String _reactionLabel) {
        if (_chemSpecies.length != _moles.length) {
            return null;
        }
        if (_Kf.length + 2 != _chemSpecies.length) {
            return null;
        }
        if (_phase.getPhysicalState() != 'd') {
            return null;
        }
        Species[] _sp = _phase.createSpecies(_chemSpecies, _moles);
        Species[] _s = new Species[3];
        double[] _c = new double[3];
        _s[0] = _sp[0];
        _s[2] = _sp[1];
        _c[0] = -1.0;
        _c[1] = -1.0;
        _c[2] = 1.0;
        for (int i = 0; i < _Kf.length; ++i) {
            _s[1] = _s[2];
            _s[2] = _sp[i + 2];
            String _label = String.valueOf(_reactionLabel).concat(String.valueOf(Integer.toString(i + 1)));
            Reaction _r = new Reaction(_label, _s, _c, _Kf[i]);
            this.addReaction(_r);
        }
        return _sp;
    }

    public AqueousSolution createAqueousPhase(String _label, double _volume) {
        if (_volume <= 0.0) {
            return null;
        }
        AqueousSolution _aqueous = new AqueousSolution(_label, this);
        this.phases.addElement(_aqueous);
        _aqueous.setVolume(_volume);
        return _aqueous;
    }

    public Gas createGasPhase(String _label) {
        Gas _gas = new Gas(_label, this);
        this.phases.addElement(_gas);
        return _gas;
    }

    public Gas createGasPhase(String _label, ChemSpecies _chemSpecies, double _moles) {
        if (_moles < 0.0) {
            return null;
        }
        Gas _gas = new Gas(_label, this);
        this.phases.addElement(_gas);
        _gas.addSpecies(_chemSpecies, _moles);
        return _gas;
    }

    public Liquid createLiquidPhase(ChemSpecies _chemSpecies, double _mass) {
        if (_mass < 0.0) {
            return null;
        }
        Liquid _liquid = new Liquid(_chemSpecies.getLabel(), this, _chemSpecies);
        this.phases.addElement(_liquid);
        _liquid.setMass(_mass);
        return _liquid;
    }

    public Liquid createLiquidPhase(String _label, ChemSpecies _chemSpecies, double _mass) {
        if (_mass < 0.0) {
            return null;
        }
        Liquid _liquid = new Liquid(_label, this, _chemSpecies);
        this.phases.addElement(_liquid);
        _liquid.setMass(_mass);
        return _liquid;
    }

    public Solid createSolidPhase(ChemSpecies _chemSpecies, double _moles) {
        if (_moles < 0.0) {
            return null;
        }
        Solid _solid = new Solid(_chemSpecies.getLabel(), this, _chemSpecies, _moles);
        this.phases.addElement(_solid);
        return _solid;
    }

    public Solid createSolidPhase(String _label, ChemSpecies _chemSpecies, double _moles) {
        if (_moles < 0.0) {
            return null;
        }
        Solid _solid = new Solid(_label, this, _chemSpecies, _moles);
        this.phases.addElement(_solid);
        return _solid;
    }

    public Solution createSolutionPhase(String _label, ChemSpecies _chemSpecies, double _volume) {
        if (_volume <= 0.0) {
            return null;
        }
        Solution _solution = new Solution(_label, this, _chemSpecies);
        this.phases.addElement(_solution);
        _solution.setVolume(_volume);
        return _solution;
    }

    public Solution createSolutionPhase(String _label, ChemSpecies _chemSpecies, double _Kauto, double _volume) {
        if (_volume <= 0.0) {
            return null;
        }
        Solution _solution = new Solution(_label, this, _chemSpecies, _Kauto);
        this.phases.addElement(_solution);
        _solution.setVolume(_volume);
        return _solution;
    }

    public Solution createSolutionPhase(String _label, ChemSpecies _solventChemSpecies, ChemSpecies _acidChemSpecies, ChemSpecies _baseChemSpecies, double _Kauto, double _volume) {
        if (_volume <= 0.0) {
            return null;
        }
        Solution _solution = new Solution(_label, this, _solventChemSpecies, _acidChemSpecies, _baseChemSpecies, _Kauto);
        this.phases.addElement(_solution);
        _solution.setVolume(_volume);
        return _solution;
    }

    public ChemSpecies getCationCounterion() {
        return this.cation_counterion;
    }

    public ChemSpecies getAnionCounterion() {
        return this.anion_counterion;
    }

    public HalfReaction getHalfReaction(String _label) {
        HalfReaction r = null;
        for (int i = 0; i < this.halfReactions.size(); ++i) {
            HalfReaction rr = (HalfReaction)this.halfReactions.elementAt(i);
            if (!rr.getLabel().equals(_label)) continue;
            r = rr;
            break;
        }
        return r;
    }

    public HalfReaction[] getHalfReactions() {
        if (this.halfReactions.size() == 0) {
            return null;
        }
        Object[] r = new HalfReaction[this.halfReactions.size()];
        this.halfReactions.copyInto(r);
        return r;
    }

    public Hydrogen_Ion getHydrogen_Ion() {
        return this.hydrogen_ion;
    }

    public Hydroxide_Ion getHydroxide_Ion() {
        return this.hydroxide_ion;
    }

    public boolean getIsIdeal() {
        return this.isIdeal;
    }

    public String getInfo() {
        return "ChemSystem.class version 2.1  copyright 2000-2001 David N. Blauch";
    }

    public boolean getIsIsobaric() {
        return this.isIsobaric;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNbrPhases() {
        return this.phases.size();
    }

    public int getNbrReactions() {
        return this.reactions.size();
    }

    public Phase getPhase(int _index) {
        if (_index >= 0 && _index < this.phases.size()) {
            return (Phase)this.phases.elementAt(_index);
        }
        return null;
    }

    public Phase getPhase(String _label) {
        Phase p = null;
        for (int i = 0; i < this.phases.size(); ++i) {
            Phase pp = (Phase)this.phases.elementAt(i);
            if (!pp.getLabel().equals(_label)) continue;
            p = pp;
            break;
        }
        return p;
    }

    public Phase[] getPhases() {
        if (this.phases.size() == 0) {
            return null;
        }
        Object[] p = new Phase[this.phases.size()];
        this.phases.copyInto(p);
        return p;
    }

    public double getPotential(Phase _phase) {
        HalfReaction _hr = null;
        for (int i = 0; i < this.halfReactions.size(); ++i) {
            HalfReaction _r = (HalfReaction)this.halfReactions.elementAt(i);
            Phase _ph = _r.getPhase();
            if (_ph == null || !_ph.equals(_phase)) continue;
            _hr = _r;
        }
        if (_hr == null) {
            System.out.println("ChemSystem.getPotential:  Phase not found");
            return 0.0;
        }
        return _hr.getPotential();
    }

    public double getPotential(String _phase) {
        HalfReaction _hr = null;
        for (int i = 0; i < this.halfReactions.size(); ++i) {
            HalfReaction _r = (HalfReaction)this.halfReactions.elementAt(i);
            Phase _ph = _r.getPhase();
            if (_ph == null || !_ph.getLabel().equals(_phase)) continue;
            _hr = _r;
        }
        if (_hr == null) {
            System.out.println("ChemSystem.getPotential:  Phase not found");
            return 0.0;
        }
        return _hr.getPotential();
    }

    public double getPotential(Phase _phase1, Phase _phase2) {
        HalfReaction _hr1 = null;
        HalfReaction _hr2 = null;
        for (int i = 0; i < this.halfReactions.size(); ++i) {
            HalfReaction _r = (HalfReaction)this.halfReactions.elementAt(i);
            Phase _ph = _r.getPhase();
            if (_ph == null) continue;
            if (_ph.equals(_phase1)) {
                _hr1 = _r;
            }
            if (!_ph.equals(_phase2)) continue;
            _hr2 = _r;
        }
        if (_hr1 == null) {
            System.out.println("ChemSystem.getPotential:  Phase1 not found");
            return 0.0;
        }
        if (_hr2 == null) {
            System.out.println("ChemSystem.getPotential:  Phase2 not found");
            return 0.0;
        }
        return _hr1.getPotential() - _hr2.getPotential();
    }

    public double getPotential(String _phase1, String _phase2) {
        HalfReaction _hr1 = null;
        HalfReaction _hr2 = null;
        for (int i = 0; i < this.halfReactions.size(); ++i) {
            HalfReaction _r = (HalfReaction)this.halfReactions.elementAt(i);
            Phase _ph = _r.getPhase();
            if (_ph == null) continue;
            if (_ph.getLabel().equals(_phase1)) {
                _hr1 = _r;
            }
            if (!_ph.getLabel().equals(_phase2)) continue;
            _hr2 = _r;
        }
        if (_hr1 == null) {
            System.out.println("ChemSystem.getPotential:  Phase1 not found");
            return 0.0;
        }
        if (_hr2 == null) {
            System.out.println("ChemSystem.getPotential:  Phase2 not found");
            return 0.0;
        }
        return _hr1.getPotential() - _hr2.getPotential();
    }

    public double getPressure() {
        return this.pressure;
    }

    public Reaction getReaction(int _index) {
        if (_index >= 0 && _index < this.reactions.size()) {
            return (Reaction)this.reactions.elementAt(_index);
        }
        return null;
    }

    public Reaction getReaction(String _label) {
        Reaction r = null;
        for (int i = 0; i < this.reactions.size(); ++i) {
            Reaction rr = (Reaction)this.reactions.elementAt(i);
            if (!rr.getLabel().equals(_label)) continue;
            r = rr;
            break;
        }
        return r;
    }

    public Reaction[] getReactions() {
        if (this.reactions.size() == 0) {
            return null;
        }
        Object[] r = new Reaction[this.reactions.size()];
        this.reactions.copyInto(r);
        return r;
    }

    public Species[] getSpecies() {
        if (this.phases.size() == 0) {
            return null;
        }
        Vector<Species> ss = new Vector<Species>();
        Phase[] p = this.getPhases();
        for (int i = 0; i < p.length; ++i) {
            if (p[i].getNbrSpecies() <= 0) continue;
            for (int j = 0; j < p[i].getNbrSpecies(); ++j) {
                ss.addElement(p[i].getSpeciesAt(j));
            }
        }
        if (ss.size() > 0) {
            Object[] s = new Species[ss.size()];
            ss.copyInto(s);
            return s;
        }
        return null;
    }

    public Species getSpecies(String _label) {
        Species[] s = this.getSpecies();
        Species ss = null;
        if (s == null) {
            return null;
        }
        if (s.length == 0) {
            return null;
        }
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].getLabel().equals(_label)) continue;
            ss = s[i];
            break;
        }
        return ss;
    }

    public Species getSpecies(String _label, String _phaseLabel) {
        Phase _p = this.getPhase(_phaseLabel);
        if (_p == null) {
            return null;
        }
        Species _s = _p.getSpecies(_label);
        return _s;
    }

    public double getTemperature() {
        return this.temp;
    }

    public Water getWater() {
        return this.water;
    }

    public boolean removeHalfReaction(HalfReaction _halfReaction) {
        boolean deleted = this.halfReactions.removeElement(_halfReaction);
        return deleted;
    }

    public boolean removeHalfReaction(String _label) {
        if (this.halfReactions.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.halfReactions.size()) {
            HalfReaction r = (HalfReaction)this.halfReactions.elementAt(i);
            if (!r.getLabel().equals(_label)) continue;
            this.halfReactions.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removePhase(Phase _phase) {
        boolean deleted = this.phases.removeElement(_phase);
        return deleted;
    }

    public boolean removePhase(String _label) {
        if (this.phases.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.phases.size()) {
            Phase p = (Phase)this.phases.elementAt(i);
            if (!p.getLabel().equals(_label)) continue;
            this.phases.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removeReaction(Reaction _reaction) {
        boolean deleted = this.reactions.removeElement(_reaction);
        return deleted;
    }

    public boolean removeReaction(String _label) {
        if (this.reactions.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.reactions.size()) {
            Reaction r = (Reaction)this.reactions.elementAt(i);
            if (!r.getLabel().equals(_label)) continue;
            this.reactions.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void setIsIdeal(boolean _isIdeal) {
        this.isIdeal = _isIdeal;
    }

    public void setIsIsobaric(boolean _isIsobaric) {
        this.isIsobaric = _isIsobaric;
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    public void setPressure(double _pressure) {
        if (_pressure <= 0.0) {
            return;
        }
        this.pressure = _pressure;
    }

    public void setReferenceTemperature(double _temperature) {
        Object _r;
        int i;
        if (_temperature <= 0.0) {
            System.out.println("ChemSystem.setReferenceTemperature:  Temperature must be positive.");
            return;
        }
        if (this.reactions.size() > 0) {
            for (i = 0; i < this.reactions.size(); ++i) {
                _r = (Reaction)this.reactions.elementAt(i);
                ((Reaction)_r).setReferenceTemperature(_temperature);
            }
        }
        if (this.halfReactions.size() > 0) {
            for (i = 0; i < this.halfReactions.size(); ++i) {
                _r = (HalfReaction)this.halfReactions.elementAt(i);
                ((HalfReaction)_r).setReferenceTemperature(_temperature);
            }
        }
    }

    public void setTemperature(double _temp) {
        if (_temp > 0.0) {
            this.temp = _temp;
        }
    }

    public void transferSolution(Phase _solution1, Phase _solution2, double _volume) {
        if (_solution1.getSolvent() == null) {
            System.out.println("ChemSystem.transferSolution:  Solution1 is not a Solution");
            return;
        }
        if (_solution2.getSolvent() == null) {
            System.out.println("ChemSystem.transferSolution:  Solution2 is not a Solution");
            return;
        }
        if (_volume >= _solution1.getVolume()) {
            System.out.println("ChemSystem.transferSolution:  Insufficient amount of solution available");
            return;
        }
        if (!_solution1.getSolvent().getChemSpecies().equals(_solution2.getSolvent().getChemSpecies())) {
            System.out.println("ChemSystem.transferSolution:  Solutions do not have the same solvent");
            return;
        }
        if (_volume <= 0.0) {
            return;
        }
        Species[] _sp = _solution1.getSpecies();
        for (int i = 0; i < _sp.length; ++i) {
            if (_sp[i].getIsSolvent()) continue;
            ChemSpecies _cs = _sp[i].getChemSpecies();
            _solution2.addSpecies(_cs, _sp[i].getAnalConc() * _volume);
            double _moles = _sp[i].getAnalMoles() - _sp[i].getAnalConc() * _volume;
            _sp[i].setAnalMoles(_moles);
        }
        double _V = _solution1.getVolume() - _volume;
        _solution1.setVolume(_V);
        _V = _solution2.getVolume() + _volume;
        _solution2.setVolume(_V);
        for (int i = 0; i < this.reactions.size(); ++i) {
            Reaction _r = (Reaction)this.reactions.elementAt(i);
            if (!_r.getIsHomogeneous() || !_solution1.equals(_r.getPhase()) || _r.getIsAuto()) continue;
            boolean flag = true;
            for (int j = 0; j < this.reactions.size(); ++j) {
                Reaction _rr;
                if (j == i || !_r.isEquivalent(_rr = (Reaction)this.reactions.elementAt(j)) || !_solution2.equals(_rr.getPhase())) continue;
                flag = false;
            }
            if (!flag) continue;
            Species[] _s = _r.getSpecies();
            double[] _c = _r.getCoefficients();
            _sp = new Species[_s.length];
            for (int j = 0; j < _s.length; ++j) {
                _sp[j] = _solution2.getSpecies(_s[j].getChemSpecies());
            }
            Reaction _rr = new Reaction(String.valueOf(_r.getLabel()).concat("_"), _sp, _c, _r.getK());
            _rr.setReferenceTemperature(_r.getReferenceTemperature());
            double[] _KT = _r.getTemperatureDependence();
            _rr.setTemperatureDependence(_KT[0], _KT[1]);
            this.addReaction(_rr);
        }
    }

    protected boolean parse(String _rxn) {
        int ptrSp;
        int i;
        int maxIdx = 20;
        String digits = "0123456789";
        String[] _term = new String[maxIdx];
        String[] _label = new String[maxIdx];
        String[] _sCharge = new String[maxIdx];
        String[] _sCoef = new String[maxIdx];
        String[] _sPhase = new String[maxIdx];
        Species[] _species = new Species[maxIdx];
        Phase[] _phases = new Phase[maxIdx];
        double[] _coef = new double[maxIdx];
        this.newEquiv = 0.0;
        int idx = 0;
        int ptr = 0;
        int ptrEq = _rxn.indexOf(" = ", 0);
        if (ptrEq < 0) {
            System.out.println("ChemSystem.parse:  Missing reaction arrows (=)");
            return false;
        }
        int ptrPl = _rxn.indexOf(" + ", 0);
        while (ptrPl >= 0 && ptrPl < ptrEq) {
            if (idx >= maxIdx) {
                System.out.println("ChemSystem.parse:  Too many reactants");
                return false;
            }
            _term[idx] = _rxn.substring(ptr, ptrPl);
            _coef[idx++] = -1.0;
            ptr = ptrPl + 3;
            ptrPl = _rxn.indexOf(" + ", ptr);
        }
        if (idx >= maxIdx) {
            System.out.println("ChemSystem.parse:  Too many reactants");
            return false;
        }
        _term[idx] = _rxn.substring(ptr, ptrEq);
        _coef[idx++] = -1.0;
        ptr = ptrEq + 3;
        ptrPl = _rxn.indexOf(" + ", ptr);
        while (ptrPl >= 0) {
            if (idx >= maxIdx) {
                System.out.println("ChemSystem.parse:  Too many products");
                return false;
            }
            _term[idx] = _rxn.substring(ptr, ptrPl);
            _coef[idx++] = 1.0;
            ptr = ptrPl + 3;
            ptrPl = _rxn.indexOf(" + ", ptr);
        }
        if (idx >= maxIdx) {
            System.out.println("ChemSystem.parse:  Too many products");
            return false;
        }
        _term[idx] = _rxn.substring(ptr);
        _coef[idx++] = 1.0;
        for (i = 0; i < idx; ++i) {
            if (_term[i].length() == 0) {
                System.out.println("ChemSystem.parse:  Null term");
                return false;
            }
            ptr = 0;
            while (_term[i].charAt(ptr) == ' ') {
                if (++ptr < _term[i].length()) continue;
                System.out.println("ChemSystem.parse:  Blank term");
                return false;
            }
            if (digits.indexOf(this.getChar(_term[i], ptr), ptr) >= 0) {
                ptrSp = _term[i].indexOf(" ", ptr);
                if (ptrSp < 0) {
                    System.out.println("ChemSystem.parse:  Missing species label");
                    return false;
                }
                _sCoef[i] = _term[i].substring(ptr, ptrSp);
                ptr = ptrSp + 1;
            } else {
                _sCoef[i] = "1";
            }
            if (ptr >= _term[i].length()) {
                System.out.println("ChemSystem.parse:  Missing label");
                return false;
            }
            while (_term[i].charAt(ptr) == ' ') {
                if (++ptr < _term[i].length()) continue;
                System.out.println("ChemSystem.parse:  Missing label");
                return false;
            }
            ptrSp = _term[i].indexOf(" ", ptr);
            if (ptrSp < 0) {
                _label[i] = _term[i].substring(ptr);
                ptr = _term[i].length();
            } else {
                _label[i] = _term[i].substring(ptr, ptrSp);
                ptr = ptrSp + 1;
            }
            if (ptr >= _term[i].length()) {
                _sPhase[i] = "";
                continue;
            }
            ptrEq = _term[i].indexOf("(", ptr);
            ptrPl = _term[i].indexOf(")", ptr);
            if (ptrEq < 0 && ptrPl < 0) {
                _sPhase[i] = "";
                continue;
            }
            if (ptrEq < 0 || ptrPl < 0) {
                System.out.println("ChemSystem.parse:  Unbalanced ()");
                return false;
            }
            _sPhase[i] = _term[i].substring(ptrEq + 1, ptrPl);
        }
        for (i = 0; i < idx; ++i) {
            try {
                int n = i;
                _coef[n] = _coef[n] * Double.valueOf(_sCoef[i]);
            }
            catch (NumberFormatException e) {
                System.out.println("ChemSystem.parse:  Invalid coefficient  ".concat(String.valueOf(_sCoef[i])));
                boolean bl = false;
                return bl;
            }
            if (_label[i].equals("e-")) {
                this.newEquiv = -_coef[i];
                if (_sPhase[i].equals("")) {
                    this.newPhase = null;
                    continue;
                }
                this.newPhase = this.getPhase(_sPhase[i]);
                if (this.newPhase != null) continue;
                System.out.println("ChemSystem.parse:  Phase not found  ".concat(String.valueOf(_sPhase[i])));
                return false;
            }
            if (_sPhase[i].length() == 0) {
                _species[i] = this.getSpecies(_label[i]);
                if (_species[i] != null) continue;
                System.out.println(String.valueOf(new StringBuffer("ChemSystem.parse:  Species ").append(_label[i]).append(" not found")));
                return false;
            }
            _phases[i] = this.getPhase(_sPhase[i]);
            if (_phases[i] == null) {
                System.out.println("ChemSystem.parse:  Phase not found  ".concat(String.valueOf(_sPhase[i])));
                return false;
            }
            _species[i] = _phases[i].getSpecies(_label[i]);
            if (_species[i] != null) continue;
            System.out.println(String.valueOf(new StringBuffer("ChemSystem.parse:  Species ").append(_label[i]).append(" not found in phase ").append(_sPhase[i])));
            return false;
        }
        ptrSp = this.newEquiv == 0.0 ? idx : idx - 1;
        this.newCoef = new double[ptrSp];
        this.newSpecies = new Species[ptrSp];
        ptr = 0;
        double _sum = this.newEquiv;
        for (int i2 = 0; i2 < idx; ++i2) {
            if (_label[i2].equals("e-")) continue;
            this.newCoef[ptr] = _coef[i2];
            this.newSpecies[ptr++] = _species[i2];
            _sum += _coef[i2] * _species[i2].getCharge();
        }
        if (_sum != 0.0) {
            System.out.println("ChemSystem.parse:  Equation is not balanced with respect to charge");
            return false;
        }
        return true;
    }

    protected String getChar(String _str, int pos) {
        if (pos >= _str.length()) {
            return "";
        }
        if (pos + 1 >= _str.length()) {
            return _str.substring(pos);
        }
        return _str.substring(pos, pos + 1);
    }
}

