/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

public class ChemSpecies {
    protected double fw = 100.0;
    protected double charge = 0.0;
    protected double ionSize = 0.0;
    protected String label = " ";

    public ChemSpecies() {
    }

    public ChemSpecies(String _label, double _charge, double _fw) {
        if (_fw > 0.0) {
            this.fw = _fw;
        }
        this.charge = _charge;
        this.ionSize = this.charge != 0.0 ? 4.5 : 0.0;
        this.label = _label;
    }

    public static ChemSpecies[] createAcidBase(String _baseLabel, double _baseCharge, double _baseFW, int _n) {
        ChemSpecies[] _chemSp = new ChemSpecies[_n + 1];
        for (int i = 0; i <= _n; ++i) {
            String _label = i == 0 ? _baseLabel : (i == 1 ? "H".concat(String.valueOf(_baseLabel)) : String.valueOf(new StringBuffer("H").append(Integer.toString(i)).append(_baseLabel)));
            double _charge = _baseCharge + (double)i;
            _label = ChemSpecies.makeLabel(_label, _charge);
            double _fw = _baseFW + 1.00797 * (double)i;
            _chemSp[i] = new ChemSpecies(_label, _charge, _fw);
        }
        return _chemSp;
    }

    public static ChemSpecies createChemSpecies(String _data) {
        ChemSpecies _cs = null;
        String _label = "";
        double _charge = 0.0;
        double _fw = 0.0;
        double _ionSize = -1.0;
        int _ctr = 0;
        int _ptr = 0;
        String _tmp = "";
        block6: while (_ptr < _data.length()) {
            if (_data.charAt(_ptr) == ' ') {
                ++_ptr;
                continue;
            }
            if (_data.charAt(_ptr) == ',' || _data.charAt(_ptr) == ';') {
                if (_data.charAt(_ptr) == ';') {
                    _ptr = _data.length();
                }
                ++_ptr;
                switch (_ctr) {
                    case 0: {
                        _label = _tmp;
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 1: {
                        _charge = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 2: {
                        _fw = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 3: {
                        _ionSize = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                }
                continue;
            }
            _tmp = String.valueOf(_tmp).concat(String.valueOf(_data.charAt(_ptr++)));
        }
        if (_ctr < 3) {
            return null;
        }
        _cs = new ChemSpecies(_label, _charge, _fw);
        if (_cs != null && _ionSize >= 0.0) {
            _cs.setIonSize(_ionSize);
        }
        return _cs;
    }

    public static ChemSpecies[] createComplexes(String _metalLabel, double _metalCharge, double _metalFW, String _ligandLabel, double _ligandCharge, double _ligandFW, int _n) {
        ChemSpecies[] _chemSp = new ChemSpecies[_n + 2];
        String _label = ChemSpecies.makeLabel(_ligandLabel, _ligandCharge);
        _chemSp[0] = new ChemSpecies(_label, _ligandCharge, _ligandFW);
        _label = ChemSpecies.makeLabel(_metalLabel, _metalCharge);
        _chemSp[1] = new ChemSpecies(_label, _metalCharge, _metalFW);
        for (int i = 1; i <= _n; ++i) {
            _label = i == 1 ? String.valueOf(_metalLabel).concat(String.valueOf(_ligandLabel)) : String.valueOf(new StringBuffer(String.valueOf(_metalLabel)).append("(").append(_ligandLabel).append(")").append(Integer.toString(i)));
            double _charge = _metalCharge + (double)i * _ligandCharge;
            _label = ChemSpecies.makeLabel(_label, _charge);
            double _fw = _metalFW + (double)i * _ligandFW;
            _chemSp[i + 1] = new ChemSpecies(_label, _charge, _fw);
        }
        return _chemSp;
    }

    public double getCharge() {
        return this.charge;
    }

    public double getFW() {
        return this.fw;
    }

    public double getIonSize() {
        return this.ionSize;
    }

    public String getLabel() {
        return this.label;
    }

    public void setCharge(double _charge) {
        this.charge = _charge;
    }

    public void setFW(double _fw) {
        if (_fw > 0.0) {
            this.fw = _fw;
        }
    }

    public void setIonSize(double _ionSize) {
        if (_ionSize > 0.0) {
            this.ionSize = _ionSize;
        }
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    protected static String makeLabel(String _label, double _charge) {
        String _L = _label;
        if (_charge == -1.0) {
            _L = String.valueOf(_L).concat("-");
        } else if (_charge == 1.0) {
            _L = String.valueOf(_L).concat("+");
        } else if (_charge < 0.0) {
            _L = String.valueOf(new StringBuffer(String.valueOf(_L)).append("-").append(Integer.toString((int)Math.abs(_charge))));
        } else if (_charge > 0.0) {
            _L = String.valueOf(new StringBuffer(String.valueOf(_L)).append("+").append(Integer.toString((int)Math.abs(_charge))));
        }
        return _L;
    }
}

