/*
 * Decompiled with CFR 0.152.
 */
package edu.davidson.chm.equilibria;

import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Solution;
import edu.davidson.chm.equilibria.Species;
import java.util.Vector;

public class AqueousSolution
extends Solution {
    public AqueousSolution() {
    }

    public AqueousSolution(ChemSystem _chemSystem) {
        this.label = "aqueous";
        this.physState = (char)100;
        this.dielectricConstant = 78.4;
        this.chemSystem = _chemSystem;
        this.solvent = new Species(this.chemSystem.getWater(), this);
        this.species = new Vector();
        this.species.addElement(this.solvent);
        this.density = 1.0;
        this.volume = 1.0;
        this.isProtic = true;
        this.solvent.setIsSolvent(true);
        this.solvent.setAnalMoles(1000.0 / this.solvent.getFW());
        this.acid = new Species(this.chemSystem.getHydrogen_Ion(), this);
        this.acid.setIsAcid(true);
        this.species.addElement(this.acid);
        this.base = new Species(this.chemSystem.getHydroxide_Ion(), this);
        this.base.setIsBase(true);
        this.species.addElement(this.base);
        Species[] _sp = new Species[3];
        double[] _coef = new double[3];
        _sp[0] = this.solvent;
        _sp[1] = this.acid;
        _sp[2] = this.base;
        _coef[0] = -1.0;
        _coef[1] = 1.0;
        _coef[2] = 1.0;
        this.autodissociation = new Reaction("autodissociation", _sp, _coef, 1.0041E-14);
        this.autodissociation.setTemperatureDependence(-14683.2875, -26.6298);
        this.autodissociation.setIsAuto(true);
        this.chemSystem.addReaction(this.autodissociation);
        this.addSpecies(_chemSystem.getCationCounterion(), 0.0);
        this.addSpecies(_chemSystem.getAnionCounterion(), 0.0);
    }

    public AqueousSolution(String _label, ChemSystem _chemSystem) {
        this.label = _label;
        this.physState = (char)100;
        this.chemSystem = _chemSystem;
        this.solvent = new Species(this.chemSystem.getWater(), this);
        this.species = new Vector();
        this.species.addElement(this.solvent);
        this.density = 1.0;
        this.volume = 1.0;
        this.isProtic = true;
        this.solvent.setIsSolvent(true);
        this.solvent.setAnalMoles(1000.0 / this.solvent.getFW());
        this.acid = new Species(this.chemSystem.getHydrogen_Ion(), this);
        this.acid.setIsAcid(true);
        this.species.addElement(this.acid);
        this.base = new Species(this.chemSystem.getHydroxide_Ion(), this);
        this.base.setIsBase(true);
        this.species.addElement(this.base);
        Species[] _sp = new Species[3];
        double[] _coef = new double[3];
        _sp[0] = this.solvent;
        _sp[1] = this.acid;
        _sp[2] = this.base;
        _coef[0] = -1.0;
        _coef[1] = 1.0;
        _coef[2] = 1.0;
        this.autodissociation = new Reaction("autodissociation", _sp, _coef, 1.0041E-14);
        this.autodissociation.setTemperatureDependence(-14683.2875, -26.6298);
        this.autodissociation.setIsAuto(true);
        this.chemSystem.addReaction(this.autodissociation);
        this.addSpecies(_chemSystem.getCationCounterion(), 0.0);
        this.addSpecies(_chemSystem.getAnionCounterion(), 0.0);
    }
}

