/*
 * Decompiled with CFR 0.152.
 */
package chemEquilibria;

import edu.davidson.chm.equilibria.ChemSpecies;
import edu.davidson.chm.equilibria.ChemSystem;
import edu.davidson.chm.equilibria.Equilibria;
import edu.davidson.chm.equilibria.Gas;
import edu.davidson.chm.equilibria.HalfReaction;
import edu.davidson.chm.equilibria.Phase;
import edu.davidson.chm.equilibria.Reaction;
import edu.davidson.chm.equilibria.Solution;
import edu.davidson.chm.equilibria.Species;
import edu.davidson.chm.equilibria.Titration;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ChemEquilibria
extends Applet {
    boolean isStandalone = false;
    private double temperature;
    private double pressure;
    private boolean isIsobaric;
    private boolean isIdeal;
    private String[] library;
    private boolean libraryLoaded = false;
    private ChemSystem chemSystem;
    private Equilibria equil;
    private Vector chemSpecies = new Vector();
    private Titration titration = null;
    private double[][] titrationData = null;
    private Vector dataX = new Vector();
    private Vector dataY = new Vector();
    private Vector dataS = new Vector();
    private double std = 0.03;
    private boolean dataSubmitted = false;
    private Vector parRxn = new Vector();
    private Vector parSp = new Vector();
    private double[][] par = null;

    public int getNbrMassBalance() {
        return this.equil.getNbrMassBalance();
    }

    public int getNbrParseMessages() {
        String[] mes = this.equil.getMessages();
        return mes.length;
    }

    public int getNbrPoints() {
        if (this.titrationData == null) {
            return 0;
        }
        return this.titrationData.length;
    }

    public double getPar(int _idx) {
        if (this.par == null) {
            System.out.println("ChemEquilibria.getPar:  Parameters are not available.");
            return 0.0;
        }
        if (_idx < 0) {
            System.out.println("ChemEquilibria.getPar:  Index must not be negative.");
            return 0.0;
        }
        if (_idx < this.parRxn.size() + this.parSp.size()) {
            return this.par[_idx][0];
        }
        System.out.println("ChemEquilibria.getPar:  Index equals or exceeds number of parameters.");
        return 0.0;
    }

    public double getParStd(int _idx) {
        if (this.par == null) {
            System.out.println("ChemEquilibria.getParStd:  Parameters are not available.");
            return 0.0;
        }
        if (_idx < 0) {
            System.out.println("ChemEquilibria.getParStd:  Index must not be negative.");
            return 0.0;
        }
        if (_idx < this.parRxn.size() + this.parSp.size()) {
            return this.par[_idx][1];
        }
        System.out.println("ChemEquilibria.getParStd:  Index equals or exceeds number of parameters.");
        return 0.0;
    }

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.temperature = Double.valueOf(this.getParameter("Temperature", "298.15"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.pressure = Double.valueOf(this.getParameter("Pressure", "1.000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.isIsobaric = Boolean.valueOf(this.getParameter("IsIsobaric", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.isIdeal = Boolean.valueOf(this.getParameter("IsIdeal", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clear();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "ChemEquilibria  version 1.2  Copyright 2000-2001  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"IsIdeal", "boolean", "Determines whether activity coefficients are set to unity or calculated"}, {"IsIsobaric", "boolean", "Isobaric or Isochoric Conditions"}, {"Pressure", "double", "Pressure in atm"}, {"Temperature", "double", "Absolute Temperature"}};
        return pinfo;
    }

    public void addAcidBaseSpecies(String _baseLabel, double _baseCharge, double _baseFW, int _n, String _solutionLabel, double _moles) {
        Phase _p = this.chemSystem.getPhase(_solutionLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addAcidBaseSpecies:  Phase ").append(_solutionLabel).append(" not found")));
            return;
        }
        if (_p.getSolvent() == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addAcidBaseSpecies:  ").append(_solutionLabel).append(" is not a solution")));
            return;
        }
        if (_moles < 0.0) {
            System.out.println("ChemEquilibria.addAcidBaseSpecies:  Amount cannot be negative");
            return;
        }
        if (_baseFW <= 0.0) {
            System.out.println("ChemEquilibria.addAcidBaseSpecies:  Formula weight must be positive");
            return;
        }
        ChemSpecies[] cs = ChemSpecies.createAcidBase((String)_baseLabel, (double)_baseCharge, (double)_baseFW, (int)_n);
        for (int i = 0; i < cs.length; ++i) {
            ChemSpecies _cs = this.getChemSpecies(cs[i].getLabel());
            if (_cs == null) {
                this.chemSpecies.addElement(cs[i]);
                _p.addSpecies(cs[i], _moles);
                continue;
            }
            _p.addSpecies(_cs, _moles);
        }
    }

    public void addComplexes(String _metalLabel, double _metalCharge, double _metalFW, String _ligandLabel, double _ligandCharge, double _ligandFW, int _n, String _solutionLabel, double _moles) {
        Phase _p = this.chemSystem.getPhase(_solutionLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addComplexes:  Phase ").append(_solutionLabel).append(" not found")));
            return;
        }
        if (_p.getSolvent() == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addComplexes:  ").append(_solutionLabel).append(" is not a solution")));
            return;
        }
        if (_moles < 0.0) {
            System.out.println("ChemEquilibria.addComplexes:  Amount cannot be negative");
            return;
        }
        if (_metalFW <= 0.0) {
            System.out.println("ChemEquilibria.addComplexes:  Metal formula weight must be positive");
            return;
        }
        if (_ligandFW <= 0.0) {
            System.out.println("ChemEquilibria.addComplexes:  Ligand formula weight must be positive");
            return;
        }
        ChemSpecies[] cs = ChemSpecies.createComplexes((String)_metalLabel, (double)_metalCharge, (double)_metalFW, (String)_ligandLabel, (double)_ligandCharge, (double)_ligandFW, (int)_n);
        for (int i = 0; i < cs.length; ++i) {
            ChemSpecies _cs = this.getChemSpecies(cs[i].getLabel());
            if (_cs == null) {
                this.chemSpecies.addElement(cs[i]);
                _p.addSpecies(cs[i], _moles);
                continue;
            }
            _p.addSpecies(_cs, _moles);
        }
    }

    public void addDatum(double _Vt, double _pX) {
        if (_Vt < 0.0) {
            System.out.println("ChemEquilibria.addDatum:  Volume of titrant cannot be negative.");
            return;
        }
        this.dataX.addElement(new Double(_Vt));
        this.dataY.addElement(new Double(_pX));
        this.dataS.addElement(new Double(this.std));
        this.dataSubmitted = false;
    }

    public void addDatum(double _Vt, double _pX, double _std) {
        if (_Vt < 0.0) {
            System.out.println("ChemEquilibria.addDatum:  Volume of titrant cannot be negative.");
            return;
        }
        this.dataX.addElement(new Double(_Vt));
        this.dataY.addElement(new Double(_pX));
        this.dataS.addElement(new Double(Math.abs(_std)));
        this.dataSubmitted = false;
    }

    public boolean addHalfReaction(String _label, String _rxn, double _Eo) {
        return this.chemSystem.addHalfReaction(_rxn, _label, _Eo) != null;
    }

    public void addPar(String _type, String _label, String _phaseLabel) {
        if (_type.charAt(0) == 'R') {
            Reaction _rxn = this.chemSystem.getReaction(_label);
            if (_rxn == null) {
                System.out.println("ChemEquilibria.addPar:  Reaction not found:  ".concat(String.valueOf(_label)));
                return;
            }
            this.parRxn.addElement(_rxn);
        } else if (_type.charAt(0) == 'S') {
            Phase _ph = this.chemSystem.getPhase(_phaseLabel);
            if (_ph == null) {
                System.out.println("ChemEquilibria.addPar:  Phase not found:  ".concat(String.valueOf(_phaseLabel)));
                return;
            }
            Species _sp = _ph.getSpecies(_label);
            if (_sp == null) {
                System.out.println("ChemEquilibria.addPar:  Species not found:  ".concat(String.valueOf(_label)));
                return;
            }
            this.parSp.addElement(_sp);
        } else {
            System.out.println("ChemEquilibria.addPar:  _type must be 'R' or 'S'");
            return;
        }
    }

    public boolean addReaction(String _label, String _rxn, double _K) {
        return this.chemSystem.addReaction(_rxn, _label, _K) != null;
    }

    public void addSpecies(String _speciesLabel, String _phaseLabel, double _moles) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addSpecies:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
        if (_cs == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addSpecies:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return;
        }
        _p.addSpecies(_cs, _moles);
    }

    public void addSpecies(String _speciesLabel, double _charge, String _phaseLabel, double _moles) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.addSpecies:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
        if (_cs == null) {
            _cs = new ChemSpecies(_speciesLabel, _charge, 100.0);
            this.chemSpecies.addElement(_cs);
        }
        _p.addSpecies(_cs, _moles);
    }

    public void apply() {
        if (this.par == null || this.titration == null) {
            System.out.println("ChemEquilibria.apply:  Parameters are not available.");
            return;
        }
        this.titration.apply();
    }

    public void calculate(double _finalVolume) {
        if (this.titration == null) {
            System.out.println("ChemEquilibria.calculate:  No Titration object has been created");
            return;
        }
        this.titrationData = this.titration.calcCurve(_finalVolume);
    }

    public void clear() {
        this.chemSystem = new ChemSystem("system", this.temperature, this.pressure);
        this.chemSystem.setIsIsobaric(this.isIsobaric);
        this.chemSystem.setIsIdeal(this.isIdeal);
        if (this.getChemSpecies("H2O") != null) {
            this.deleteChemSpecies("H2O");
        }
        this.chemSpecies.addElement(this.chemSystem.getWater());
        if (this.getChemSpecies("H+") != null) {
            this.deleteChemSpecies("H+");
        }
        this.chemSpecies.addElement(this.chemSystem.getHydrogen_Ion());
        if (this.getChemSpecies("OH-") != null) {
            this.deleteChemSpecies("OH-");
        }
        this.chemSpecies.addElement(this.chemSystem.getHydroxide_Ion());
        this.equil = new Equilibria(this.chemSystem);
    }

    public void clearData() {
        this.dataX = new Vector();
        this.dataY = new Vector();
        this.dataS = new Vector();
        this.dataSubmitted = false;
    }

    public void clearParameters() {
        this.par = null;
        this.parRxn = new Vector();
        this.parSp = new Vector();
    }

    public void createAqueousPhase(String _solutionLabel, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.createAqueousPhase:  Volume must be positive");
            return;
        }
        this.chemSystem.createAqueousPhase(_solutionLabel, _volume);
    }

    public void createChemSpecies(String _label, double _charge, double _fw) {
        if (_fw <= 0.0) {
            System.out.println("ChemEquilibria.createChemSpecies:  Formula weight must be positive");
            return;
        }
        for (int i = 0; i < this.chemSpecies.size(); ++i) {
            ChemSpecies _cs = (ChemSpecies)this.chemSpecies.elementAt(i);
            if (!_cs.getLabel().equals(_label)) continue;
            _cs.setFW(_fw);
            _cs.setCharge(_charge);
            return;
        }
        this.chemSpecies.addElement(new ChemSpecies(_label, _charge, _fw));
    }

    public void createGasPhase(String _gasLabel, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.createGasPhase:  Volume must be positive");
            return;
        }
        Gas _gas = this.chemSystem.createGasPhase(_gasLabel);
        _gas.setVolume(_volume);
    }

    public void createLiquidPhase(String _liquidLabel, String _speciesLabel, double _moles) {
        if (_moles < 0.0) {
            System.out.println("ChemEquilibria.createLiquidPhase:  Number of moles cannot be negative");
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
        if (_cs == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createLiquidPhase:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return;
        }
        this.chemSystem.createLiquidPhase(_liquidLabel, _cs, _moles);
    }

    public void createSolidPhase(String _solidLabel, String _speciesLabel, double _moles) {
        if (_moles < 0.0) {
            System.out.println("ChemEquilibria.createSolidPhase:  Number of moles cannot be negative");
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
        if (_cs == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolidPhase:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return;
        }
        this.chemSystem.createSolidPhase(_solidLabel, _cs, _moles);
    }

    public void createSolutionPhase(String _solutionLabel, String _solventLabel, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.createSolutionPhase:  Volume must be positive");
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_solventLabel);
        if (_cs == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolutionPhase:  ChemSpecies ").append(_solventLabel).append(" not found")));
            return;
        }
        this.chemSystem.createSolutionPhase(_solutionLabel, _cs, _volume);
    }

    public void createSolutionPhase(String _solutionLabel, String _solventLabel, double _Kauto, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.createSolutionPhase:  Volume must be greater than zero");
            return;
        }
        if (_Kauto <= 0.0) {
            System.out.println("ChemEquilibria.createSolutionPhase:  Autodissociation constant must be greater than zero");
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_solventLabel);
        if (_cs == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolutionPhase:  ChemSpecies ").append(_solventLabel).append(" not found")));
            return;
        }
        Solution _soln = this.chemSystem.createSolutionPhase(_solutionLabel, _cs, _Kauto, _volume);
        this.chemSpecies.addElement(_soln.getAcid().getChemSpecies());
        this.chemSpecies.addElement(_soln.getBase().getChemSpecies());
    }

    public void createSolutionPhase(String _solutionLabel, String _solventLabel, String _acidLabel, String _baseLabel, double _Kauto, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.createSolutionPhase:  Volume must be greater than zero");
            return;
        }
        if (_Kauto <= 0.0) {
            System.out.println("ChemEquilibria.createSolutionPhase:  Autodissociation constant must be greater than zero");
            return;
        }
        ChemSpecies _solv = this.getChemSpecies(_solventLabel);
        if (_solv == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolutionPhase:  Solvent ChemSpecies ").append(_solventLabel).append(" not found")));
            return;
        }
        ChemSpecies _acid = this.getChemSpecies(_acidLabel);
        if (_acid == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolutionPhase:  Acid ChemSpecies ").append(_acidLabel).append(" not found")));
            return;
        }
        ChemSpecies _base = this.getChemSpecies(_baseLabel);
        if (_base == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.createSolutionPhase:  Base ChemSpecies ").append(_baseLabel).append(" not found")));
            return;
        }
        Solution _soln = this.chemSystem.createSolutionPhase(_solutionLabel, _solv, _acid, _base, _Kauto, _volume);
    }

    public void createTitration(String _titrantLabel, String _sampleLabel) {
        this.titration = new Titration(this.chemSystem, _titrantLabel, _sampleLabel);
        this.clearParameters();
        this.clearData();
    }

    public boolean fit() {
        int i;
        if (!this.dataSubmitted && !this.submitData()) {
            return false;
        }
        if (this.parRxn.size() + this.parSp.size() == 0) {
            System.out.println("ChemEquilibria.fit:  No parameters have been specified.");
            return false;
        }
        this.titration.clearReactions();
        for (i = 0; i < this.parRxn.size(); ++i) {
            Reaction _rxn = (Reaction)this.parRxn.elementAt(i);
            this.titration.addReaction(_rxn);
        }
        this.titration.clearSpecies();
        for (i = 0; i < this.parSp.size(); ++i) {
            Species _sp = (Species)this.parSp.elementAt(i);
            this.titration.addSpecies(_sp);
        }
        boolean _state = this.titration.fit();
        double[] _par = this.titration.getPar();
        double[] _std = this.titration.getParStd();
        this.par = new double[_par.length][2];
        for (int i2 = 0; i2 < _par.length; ++i2) {
            this.par[i2][0] = Math.exp(_par[i2]);
            this.par[i2][1] = this.par[i2][0] * _std[i2];
        }
        return _state;
    }

    public double getActivity(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getActivity:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getActivity:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getActivity();
    }

    public double getAnalMoles(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getAnalMoles:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getAnalMoles:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getAnalMoles();
    }

    public double getAnalConc(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getAnalConc:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getAnalConc:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getAnalConc();
    }

    public String getChargeBalance(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getChargeBalance:  Phase ").append(_phaseLabel).append(" not found")));
            return null;
        }
        return this.equil.getChargeBalance(_p);
    }

    public double getChiSq() {
        if (this.par == null || this.titration == null) {
            System.out.println("ChemEquilibria.getChiSq:  Chi-Square is not available.");
            return 0.0;
        }
        return this.titration.getChiSq();
    }

    public double getConc(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getConc:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getConc:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getConc();
    }

    public double getDensity(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getDensity:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getDensity();
    }

    public double getDerivative(int _n) {
        if (!this.dataSubmitted && !this.submitData()) {
            return 0.0;
        }
        return this.titration.getDerivative(_n);
    }

    public double getDerivative2(int _n) {
        if (!this.dataSubmitted && !this.submitData()) {
            return 0.0;
        }
        return this.titration.getDerivative2(_n);
    }

    public double getGoodnessOfFit() {
        if (this.par == null || this.titration == null) {
            System.out.println("ChemEquilibria.getGoodnessOfFit:  Goodness-of-Fit is not available.");
            return 0.0;
        }
        return this.titration.getGoodnessOfFit();
    }

    public double getHalfReactionPotential(String _rxnLabel) {
        HalfReaction _r = this.chemSystem.getHalfReaction(_rxnLabel);
        if (_r == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getHalfReaction:  HalfReaction ").append(_rxnLabel).append(" not found")));
            return 0.0;
        }
        return _r.getPotential();
    }

    public double getIonicStrength(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getIonicStrength:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getIonicStrength();
    }

    public double getK(String _label) {
        Reaction _r = this.chemSystem.getReaction(_label);
        if (_r == null) {
            System.out.println("ChemEquilibria.getK:  Reaction not found:  ".concat(String.valueOf(_label)));
            return 0.0;
        }
        return _r.getK();
    }

    public double getK(String _label, double _temperature) {
        if (_temperature <= 0.0) {
            System.out.println("ChemEquilibria.getK:  Temperature must be positive");
            return 0.0;
        }
        Reaction _r = this.chemSystem.getReaction(_label);
        if (_r == null) {
            System.out.println("ChemEquilibria.getK:  Reaction not found:  ".concat(String.valueOf(_label)));
            return 0.0;
        }
        return _r.getK(_temperature);
    }

    public double getMass(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getMass:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getMass:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getMass();
    }

    public String getMassBalance(int idx) {
        String[] mb = this.equil.getMassBalance();
        if (idx < mb.length) {
            return mb[idx];
        }
        return null;
    }

    public double getMinValue() {
        return this.equil.getMinValue();
    }

    public double getMoles(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getMoles:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getMoles:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getMoles();
    }

    public String getParseMessage(int _n) {
        String[] mes = this.equil.getMessages();
        if (_n < mes.length) {
            return mes[_n];
        }
        return "invalid message number";
    }

    public String[] getMessages() {
        return this.equil.getMessages();
    }

    public double getPotential(String _phaseLabel) {
        return this.chemSystem.getPotential(_phaseLabel);
    }

    public double getpH(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getpH:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getpH();
    }

    public double getpK(String _label) {
        Reaction _r = this.chemSystem.getReaction(_label);
        if (_r == null) {
            System.out.println("ChemEquilibria.getK:  Reaction not found:  ".concat(String.valueOf(_label)));
            return 0.0;
        }
        return _r.getpK();
    }

    public double getpK(String _label, double _temperature) {
        if (_temperature <= 0.0) {
            System.out.println("ChemEquilibria.getK:  Temperature must be positive");
            return 0.0;
        }
        Reaction _r = this.chemSystem.getReaction(_label);
        if (_r == null) {
            System.out.println("ChemEquilibria.getK:  Reaction not found:  ".concat(String.valueOf(_label)));
            return 0.0;
        }
        return _r.getpK(_temperature);
    }

    public double getpOH(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getpOH:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getpOH();
    }

    public double getPotential(String _phase1Label, String _phase2Label) {
        return this.chemSystem.getPotential(_phase1Label, _phase2Label);
    }

    public double getPressure(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getPressure:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getPressure();
    }

    public double getPressure(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getPressure:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getPressure:  ChemSpecies ").append(_speciesLabel).append(" not found")));
            return 0.0;
        }
        return _s.getPressure();
    }

    public double getStandardPotential(String _label, double _temperature) {
        if (_temperature <= 0.0) {
            System.out.println("ChemEquilibria.getStandardPotential:  Temperature must be positive");
            return 0.0;
        }
        HalfReaction _r = this.chemSystem.getHalfReaction(_label);
        if (_r == null) {
            System.out.println("ChemEquilibria.getStandardPotential:  HalfReaction not found:  ".concat(String.valueOf(_label)));
            return 0.0;
        }
        return _r.getStandardPotential(_temperature);
    }

    public double getTemperature() {
        return this.chemSystem.getTemperature();
    }

    public double getTitrationValue(int _index) {
        if (this.titrationData == null) {
            return 0.0;
        }
        if (_index < this.titrationData.length) {
            return this.titrationData[_index][1];
        }
        return 0.0;
    }

    public double getVolume(String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.getVolume:  Phase ").append(_phaseLabel).append(" not found")));
            return 0.0;
        }
        return _p.getVolume();
    }

    public double getVolumeTitrant(int _index) {
        if (this.titrationData == null) {
            return 0.0;
        }
        if (_index < this.titrationData.length) {
            return this.titrationData[_index][0];
        }
        return 0.0;
    }

    public void loadLibrary(String _url) {
        Vector _lines = new Vector();
        try {
            String buffer;
            URL url = new URL(_url);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((buffer = in.readLine()) != null) {
                ChemSpecies _newCS = this.parseLine(buffer);
                if (_newCS == null) continue;
                boolean flag = true;
                for (int i = 0; i < this.chemSpecies.size(); ++i) {
                    ChemSpecies _oldCS = (ChemSpecies)this.chemSpecies.elementAt(i);
                    if (!_oldCS.getLabel().equals(_newCS.getLabel())) continue;
                    _oldCS.setFW(_newCS.getFW());
                    _oldCS.setCharge(_newCS.getCharge());
                    _oldCS.setIonSize(_newCS.getIonSize());
                    flag = false;
                }
                if (!flag) continue;
                this.chemSpecies.addElement(_newCS);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            System.out.println("ChemSpecies.loadChemSpecies:  Invalid URL");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("ChemSpecies.loadChemSpecies:  Unable to open or read from library");
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < this.chemSpecies.size(); ++i) {
            ChemSpecies _CS = (ChemSpecies)this.chemSpecies.elementAt(i);
            System.out.println(String.valueOf(new StringBuffer(String.valueOf(_CS.getLabel())).append("   ").append(_CS.getCharge()).append("   ").append(_CS.getFW()).append("   ").append(_CS.getIonSize())));
        }
    }

    public boolean parse() {
        return this.equil.parse();
    }

    public void removeHalfReaction(String _label) {
        this.chemSystem.removeHalfReaction(_label);
    }

    public void removePhase(String _label) {
        Phase _p = this.chemSystem.getPhase(_label);
        if (_p != null) {
            this.chemSystem.removePhase(_p);
        }
    }

    public void removeReaction(String _label) {
        this.chemSystem.removeReaction(_label);
    }

    public void removeSpecies(String _speciesLabel, String _phaseLabel) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.removeSpecies:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        _p.removeSpecies(_speciesLabel);
    }

    public void setAnalConc(String _speciesLabel, String _phaseLabel, double _conc) {
        if (_conc < 0.0) {
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalConc:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
            if (_cs == null) {
                System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalConc:  ChemSpecies ").append(_speciesLabel).append(" not found")));
                return;
            }
            _p.addSpecies(_cs, _conc * _p.getVolume());
        } else {
            _s.setAnalConc(_conc);
        }
    }

    public void setAnalMass(String _speciesLabel, String _phaseLabel, double _mass) {
        if (_mass < 0.0) {
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalMass:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
            if (_cs == null) {
                System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalMass:  ChemSpecies ").append(_speciesLabel).append(" not found")));
                return;
            }
            _p.addSpecies(_cs, _mass / _cs.getFW());
        } else {
            _s.setAnalMoles(_mass / _s.getFW());
        }
    }

    public void setAnalMoles(String _speciesLabel, String _phaseLabel, double _moles) {
        if (_moles < 0.0) {
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalMoles:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
            if (_cs == null) {
                System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalMoles:  ChemSpecies ").append(_speciesLabel).append(" not found")));
                return;
            }
            _p.addSpecies(_cs, _moles);
        } else {
            _s.setAnalMoles(_moles);
        }
    }

    public void setAnalPressure(String _speciesLabel, String _phaseLabel, double _pressure) {
        if (_pressure < 0.0) {
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalPressure:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        Species _s = _p.getSpecies(_speciesLabel);
        if (_s == null) {
            ChemSpecies _cs = this.getChemSpecies(_speciesLabel);
            if (_cs == null) {
                System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAnalPressure:  ChemSpecies ").append(_speciesLabel).append(" not found")));
                return;
            }
            _p.addSpecies(_cs, _pressure * _p.getVolume() / (0.08205783 * this.chemSystem.getTemperature()));
        } else {
            _s.setAnalPressure(_pressure);
        }
    }

    public void setAutoChargeBalance(String _phaseLabel, boolean _val) {
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setAutoChargeBalance:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        _p.setAutoChargeBalance(_val);
    }

    public void setDensity(String _phaseLabel, double _density) {
        if (_density <= 0.0) {
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setDensity:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        _p.setDensity(_density);
    }

    public void setDisplayFitIterations(boolean _displayIterations) {
        if (this.titration != null) {
            this.titration.setDisplayIterations(_displayIterations);
        }
    }

    public void setDisplayFitResults(boolean _displayResults) {
        if (this.titration != null) {
            this.titration.setDisplayResults(_displayResults);
        }
    }

    public void setDisplayIterations(boolean _displayIterations) {
        this.equil.setDisplayIterations(_displayIterations);
    }

    public void setDisplayLinearSystem(boolean _displayLinearSystem) {
        this.equil.setDisplayLinearSystem(_displayLinearSystem);
    }

    public void setDisplayResults(boolean _displayResults) {
        this.equil.setDisplayResults(_displayResults);
    }

    public void setDisplayTime(boolean _displayTime) {
        this.equil.setDisplayTime(_displayTime);
    }

    public void setEquationTolerance(double _eqnTol) {
        if (_eqnTol > 0.0) {
            this.equil.setEquationTolerance(_eqnTol);
        }
    }

    public void setFitChiSqTolerance(double _tol) {
        if (this.titration != null) {
            this.titration.setChiSqTolerance(_tol);
        }
    }

    public void setFitTolerance(double _tol) {
        if (this.titration != null) {
            this.titration.setTolerance(_tol);
        }
    }

    public void setIonSize(String _label, double _ionSize) {
        if (_ionSize <= 0.0) {
            return;
        }
        ChemSpecies _cs = this.getChemSpecies(_label);
        if (_cs != null) {
            _cs.setIonSize(_ionSize);
        }
    }

    public void setIsIdeal(boolean _isIdeal) {
        this.isIdeal = _isIdeal;
        this.chemSystem.setIsIdeal(this.isIdeal);
    }

    public void setIsIsobaric(boolean _isIsobaric) {
        this.isIsobaric = _isIsobaric;
        this.chemSystem.setIsIsobaric(this.isIsobaric);
    }

    public void setK(String _label, double _K) {
        if (_K <= 0.0) {
            System.out.println("ChemEquilibria.setK:  Equilibrium constant must be greater than zero");
            return;
        }
        Reaction _rxn = this.chemSystem.getReaction(_label);
        if (_rxn == null) {
            System.out.println("ChemEquilibria.setK:  Reaction does not exist:  ".concat(String.valueOf(_label)));
            return;
        }
        _rxn.setK(_K);
    }

    public void setLambda(double _lambda) {
        if (this.titration != null) {
            this.titration.setLambda(_lambda);
        }
    }

    public void setLambdaScaleFactor(double _factor) {
        if (this.titration != null) {
            this.titration.setLambdaScaleFactor(_factor);
        }
    }

    public void setMaxCnt(int _maxCnt) {
        if (_maxCnt > 0) {
            this.equil.setMaxCnt(_maxCnt);
        }
    }

    public void setMaxInc(double _maxInc) {
        if (_maxInc > 0.0) {
            this.equil.setMaxInc(_maxInc);
        }
    }

    public void setMonitor(String _chemSpecies) {
        ChemSpecies _cs = this.getChemSpecies(_chemSpecies);
        if (_cs == null) {
            System.out.println("ChemEquilibria.setMonitor:  ChemSpecies not found:  ".concat(String.valueOf(_chemSpecies)));
            return;
        }
        if (this.titration == null) {
            System.out.println("ChemEquilibria.setMonitor:  Titration object has not been created");
            return;
        }
        this.titration.setMonitor(_chemSpecies);
    }

    public void setMonitor(String _label, String _refLabel) {
        if (this.titration == null) {
            System.out.println("ChemEquilibria.setMonitor:  Titration object has not been created");
            return;
        }
        this.titration.setMonitor(_label, _refLabel);
    }

    public void setPressure(double _pressure) {
        if (_pressure > 0.0) {
            this.pressure = _pressure;
            this.chemSystem.setPressure(_pressure);
        }
    }

    public void setReferenceTemperature(double _temperature) {
        if (_temperature <= 0.0) {
            System.out.println("ChemEquilibria.setReferenceTemperature:  Temperature must be positive");
            return;
        }
        this.chemSystem.setReferenceTemperature(_temperature);
    }

    public void setReferenceTemperature(String _label, double _temperature) {
        if (_temperature <= 0.0) {
            System.out.println("ChemEquilibria.setReferenceTemperature:  Temperature must be positive");
            return;
        }
        Reaction _r = this.chemSystem.getReaction(_label);
        if (_r == null) {
            HalfReaction _rr = this.chemSystem.getHalfReaction(_label);
            if (_rr == null) {
                System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setReferenceTemperature:  No Reaction or HalfReaction with label ").append(_label).append(" found")));
            } else {
                _rr.setReferenceTemperature(_temperature);
            }
        } else {
            _r.setReferenceTemperature(_temperature);
        }
    }

    public void setStandardDeviation(double _std) {
        this.std = Math.abs(_std);
    }

    public void setSVDThreshold(double _svdThreshold) {
        if (_svdThreshold > 0.0) {
            this.equil.setSVDThreshold(_svdThreshold);
        }
    }

    public void setTargetIncrement(double _target) {
        if (_target <= 0.0) {
            System.out.println("ChemEquilibria.setTargetIncrement:  Target increment must be positive");
            return;
        }
        if (this.titration == null) {
            System.out.println("ChemEquilibria.setTargetIncrement:  Titration object does not exist");
            return;
        }
        this.titration.setTargetIncrement(_target);
    }

    public void setTemperature(double _temperature) {
        if (_temperature > 0.0) {
            this.temperature = _temperature;
            this.chemSystem.setTemperature(this.temperature);
        }
    }

    public void setTemperatureDependence(String _rxnLabel, double _a, double _b) {
        Reaction _r = this.chemSystem.getReaction(_rxnLabel);
        if (_r == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setTemperatureDependence:  Reaction ").append(_rxnLabel).append(" not found")));
            return;
        }
        _r.setTemperatureDependence(_a, _b);
    }

    public void setTemperatureDependence(String _rxnLabel, double _a, double _b, double _c) {
        HalfReaction _r = this.chemSystem.getHalfReaction(_rxnLabel);
        if (_r == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setTemperatureDependence:  HalfReaction ").append(_rxnLabel).append(" not found")));
            return;
        }
        _r.setTemperatureDependence(_a, _b, _c);
    }

    public void setTolerance(double _tol) {
        if (_tol > 0.0) {
            this.equil.setTolerance(_tol);
        }
    }

    public void setUsePrevious(boolean _usePrevious) {
        this.equil.setUsePrevious(_usePrevious);
    }

    public void setVolume(String _phaseLabel, double _volume) {
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.setVolume:  Volume must be positive");
            return;
        }
        Phase _p = this.chemSystem.getPhase(_phaseLabel);
        if (_p == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.setVolume:  Phase ").append(_phaseLabel).append(" not found")));
            return;
        }
        _p.setVolume(_volume);
    }

    public boolean solve() {
        return this.equil.solveProblem();
    }

    public void transferSolution(String _solution1, String _solution2, double _volume) {
        Phase s1 = this.chemSystem.getPhase(_solution1);
        if (s1 == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.transferSolution:  Solution ").append(_solution1).append(" not found")));
            return;
        }
        if (s1.getSolvent() == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.transferSolution:  ").append(_solution1).append(" is not a solution")));
            return;
        }
        Phase s2 = this.chemSystem.getPhase(_solution2);
        if (s2 == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.transferSolution:  Solution ").append(_solution2).append(" not found")));
            return;
        }
        if (s2.getSolvent() == null) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.transferSolution:  ").append(_solution2).append(" is not a solution")));
            return;
        }
        if (_volume <= 0.0) {
            System.out.println("ChemEquilibria.transferSolution:  Volume must be positive");
            return;
        }
        if (s1.getVolume() <= _volume) {
            System.out.println(String.valueOf(new StringBuffer("ChemEquilibria.transferSolution:  Insufficient amount of ").append(_solution1).append(" available")));
            return;
        }
        if (!s1.getSolvent().getChemSpecies().equals(s2.getSolvent().getChemSpecies())) {
            System.out.println("ChemEquilibria.transferSolution:  Solvents are not the same");
            return;
        }
        this.chemSystem.transferSolution(s1, s2, _volume);
    }

    protected boolean submitData() {
        if (this.titration == null) {
            System.out.println("ChemEquilibria.submitData:  The titration object has not been created.");
            return false;
        }
        if (this.dataX.size() == 0) {
            System.out.println("ChemEquilibria.submitData:  No data has been provided.");
            return false;
        }
        double[] _xData = new double[this.dataX.size()];
        double[] _yData = new double[this.dataX.size()];
        double[] _sData = new double[this.dataX.size()];
        for (int i = 0; i < this.dataX.size(); ++i) {
            _xData[i] = (Double)this.dataX.elementAt(i);
            _yData[i] = (Double)this.dataY.elementAt(i);
            _sData[i] = (Double)this.dataS.elementAt(i);
        }
        this.titration.setData(_xData, _yData, _sData);
        this.dataSubmitted = true;
        return true;
    }

    protected ChemSpecies getChemSpecies(String _label) {
        ChemSpecies _cs = null;
        for (int i = 0; i < this.chemSpecies.size(); ++i) {
            ChemSpecies _s = (ChemSpecies)this.chemSpecies.elementAt(i);
            if (!_s.getLabel().equals(_label)) continue;
            _cs = _s;
            break;
        }
        return _cs;
    }

    protected void deleteChemSpecies(String _label) {
        Object _cs = null;
        for (int i = 0; i < this.chemSpecies.size(); ++i) {
            ChemSpecies _s = (ChemSpecies)this.chemSpecies.elementAt(i);
            if (!_s.getLabel().equals(_label)) continue;
            this.chemSpecies.removeElementAt(i);
            break;
        }
    }

    protected ChemSpecies parseLine(String _data) {
        ChemSpecies _cs = null;
        String _label = "";
        double _charge = 0.0;
        double _fw = 0.0;
        double _ionSize = -1.0;
        int _ctr = 0;
        int _ptr = 0;
        String _tmp = "";
        block6: while (_ptr < _data.length()) {
            if (_data.charAt(_ptr) == ' ') {
                ++_ptr;
                continue;
            }
            if (_data.charAt(_ptr) == ',' || _data.charAt(_ptr) == ';') {
                if (_data.charAt(_ptr) == ';') {
                    _ptr = _data.length();
                }
                ++_ptr;
                switch (_ctr) {
                    case 0: {
                        _label = _tmp;
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 1: {
                        _charge = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 2: {
                        _fw = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                    case 3: {
                        _ionSize = Double.valueOf(_tmp);
                        _tmp = "";
                        ++_ctr;
                        continue block6;
                    }
                }
                continue;
            }
            _tmp = String.valueOf(_tmp).concat(String.valueOf(_data.charAt(_ptr++)));
        }
        if (_ctr < 3) {
            return null;
        }
        _cs = new ChemSpecies(_label, _charge, _fw);
        if (_cs != null && _ionSize >= 0.0) {
            _cs.setIonSize(_ionSize);
        }
        return _cs;
    }
}

