/*
 * Decompiled with CFR 0.152.
 */
package calorimeter;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Random;

public class Calorimeter
extends SApplet
implements SDataSource,
SStepable,
Runnable {
    boolean isStandalone = false;
    private int style;
    private final int MAXSTYLE = 4;
    private Rectangle bounds;
    private boolean initialized = false;
    private Color liquidColor = new Color(50, 100, 255);
    private Color calColor = Color.darkGray;
    private Color sampleColor;
    private Color stirColor = Color.blue;
    private Color backgroundColor;
    private Color bombColor = Color.cyan;
    private boolean showFilament = false;
    private boolean showSample = true;
    private boolean useFilament = false;
    private boolean showStirrer = true;
    private double calFraction = 0.6;
    private double liquidFraction = 0.6;
    private double thermFraction = 0.6;
    private int thermOffsetX = 20;
    private int thermOffsetY = 10;
    private int filOffset = 30;
    private int samOffset = 100;
    private int calTopHeight = 20;
    private int calThickness = 10;
    private int calCurve = 30;
    private int filWidth = 5;
    private int filHeight = 10;
    private int filCnt = 10;
    private Image image;
    private long delay = 20L;
    private int maxCnt = 200;
    private Thread aSample = null;
    private boolean abort = false;
    private boolean isStarted = false;
    private double q = 0.0;
    private double hC = 1000.0;
    private boolean isReset = false;
    private double[][] ds = new double[1][2];
    private double tempOut = 25.0;
    private double temp = 25.0;
    private double tempInitial = 25.0;
    private double time = 0.0;
    private double dtime = 0.2;
    private double fps = 1.0 / this.dtime;
    private double timeStart = 5.0;
    private double timeStop = 50.0;
    private double timeFilament = 10.0;
    private double heatingRate = 1000.0;
    private double tc = 3.0;
    private double slopeInitial = 0.0;
    private double slopeFinal = 0.0;
    private double std = 0.1;
    private Random r = new Random();
    private double tempStart = this.temp + this.slopeInitial * this.timeStart;
    private boolean filState = false;
    private double samState = 0.0;
    private int calX;
    private int calY;
    private int calWidth;
    private int calHeight;
    private int calTopBorder = 5;
    private int bombX;
    private int bombY;
    private int bombWidth;
    private int bombHeight;
    private int bombOffset;
    private int bombThickness = 8;
    private double bombFraction = 0.6;
    private int thermX;
    private int thermY;
    private int thermHeight;
    private int thermCurve = 6;
    private int thermBulbHeight;
    private int thermBulbY;
    private int filX;
    private int filY;
    private int samX;
    private int samY;
    private int samHeight = 50;
    private int samWidth = 10;
    private int samDia = 30;
    private double volLiquid;
    private double volSample;
    private double vol;
    private double volH;
    private double volW;
    private int volHH;
    private double volSampleMax;
    private double samR;
    private int stirX;
    private int stirY;
    private int stirWidth = 3;
    private int stirLength;
    private int stirVane = 8;
    private int stirOffsetX;
    private int stirOffsetY = 5;
    private int[] vaneX = new int[5];
    private int[] vaneY = new int[5];
    private int resOffset = 10;
    private int resX;
    private int resWidth = 200;
    private int resHeight = 100;
    private int resThickness = 5;
    private double resLiquidFraction = 0.8;

    public Calorimeter() {
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clock.addClockListener((SStepable)this);
    }

    public void destroy() {
        this.stopSimulation();
    }

    public String getAppletInfo() {
        return "Calorimeter.class  Version 1.1 Copyright 2000 David N. Blauch";
    }

    public double getMaxTemperature() {
        double max = this.tempInitial;
        double tt = this.tempInitial;
        double ttime = 0.0;
        while (ttime <= this.timeStop) {
            tt = this.getTemperature(ttime += this.dtime);
            if (!(tt > max)) continue;
            max = tt;
        }
        return max + (double)3 * this.std;
    }

    public double getMinTemperature() {
        double min = this.tempInitial;
        double tt = this.tempInitial;
        double ttime = 0.0;
        while (ttime <= this.timeStop) {
            tt = this.getTemperature(ttime += this.dtime);
            if (!(tt < min)) continue;
            min = tt;
        }
        return min - (double)3 * this.std;
    }

    public SApplet getOwner() {
        return this;
    }

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGCOLOR", "Color", "Background Color"}, {"Dt", "double", "Time Increment for Simulation (sec)"}, {"FilamentTime", "double", "Length of Time Filament is Active"}, {"ShowFilament", "boolean", "Display Filament"}, {"ShowSample", "boolean", "Display Sample"}, {"HeatCapacity", "double", "Calorimeter Heat Capacity"}, {"HeatFlow", "double", "Heat Flow for reaction"}, {"HeatingRate", "double", "Filament Heating Rate"}, {"StartTime", "double", "Time when Reaction or Process Starts"}, {"StopTime", "double", "Time when Simulation is Stopped"}, {"Style", "int", "Calorimeter Style"}, {"UseFilament", "boolean", "Activate Filament during Simulation"}};
        return pinfo;
    }

    public double getTemperature() {
        return this.tempOut;
    }

    public double getTemperature(double tm) {
        if (tm <= 0.0) {
            return this.tempInitial;
        }
        if (tm < this.timeStart) {
            return this.tempInitial + this.slopeInitial * tm;
        }
        double T = this.tempInitial + this.slopeInitial * this.timeStart;
        T += this.q * (1.0 - Math.exp(-(tm - this.timeStart) / this.tc)) / this.hC;
        if (this.useFilament) {
            T = tm < this.timeFilament + this.timeStart ? (T += this.heatingRate * (tm - this.timeStart) / this.hC) : (T += this.heatingRate * this.timeFilament / this.hC);
        }
        return T + this.slopeFinal * (tm - this.timeStart);
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.time;
        this.ds[0][1] = this.tempOut;
        return this.ds;
    }

    public String[] getVarStrings() {
        return new String[]{"t", "T"};
    }

    public void init() {
        try {
            this.style = Integer.parseInt(this.getParameter("Style", "1"));
            if (this.style < 0 || this.style > 4) {
                this.style = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.hC = Double.valueOf(this.getParameter("HeatCapacity", "1000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.q = Double.valueOf(this.getParameter("HeatFlow", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.heatingRate = Double.valueOf(this.getParameter("HeatingRate", "1000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.timeFilament = Double.valueOf(this.getParameter("FilamentTime", "5.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.timeStart = Double.valueOf(this.getParameter("StartTime", "5.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.timeStop = Double.valueOf(this.getParameter("StopTime", "50.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dtime = Double.valueOf(this.getParameter("Dt", "0.2"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fps = 1.0 / this.dtime;
        try {
            this.showFilament = Boolean.valueOf(this.getParameter("ShowFilament", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.useFilament = Boolean.valueOf(this.getParameter("UseFilament", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.showSample = Boolean.valueOf(this.getParameter("ShowSample", "true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.backgroundColor = Color.decode(this.getParameter("BGCOLOR", ""));
        }
        catch (NumberFormatException e) {
            this.backgroundColor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    public void paint(Graphics g) {
        ((Component)((Object)this)).setBackground(this.backgroundColor);
        switch (this.style) {
            case 0: {
                break;
            }
            case 1: {
                this.paintStandard(g);
                this.paintThermometer(g);
                if (this.showFilament) {
                    this.paintFilament(g, this.filState);
                }
                if (!this.showSample) break;
                this.paintSample(g, this.samState);
                break;
            }
            case 2: {
                this.paintThermos(g);
                this.paintThermometer(g);
                if (!this.showSample) break;
                this.paintSample(g, this.samState);
                break;
            }
            case 3: {
                this.paintBombCalorimeter(g);
                this.paintThermometer(g);
                break;
            }
            case 4: {
                this.paintReservoir(g, this.samState);
                this.paintThermometer(g);
                break;
            }
            default: {
                System.out.print("Calorimeter.class:  Invalid style\n");
            }
        }
        if (this.showStirrer) {
            this.paintStirrer(g);
        }
    }

    public void resetSimulation() {
        this.stopSimulation();
        if (this.showFilament) {
            this.filState = false;
        }
        this.bounds = ((Component)((Object)this)).getBounds();
        if (!this.initialized) {
            this.defineDefault();
        }
        this.setup();
        ((Component)((Object)this)).repaint();
        this.isReset = true;
        this.clock.setTime(0.0);
    }

    public void setBackgroundColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setBackgroundColor\n");
            return;
        }
        this.backgroundColor = newColor;
        this.isReset = false;
    }

    public void setBombColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setBombColor\n");
            return;
        }
        this.bombColor = newColor;
        this.isReset = false;
    }

    public void setBombHeight(int val) {
        if (val > 0 && val < this.bounds.height) {
            this.bombHeight = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setBombHeight\n");
        }
    }

    public void setBombThickness(int val) {
        if (val > 0) {
            this.bombThickness = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setBombThickness\n");
        }
    }

    public void setBombWidth(int val) {
        if (val > 0 && val < this.bounds.width) {
            this.bombWidth = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setBombWidth\n");
        }
    }

    public void setCalorimeterBodyCurvature(int val) {
        if (val > 0) {
            this.calCurve = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setCalorimeterCurvature\n");
        }
    }

    public void setCalorimeterColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setCalorimeterColor\n");
            return;
        }
        this.calColor = newColor;
        this.isReset = false;
    }

    public void setCalorimeterFraction(double val) {
        if (val <= 1.0 && val >= 0.0) {
            this.calFraction = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setCalorimeterFraction\n");
        }
    }

    public void setCalorimeterTopHeight(int val) {
        if (val >= 0) {
            this.calTopHeight = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setCalorimeterTopHeight\n");
        }
    }

    public void setCalorimeterWallThickness(int val) {
        if (val > 0) {
            this.calThickness = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setCalorimeterWallThickness\n");
        }
    }

    public void setDelay(long val) {
        if (val > (long)0) {
            this.delay = val;
        }
    }

    public void setFilamentHeight(int val) {
        if (val > 0) {
            this.filHeight = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setFilamentHeight\n");
        }
    }

    public void setFilamentOffset(int val) {
        if (this.filOffset > 0) {
            this.filOffset = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setFilamentOffset\n");
        }
    }

    public void setFilamentSectionCount(int val) {
        if (this.filCnt > 0) {
            this.filCnt = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setFilamentSectionCount\n");
        }
    }

    public void setFilamentSectionWidth(int val) {
        if (val > 0) {
            this.filWidth = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setCalorimeterCurvature\n");
        }
    }

    public void setFilamentTime(double val) {
        if (!this.clock.isRunning()) {
            this.timeFilament = val;
        }
    }

    public void setFinalSlope(double val) {
        if (!this.clock.isRunning()) {
            this.slopeFinal = val;
        }
    }

    public void setHeatCapacity(double val) {
        if (!this.clock.isRunning()) {
            if (val > 0.0) {
                this.hC = val;
            } else {
                System.out.print("Calorimeter.class:  Invalid value in setHeatCapacity\n");
            }
        }
    }

    public void setHeatFlow(double val) {
        if (!this.clock.isRunning()) {
            this.q = val;
        }
    }

    public void setHeatingRate(double val) {
        if (!this.clock.isRunning() && val > 0.0) {
            this.heatingRate = val;
        }
    }

    public void setInitialSlope(double val) {
        if (!this.clock.isRunning()) {
            this.slopeInitial = val;
        }
    }

    public void setInitialTemperature(double val) {
        if (!this.clock.isRunning()) {
            this.tempInitial = val;
        }
    }

    public void setLiquidColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setLiquidColor\n");
            return;
        }
        this.liquidColor = newColor;
        this.isReset = false;
    }

    public void setLiquidFraction(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.liquidFraction = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setLiquidFraction\n");
        }
    }

    public void setOwner(SApplet owner) {
    }

    public void setMaxCnt(int val) {
        if (val > 0) {
            this.maxCnt = val;
        }
    }

    public void setRandom(long rnd) {
        if (!this.clock.isRunning()) {
            this.r = new Random(rnd);
        }
    }

    public void setReservoirHeight(int val) {
        if (val > 0) {
            this.resHeight = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setReservoirHeight\n");
        }
    }

    public void setReservoirLiquidFraction(double val) {
        if (val > 0.0 && val < 1.0) {
            this.resLiquidFraction = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setReservoirLiquidFraction\n");
        }
    }

    public void setReservoirOffset(int val) {
        if (val > 0) {
            this.resOffset = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setReservoirOffset\n");
        }
    }

    public void setReservoirThickness(int val) {
        if (val > 0) {
            this.resThickness = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setReservoirThickness\n");
        }
    }

    public void setReservoirWidth(int val) {
        if (val > 0) {
            this.resWidth = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setReservoirWidth\n");
        }
    }

    public void setSampleColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setSampleColor\n");
            return;
        }
        this.sampleColor = newColor;
        this.isReset = false;
    }

    public void setSampleDiameter(int val) {
        if (val > 0) {
            this.samDia = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setSampleDiameter\n");
        }
    }

    public void setSampleHeight(int val) {
        if (val > 0) {
            this.samHeight = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setSampleHeight\n");
        }
    }

    public void setSampleOffset(int val) {
        if (val > 0) {
            this.samOffset = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setSampleOffset\n");
        }
    }

    public void setSampleWidth(int val) {
        if (val > 0) {
            this.samWidth = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setSampleWidth\n");
        }
    }

    public void setStandardDeviation(double val) {
        if (!this.clock.isRunning()) {
            this.std = Math.abs(val);
        }
    }

    public void setStartTime(double val) {
        if (!this.clock.isRunning() && val > 0.0) {
            this.timeStart = val;
        }
    }

    public void setStirrerColor(String rgb) {
        Color newColor;
        try {
            newColor = Color.decode(rgb);
        }
        catch (NumberFormatException e) {
            System.out.print("Calorimeter.class:  Invalid string for setStirrerColor\n");
            return;
        }
        this.stirColor = newColor;
        this.isReset = false;
    }

    public void setStirrerOffsetX(int val) {
        if (val > 0) {
            this.stirOffsetX = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setStirrerOffsetX\n");
        }
    }

    public void setStirrerOffsetY(int val) {
        if (val > 0) {
            this.stirOffsetY = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setStirrerOffsetY\n");
        }
    }

    public void setStirrerWidth(int val) {
        if (val % 2 == 1) {
            ++val;
        }
        if (val > 0) {
            this.stirVane = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setStirrerWidth\n");
        }
    }

    public void setStopTime(double val) {
        if (!this.clock.isRunning()) {
            this.timeStop = val;
        }
    }

    public void setThermometerFraction(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.thermFraction = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setThermometerFraction\n");
        }
    }

    public void setThermometerOffsetX(int val) {
        if (val > 0) {
            this.thermOffsetX = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setThermometerOffsetX\n");
        }
    }

    public void setThermometerOffsetY(int val) {
        if (val > 0) {
            this.thermOffsetY = val;
            this.isReset = false;
        } else {
            System.out.print("Calorimeter.class:  Invalid value in setThermometerOffsetY\n");
        }
    }

    public void setTimeConstant(double val) {
        if (!this.clock.isRunning() && val > 0.0) {
            this.tc = val;
        }
    }

    public void setTimeIncrement(double val) {
        if (!this.clock.isRunning() && val > 0.0) {
            this.dtime = val;
            this.fps = 1.0 / this.dtime;
            this.clock.setDt(this.dtime);
            this.clock.setFPS(this.fps);
        }
    }

    public void setUseFilament(boolean s) {
        this.useFilament = s;
        this.isReset = false;
    }

    public void showFilament(boolean s) {
        this.showFilament = s;
        this.isReset = false;
    }

    public void showSample(boolean s) {
        if (this.style == 1 || this.style == 2 || this.style == 3) {
            this.showSample = s;
            this.isReset = false;
        }
    }

    public void showStirrer(boolean s) {
        this.showStirrer = s;
        this.isReset = false;
    }

    public void start() {
        this.resetSimulation();
    }

    public void startSimulation() {
        if (!this.clock.isRunning() && this.isReset) {
            this.time = 0.0;
            this.tempOut = this.temp = this.tempInitial;
            this.isReset = false;
            this.updateDataConnections();
            this.clock.setTime(this.time);
            this.clock.startClock();
        }
    }

    public void step(double dt, double tm) {
        this.time = tm + dt;
        this.temp = this.getTemperature(this.time);
        this.tempOut = this.temp + this.r.nextGaussian() * this.std;
        this.updateDataConnections();
        if (this.time > this.timeStop) {
            this.clock.stopClock();
            if (this.showFilament) {
                this.filState = false;
                this.paintFilament(((Component)((Object)this)).getGraphics(), this.filState);
            }
        } else if (this.time > this.timeStart) {
            if (this.useFilament && !this.filState && this.time < this.timeStart + this.timeFilament) {
                this.filState = true;
                this.paintFilament(((Component)((Object)this)).getGraphics(), this.filState);
            } else if (this.useFilament && this.filState && this.time > this.timeStart + this.timeFilament) {
                this.filState = false;
                this.paintFilament(((Component)((Object)this)).getGraphics(), this.filState);
            }
        }
        if (!this.isStarted) {
            switch (this.style) {
                case 1: {
                    if (!this.showSample || !(this.time >= this.timeStart - (double)(this.delay * (long)this.maxCnt / (long)1000))) break;
                    this.abort = false;
                    this.isStarted = true;
                    this.aSample = new Thread(this);
                    this.aSample.start();
                    break;
                }
                case 2: {
                    if (!this.showSample || !(this.time >= this.timeStart - (double)(this.delay * (long)this.maxCnt / (long)1000))) break;
                    this.abort = false;
                    this.isStarted = true;
                    this.aSample = new Thread(this);
                    this.aSample.start();
                    break;
                }
                case 3: {
                    if (this.time >= this.timeStart && this.samState == 0.0) {
                        this.samState = 0.5;
                        ((Component)((Object)this)).repaint();
                        break;
                    }
                    if (!(this.time > this.timeStart)) break;
                    this.samState = 1.0;
                    this.isStarted = true;
                    ((Component)((Object)this)).repaint();
                    break;
                }
                case 4: {
                    if (!this.showSample || !(this.time >= this.timeStart - (double)(this.delay * (long)this.maxCnt / (long)1000))) break;
                    this.abort = false;
                    this.isStarted = true;
                    this.aSample = new Thread(this);
                    this.aSample.start();
                    break;
                }
            }
        }
    }

    public void stop() {
        this.stopSimulation();
    }

    public void stopSimulation() {
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
        if (this.aSample != null) {
            if (this.aSample.isAlive()) {
                this.abort = true;
                while (this.aSample.isAlive()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.aSample = null;
        }
    }

    public void run() {
        this.image = ((Component)((Object)this)).createImage(this.bounds.width, this.bounds.height);
        Graphics imageG = this.image.getGraphics();
        Graphics gg = ((Component)((Object)this)).getGraphics();
        for (int i = 0; i <= this.maxCnt && !this.abort; ++i) {
            this.samState = (double)i / (double)this.maxCnt;
            imageG.clearRect(0, 0, this.bounds.width, this.bounds.height);
            this.paint(imageG);
            gg.drawImage(this.image, 0, 0, (ImageObserver)((Object)this));
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void jbInit() throws Exception {
    }

    private void defineDefault() {
        if (this.backgroundColor == null) {
            this.backgroundColor = ((Component)((Object)this)).getBackground();
        } else {
            ((Component)((Object)this)).setBackground(this.backgroundColor);
        }
        switch (this.style) {
            case 0: {
                break;
            }
            case 1: {
                this.sampleColor = Color.lightGray;
                this.stirOffsetX = 200;
                this.samHeight = 50;
                this.samWidth = 10;
                this.samOffset = 100;
                this.delay = 20L;
                break;
            }
            case 2: {
                this.sampleColor = Color.darkGray;
                this.useFilament = false;
                this.showFilament = false;
                this.stirOffsetX = 200;
                this.samOffset = 20;
                this.samDia = 100;
                this.delay = 10L;
                break;
            }
            case 3: {
                this.useFilament = false;
                this.showFilament = false;
                this.sampleColor = Color.decode("#D2B48C");
                this.samState = 0.0;
                this.samHeight = 20;
                this.samWidth = 40;
                this.samOffset = 5;
                if (this.bounds.width > 200) {
                    this.bombWidth = 100;
                    this.bombOffset = 50;
                    this.stirOffsetX = 200;
                    break;
                }
                this.bombWidth = 20;
                this.bombOffset = 30;
                this.stirOffsetX = 5;
                break;
            }
            case 4: {
                this.sampleColor = Color.darkGray;
                this.useFilament = false;
                this.showFilament = false;
                this.showSample = true;
                this.stirOffsetX = 300;
                this.resX = this.calThickness + this.resOffset;
                this.delay = 20L;
                break;
            }
            default: {
                System.out.print("Calorimeter.class:  No defaults for this style\n");
            }
        }
        this.initialized = true;
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
    }

    private void setup() {
        switch (this.style) {
            case 0: {
                break;
            }
            case 1: {
                this.calWidth = this.bounds.width - 1 - 2 * this.calTopBorder;
                this.calHeight = (int)Math.floor(((double)this.bounds.height - 1.0) * this.calFraction);
                this.calX = this.calTopBorder;
                this.calY = this.bounds.height - 1 - this.calHeight;
                this.thermHeight = this.bounds.height - 1 - this.calThickness - this.thermOffsetY;
                this.thermBulbHeight = this.thermHeight / 10;
                this.thermX = this.bounds.width - 1 - this.calThickness - this.thermOffsetX - this.calTopBorder - this.thermCurve;
                this.thermY = 0;
                this.thermBulbY = this.thermY + this.thermHeight - this.thermBulbHeight;
                if (this.showFilament) {
                    this.filX = this.calX + this.calThickness + this.filOffset;
                    this.filY = this.calY + this.calHeight - this.calThickness - this.filHeight;
                }
                if (this.showSample) {
                    this.samX = this.calX + this.calThickness + this.samOffset;
                    this.samY = this.calY + this.calHeight - this.calThickness - this.samHeight;
                }
                this.samState = 0.0;
                break;
            }
            case 2: {
                this.calWidth = this.bounds.width - 1;
                this.calHeight = (int)Math.floor(((double)this.bounds.height - 1.0) * this.calFraction) - this.calThickness;
                this.calX = 0;
                this.calY = this.bounds.height - 1 - this.calHeight;
                this.thermHeight = this.bounds.height - 1 - this.calThickness - this.thermOffsetY;
                this.thermBulbHeight = this.thermHeight / 10;
                this.thermX = this.bounds.width - 1 - this.calThickness - this.thermOffsetX - this.thermCurve;
                this.thermY = 0;
                this.thermBulbY = this.thermY + this.thermHeight - this.thermBulbHeight;
                this.samX = this.calX + this.calThickness + this.samOffset;
                this.samY = this.calY + this.calHeight - this.calThickness - this.samDia;
                this.samState = 0.0;
                break;
            }
            case 3: {
                this.calWidth = this.bounds.width - 1;
                this.calHeight = (int)Math.floor(((double)this.bounds.height - 1.0) * this.calFraction);
                this.calX = 0;
                this.calY = this.bounds.height - 1 - this.calHeight;
                this.thermHeight = this.bounds.height - 1 - this.calThickness - this.thermOffsetY;
                this.thermBulbHeight = this.thermHeight / 10;
                this.thermX = this.bounds.width - 1 - this.calThickness - this.thermOffsetX - this.thermCurve;
                this.thermY = 0;
                this.thermBulbY = this.thermY + this.thermHeight - this.thermBulbHeight;
                this.bombHeight = (int)Math.floor(this.bombFraction * (double)this.calHeight);
                this.bombX = this.calX + this.calThickness + this.bombOffset;
                this.bombY = this.calY + this.calHeight - this.calThickness - this.bombThickness - this.bombHeight;
                this.samX = this.bombX + this.bombWidth - this.bombThickness - this.samWidth - this.samOffset;
                this.samY = this.bombY + this.bombHeight - this.bombThickness - this.samHeight;
                this.isStarted = false;
                this.samState = 0.0;
                break;
            }
            case 4: {
                this.calWidth = this.bounds.width - 1;
                this.calHeight = (int)Math.floor(((double)this.bounds.height - 1.0) * this.calFraction) - this.calThickness;
                this.calX = 0;
                this.calY = this.bounds.height - 1 - this.calHeight;
                this.thermHeight = this.bounds.height - 1 - this.calThickness - this.thermOffsetY;
                this.thermBulbHeight = this.thermHeight / 10;
                this.thermX = this.bounds.width - 1 - this.calThickness - this.thermOffsetX - this.thermCurve;
                this.thermY = 0;
                this.thermBulbY = this.thermY + this.thermHeight - this.thermBulbHeight;
                this.samState = 0.0;
                break;
            }
            default: {
                System.out.print("Calorimeter.class:  Invalid style\n");
            }
        }
        if (this.showStirrer) {
            this.stirX = this.calThickness + this.stirOffsetX;
            this.stirY = 0;
            this.stirLength = this.bounds.height - 1 - this.calThickness - this.stirOffsetY;
            this.vaneX[0] = this.stirX - 3 * this.stirVane + this.stirWidth / 2;
            this.vaneX[1] = this.stirX - 3 * this.stirVane + this.stirWidth / 2;
            this.vaneX[2] = this.stirX + 3 * this.stirVane + this.stirWidth / 2;
            this.vaneX[3] = this.stirX + 3 * this.stirVane + this.stirWidth / 2;
            this.vaneX[4] = this.stirX - 3 * this.stirVane + this.stirWidth / 2;
            this.vaneY[0] = this.stirY + this.stirLength - 2 * this.stirVane;
            this.vaneY[1] = this.stirY + this.stirLength;
            this.vaneY[2] = this.stirY + this.stirLength - 2 * this.stirVane;
            this.vaneY[3] = this.stirY + this.stirLength;
            this.vaneY[4] = this.stirY + this.stirLength - 2 * this.stirVane;
        }
        this.clock.setDt(this.dtime);
        this.clock.setFPS(this.fps);
        this.clock.setTime(0.0);
        this.time = 0.0;
        this.temp = this.tempInitial;
        this.tempOut = this.tempInitial;
        this.updateDataConnections();
        this.volW = this.calWidth - 2 * this.calThickness;
        this.volH = this.liquidFraction * (double)(this.calHeight - this.calThickness);
        this.volLiquid = this.volH * this.volW * this.volW / 4.0;
        this.samR = (double)this.samDia / 2.0;
        this.volSampleMax = 4.0 * this.samR * this.samR * this.samR / 3.0;
        this.volHH = 0;
        this.isStarted = false;
    }

    private void paintStandard(Graphics g) {
        g.setColor(this.calColor);
        g.fillRoundRect(this.calX, this.calY, this.calWidth, this.calHeight, this.calCurve, this.calCurve);
        g.setColor(this.liquidColor);
        g.fillRoundRect(this.calX + this.calThickness, this.calY, this.calWidth - 2 * this.calThickness, this.calHeight - this.calThickness, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY, this.calWidth - 2 * this.calThickness, this.calTopHeight + (int)Math.floor((1.0 - this.liquidFraction) * (double)(this.calHeight - this.calThickness - this.calTopHeight)));
        g.setColor(this.calColor);
        g.fillRect(this.calX - this.calTopBorder, this.calY, this.calWidth + 2 * this.calTopBorder, this.calTopHeight);
    }

    private void paintThermometer(Graphics g) {
        g.setColor(Color.white);
        g.fillRoundRect(this.thermX, this.thermY, this.thermCurve, this.thermHeight, this.thermCurve, this.thermCurve);
        g.setColor(Color.red);
        g.drawLine(this.thermX + this.thermCurve / 2, this.thermY + (int)Math.floor((1.0 - this.thermFraction) * (double)(this.thermHeight - this.thermBulbHeight)), this.thermX + this.thermCurve / 2, this.thermY + this.thermHeight);
        g.fillRoundRect(this.thermX, this.thermBulbY, this.thermCurve, this.thermBulbHeight, this.thermCurve, this.thermCurve);
        g.setColor(Color.black);
        g.drawRoundRect(this.thermX, this.thermY, this.thermCurve, this.thermHeight, this.thermCurve, this.thermCurve);
    }

    private void paintFilament(Graphics g, boolean on) {
        g.setColor(Color.black);
        g.drawLine(this.filX, this.filY, this.filX, this.filY + this.filHeight);
        g.drawLine(this.filX + this.filWidth * this.filCnt, this.filY, this.filX + this.filWidth * this.filCnt, this.filY + this.filHeight);
        if (on) {
            g.setColor(Color.red);
        }
        for (int i = 0; i < this.filCnt; i += 2) {
            g.drawLine(this.filX + i * this.filWidth, this.filY, this.filX + (i + 1) * this.filWidth, this.filY - this.filWidth);
            g.drawLine(this.filX + (i + 1) * this.filWidth, this.filY - this.filWidth, this.filX + (i + 2) * this.filWidth, this.filY);
        }
    }

    private void paintSample(Graphics g, double f) {
        switch (this.style) {
            case 1: {
                g.setColor(this.liquidColor);
                g.fillRect(this.samX, this.samY, this.samHeight, this.samHeight);
                g.setColor(this.backgroundColor);
                g.fillRect(this.samX, this.samY, this.samHeight, this.calY - this.samY + this.calTopHeight + (int)Math.floor((1.0 - this.liquidFraction) * (double)(this.calHeight - this.calThickness - this.calTopHeight)));
                int samH = (int)Math.floor(f * (double)(this.samHeight - this.samWidth));
                g.setColor(Color.black);
                g.fillRect(this.samX, this.samY + samH, this.samHeight, this.samWidth);
                g.fillRect(this.samX + this.samHeight - this.samWidth, this.samY + samH, this.samWidth, this.samHeight - samH);
                if (this.samDia >= this.samHeight - this.samWidth - samH) break;
                g.setColor(Color.white);
                g.fillOval(this.samX, this.samY + this.samHeight - this.samDia, this.samDia, this.samDia);
                g.setColor(this.sampleColor);
                g.fillArc(this.samX, this.samY + this.samHeight - this.samDia, this.samDia, this.samDia, 180, 180);
                break;
            }
            case 2: {
                g.setColor(this.backgroundColor);
                g.fillRect(this.samX, 0, this.samDia, this.calY);
                int samH = (int)Math.floor(f * (double)this.samY);
                g.setColor(this.sampleColor);
                g.fillOval(this.samX, samH, this.samDia, this.samDia);
                break;
            }
            default: {
                System.out.print("Calorimeter.class:  Invalid style for sample\n");
                break;
            }
        }
    }

    private void paintThermos(Graphics g) {
        double tmpH = Math.floor(this.liquidFraction * (double)(this.calHeight - this.calThickness));
        double tmpZ = (double)(this.samDia / 2 + (int)Math.floor(this.samState * (double)this.samY) + this.volHH) - ((double)(this.calY - this.calThickness + this.calHeight) - tmpH);
        this.vol = (double)this.volHH * this.volW * this.volW / 4.0;
        this.volSample = tmpZ < -this.samR ? 0.0 : (tmpZ > this.samR ? this.volSampleMax : tmpZ * (this.samR * this.samR - tmpZ * tmpZ / 3.0) + 2.0 * this.samR * this.samR * this.samR / 3.0);
        while (this.vol < this.volSample) {
            ++this.volHH;
            this.vol = (double)this.volHH * this.volW * this.volW / 4.0;
            if ((tmpZ += 1.0) > this.samR) {
                this.volSample = this.volSampleMax;
                this.volHH = (int)Math.ceil(this.volSampleMax * 4.0 / (this.volW * this.volW));
                break;
            }
            this.volSample = tmpZ * (this.samR * this.samR - tmpZ * tmpZ / 3.0) + 2.0 * this.samR * this.samR * this.samR / 3.0;
        }
        g.setColor(this.liquidColor);
        g.fillRoundRect(this.calX + this.calThickness, this.calY - this.calThickness, this.calWidth - 2 * this.calThickness, this.calHeight, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY - this.calThickness, this.calWidth - 2 * this.calThickness, this.calHeight - this.volHH - (int)Math.floor(this.liquidFraction * (double)(this.calHeight - this.calThickness)));
        g.setColor(Color.black);
        g.drawLine(this.calX, this.calY, this.calX, this.calY + this.calHeight);
        g.drawLine(this.calX + this.calWidth, this.calY, this.calX + this.calWidth, this.calY + this.calHeight);
        g.drawLine(this.calX, this.calY + this.calHeight, this.calX + this.calWidth, this.calY + this.calHeight);
        g.drawArc(this.calX, this.calY - this.calThickness / 2, this.calThickness, this.calThickness, 0, 180);
        g.drawArc(this.calX + this.calWidth - this.calThickness, this.calY - this.calThickness / 2, this.calThickness, this.calThickness, 0, 180);
        g.drawRoundRect(this.calX + this.calThickness, this.calY - this.calCurve, this.calWidth - 2 * this.calThickness, this.calHeight - this.calThickness + this.calCurve, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY - this.calCurve, this.calWidth - 2 * this.calThickness + 1, this.calCurve);
    }

    private void paintBombCalorimeter(Graphics g) {
        g.setColor(this.calColor);
        g.fillRoundRect(this.calX, this.calY, this.calWidth, this.calHeight, this.calCurve, this.calCurve);
        g.setColor(this.liquidColor);
        g.fillRoundRect(this.calX + this.calThickness, this.calY, this.calWidth - 2 * this.calThickness, this.calHeight - this.calThickness, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY, this.calWidth - 2 * this.calThickness, this.calCurve / 2);
        g.setColor(this.bombColor);
        g.fillRect(this.bombX, this.bombY, this.bombWidth, this.bombHeight);
        g.fillOval(this.bombX + this.bombThickness, this.bombY + this.bombHeight - this.bombThickness, 2 * this.bombThickness, 2 * this.bombThickness);
        g.fillOval(this.bombX + this.bombWidth - 3 * this.bombThickness, this.bombY + this.bombHeight - this.bombThickness, 2 * this.bombThickness, 2 * this.bombThickness);
        g.fillRect(this.bombX - this.bombThickness, this.bombY - this.bombThickness, this.bombWidth + 2 * this.bombThickness, this.bombThickness);
        g.fillRect(this.bombX - this.bombThickness, this.bombY, this.bombThickness, 2 * this.bombThickness);
        g.fillRect(this.bombX + this.bombWidth, this.bombY, this.bombThickness, 2 * this.bombThickness);
        if (this.samState <= 0.0 || this.samState >= 1.0) {
            g.setColor(this.backgroundColor);
        } else {
            g.setColor(Color.yellow);
        }
        g.fillRect(this.bombX + this.bombThickness, this.bombY, this.bombWidth - 2 * this.bombThickness, this.bombHeight - this.bombThickness);
        g.setColor(Color.black);
        g.drawLine(this.bombX, this.bombY + 2 * this.bombThickness, this.bombX, this.bombY);
        g.drawLine(this.bombX, this.bombY, this.bombX + this.bombWidth - 1, this.bombY);
        g.drawLine(this.bombX + this.bombWidth - 1, this.bombY, this.bombX + this.bombWidth - 1, this.bombY + 2 * this.bombThickness);
        g.drawLine(this.bombX + this.bombThickness, this.bombY + this.bombHeight, this.bombX + 3 * this.bombThickness - 1, this.bombY + this.bombHeight);
        g.drawLine(this.bombX + this.bombWidth - 3 * this.bombThickness, this.bombY + this.bombHeight, this.bombX + this.bombWidth - this.bombThickness - 1, this.bombY + this.bombHeight);
        if (this.showSample) {
            g.setColor(this.bombColor);
            g.fillRect(this.samX, this.samY, this.samWidth, this.samHeight);
            if (this.samState <= 0.0) {
                g.setColor(this.sampleColor);
                g.fillOval(this.samX, this.samY - this.samHeight / 2, this.samWidth, this.samHeight);
                g.setColor(this.backgroundColor);
                g.fillRect(this.samX, this.samY - this.samHeight / 2, this.samWidth, this.samHeight / 2);
            } else if (this.samState < 1.0) {
                g.setColor(Color.yellow);
                g.fillOval(this.samX, this.samY - this.samHeight / 2, this.samWidth, this.samHeight);
            } else {
                g.setColor(this.backgroundColor);
                g.fillOval(this.samX, this.samY - this.samHeight / 2, this.samWidth, this.samHeight);
            }
            g.setColor(Color.black);
            g.drawLine(this.samX, this.samY + this.samHeight, this.samX + this.samWidth - 1, this.samY + this.samHeight);
        }
        g.setColor(Color.black);
        g.fillRect(this.samX, this.calY - this.calThickness - 2 * this.bombThickness - 3 * this.samHeight / 2, 2, this.calHeight);
        g.fillRect(this.samX + this.samWidth - 2, this.calY - this.calThickness - 2 * this.bombThickness - 3 * this.samHeight / 2, 2, this.calHeight);
        if (this.samState == 0.0) {
            g.drawLine(this.samX + 1, this.samY - this.samHeight / 2, this.samX + this.samWidth / 5, this.samY);
            g.drawLine(this.samX + this.samWidth / 5, this.samY, this.samX - 2 + 4 * this.samWidth / 5, this.samY);
            g.drawLine(this.samX - 2 + 4 * this.samWidth / 5, this.samY, this.samX + this.samWidth - 2, this.samY - this.samHeight / 2);
        }
        g.setColor(this.backgroundColor);
        g.fillRect(this.bombX + 2 * this.bombThickness, this.bombY - 3 * this.bombThickness, 3, 3 * this.bombThickness + 1);
        g.setColor(Color.black);
        g.drawLine(this.bombX + 2 * this.bombThickness, this.bombY - 3 * this.bombThickness, this.bombX + 2 * this.bombThickness, this.bombY);
        g.drawLine(this.bombX + 2 * this.bombThickness + 3, this.bombY - 3 * this.bombThickness, this.bombX + 2 * this.bombThickness + 3, this.bombY);
        g.fillRect(this.bombX + this.bombThickness, this.bombY - 2 * this.bombThickness, 2 * this.bombThickness, 2);
    }

    private void paintReservoir(Graphics g, double f) {
        int tmp;
        int tmpZ = 0;
        if (f <= 0.0) {
            tmp = (int)Math.floor(this.resLiquidFraction * (double)(this.resHeight - this.resThickness));
        } else if (f >= 1.0) {
            tmp = 0;
            tmpZ = (int)Math.floor(this.resLiquidFraction * (double)(this.resHeight - this.resThickness)) * (this.resWidth - 2 * this.resThickness) * (this.resWidth - 2 * this.resThickness) / ((this.calWidth - 2 * this.calThickness) * (this.calWidth - 2 * this.calThickness));
        } else {
            tmp = (int)Math.floor((1.0 - f) * this.resLiquidFraction * (double)(this.resHeight - this.resThickness));
            tmpZ = (int)(Math.floor(this.resLiquidFraction * (double)(this.resHeight - this.resThickness)) - (double)tmp) * (this.resWidth - 2 * this.resThickness) * (this.resWidth - 2 * this.resThickness) / ((this.calWidth - 2 * this.calThickness) * (this.calWidth - 2 * this.calThickness));
        }
        g.setColor(this.liquidColor);
        g.fillRoundRect(this.calX + this.calThickness, this.calY - this.calThickness, this.calWidth - 2 * this.calThickness, this.calHeight, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY - this.calThickness, this.calWidth - 2 * this.calThickness, this.calHeight - tmpZ - (int)Math.floor(this.liquidFraction * (double)(this.calHeight - this.calThickness)));
        g.setColor(Color.black);
        g.drawLine(this.calX, this.calY, this.calX, this.calY + this.calHeight);
        g.drawLine(this.calX + this.calWidth, this.calY, this.calX + this.calWidth, this.calY + this.calHeight);
        g.drawLine(this.calX, this.calY + this.calHeight, this.calX + this.calWidth, this.calY + this.calHeight);
        g.drawArc(this.calX, this.calY - this.calThickness / 2, this.calThickness, this.calThickness, 0, 180);
        g.drawArc(this.calX + this.calWidth - this.calThickness, this.calY - this.calThickness / 2, this.calThickness, this.calThickness, 0, 180);
        g.drawRoundRect(this.calX + this.calThickness, this.calY - this.calCurve, this.calWidth - 2 * this.calThickness, this.calHeight - this.calThickness + this.calCurve, this.calCurve, this.calCurve);
        g.setColor(this.backgroundColor);
        g.fillRect(this.calX + this.calThickness, this.calY - this.calCurve, this.calWidth - 2 * this.calThickness + 1, this.calCurve);
        g.setColor(Color.black);
        g.fillRect(this.resX, 0, this.resWidth, this.resHeight);
        g.drawLine(this.resX + this.resWidth / 2 - 4, this.resHeight, this.resX + this.resWidth / 2 - 4, this.resHeight + 30);
        g.drawLine(this.resX + this.resWidth / 2 + 4, this.resHeight, this.resX + this.resWidth / 2 + 4, this.resHeight + 30);
        g.fillRect(this.resX + this.resWidth / 2 - 9, this.resHeight + 15, 20, 6);
        if (f <= 0.0) {
            g.setColor(this.liquidColor);
            g.fillRect(this.resX + this.resThickness, 0, this.resWidth - 2 * this.resThickness, this.resHeight - this.resThickness);
            g.fillRect(this.resX + this.resWidth / 2 - 3, this.resHeight - this.resThickness, 7, this.resThickness + 15);
            g.setColor(this.backgroundColor);
            g.fillRect(this.resX + this.resThickness, 0, this.resWidth - 2 * this.resThickness, (int)Math.floor((1.0 - this.resLiquidFraction) * (double)(this.resHeight - this.resThickness)));
            g.setColor(Color.black);
            g.fillOval(this.resX + this.resWidth / 2 + 10, this.resHeight + 14, 8, 8);
        } else if (f >= 1.0) {
            g.setColor(this.backgroundColor);
            g.fillRect(this.resX + this.resThickness, 0, this.resWidth - 2 * this.resThickness, this.resHeight - this.resThickness);
            g.fillRect(this.resX + this.resWidth / 2 - 3, this.resHeight - this.resThickness, 7, this.resThickness + 15);
            g.setColor(Color.black);
            g.fillOval(this.resX + this.resWidth / 2 + 10, this.resHeight + 14, 8, 8);
        } else {
            g.setColor(this.liquidColor);
            g.fillRect(this.resX + this.resThickness, 0, this.resWidth - 2 * this.resThickness, this.resHeight - this.resThickness);
            g.fillRect(this.resX + this.resWidth / 2 - 3, this.resHeight - this.resThickness, 7, this.resThickness + 15);
            g.fillRect(this.resX + this.resWidth / 2 - 3, this.resHeight + 21, 7, this.bounds.height - this.calThickness - this.resHeight - 22);
            g.setColor(this.backgroundColor);
            g.fillRect(this.resX + this.resThickness, 0, this.resWidth - 2 * this.resThickness, this.resHeight - this.resThickness - tmp);
            g.setColor(Color.black);
            g.fillOval(this.resX + this.resWidth / 2 + 10, this.resHeight + 10, 8, 16);
        }
    }

    private void paintStirrer(Graphics g) {
        g.setColor(this.stirColor);
        g.fillRect(this.stirX, this.stirY, this.stirWidth, this.stirLength);
        g.fillPolygon(this.vaneX, this.vaneY, 5);
    }
}

