/*
 * Decompiled with CFR 0.152.
 */
package bulbs;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Bulbs
extends Applet {
    boolean isStandalone = false;
    private int diaL = 0;
    private int diaR = 0;
    private Color colorL;
    private Color colorR;
    private Color colorM;
    private Color colorBkg = null;
    private double volL;
    private double volR;
    private int tubeLength = 20;
    private int tubeWidth = 8;
    private int stopcockDia = 10;
    private int stopcockWidth = 16;
    private int diaHole = 4;
    private int stopcockBorder = 3;
    private boolean isSet = false;
    private boolean isOpen = false;
    private Rectangle bounds = null;
    private int xL;
    private int yL;
    private int xR;
    private int yR;
    private int xTube;
    private int yTube;
    private int border;
    private int aL;
    private int arcL;
    private int aR;
    private int arcR;
    private int xStopcock;
    private int yStopcock;
    private int xClosed;
    private int yClosed;
    private int xOpen;
    private int yOpen;
    private int xHole;
    private int yHole;
    private Polygon stopcock;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.volL = Double.valueOf(this.getParameter("LeftVolume", "1.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.volL = 1.0;
        }
        if (this.volL <= 0.0) {
            this.volL = 1.0;
        }
        try {
            this.diaL = Integer.parseInt(this.getParameter("LeftDiameter", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.diaL = 0;
        }
        if (this.diaL < 0) {
            this.diaL = 0;
        }
        try {
            this.diaR = Integer.parseInt(this.getParameter("RightDiameter", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.diaR = 0;
        }
        if (this.diaR < 0) {
            this.diaR = 0;
        }
        try {
            this.colorBkg = Color.decode(this.getParameter("BGColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorL = Color.decode(this.getParameter("LeftColor", "#FFA0A0"));
        }
        catch (NumberFormatException e) {
            this.colorL = new Color(255, 160, 160);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorR = Color.decode(this.getParameter("RightColor", "#A0FFA0"));
        }
        catch (NumberFormatException e) {
            this.colorL = new Color(160, 255, 160);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.colorM = Color.decode(this.getParameter("MixtureColor", "#A0A0FF"));
        }
        catch (NumberFormatException e) {
            this.colorL = new Color(160, 160, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.diaHole = Integer.parseInt(this.getParameter("HoleDiameter", "4"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.diaHole = 4;
        }
        if (this.diaHole <= 0) {
            this.diaHole = 4;
        }
        try {
            this.stopcockBorder = Integer.parseInt(this.getParameter("StopcockBorder", "3"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopcockBorder = 3;
        }
        if (this.stopcockBorder <= 0) {
            this.stopcockBorder = 3;
        }
        try {
            this.stopcockWidth = Integer.parseInt(this.getParameter("StopcockWidth", "16"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopcockWidth = 16;
        }
        if (this.stopcockWidth <= 0) {
            this.stopcockWidth = 16;
        }
        try {
            this.stopcockDia = Integer.parseInt(this.getParameter("StopcockDiameter", "10"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopcockDia = 10;
        }
        if (this.stopcockDia <= 0) {
            this.stopcockDia = 10;
        }
        try {
            this.tubeLength = Integer.parseInt(this.getParameter("TubeLength", "20"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tubeLength = 20;
        }
        if (this.tubeLength <= 0) {
            this.tubeLength = 20;
        }
        try {
            this.tubeWidth = Integer.parseInt(this.getParameter("TubeWidth", "8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tubeWidth = 8;
        }
        if (this.tubeWidth <= 0) {
            this.tubeWidth = 8;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
        this.setup();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Bulbs.class  version 1.0  Copyright 2000  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGColor", "String", "Integer representation of background color"}, {"HoleDiameter", "int", "Diameter in pixels of the hole through the stopcock"}, {"LeftColor", "String", "Color of gas in left bulb"}, {"LeftDiameter", "int", "Diameter in pixels of the Left Bulb"}, {"LeftVolume", "double", "Volume in liters of the left bulb"}, {"MixtureColor", "String", "Color of gas after stopcock is open"}, {"RightColor", "String", "Color of gas in right bulb"}, {"RightDiameter", "int", "Diameter in pixels of the right bulb"}, {"StopcockBorder", "int", "Extension in pixels of stopcock above and below tube"}, {"StopcockDiameter", "int", "Diameter in pixels of the stopcock"}, {"StopcockWidth", "int", "Width in pixels of the stopcock knob"}, {"TubeLength", "int", "Length in pixels of the connecting tube"}, {"TubeWidth", "int", "Width in pixels of the connecting tube"}};
        return pinfo;
    }

    public double getLeftVolume() {
        return this.volL;
    }

    public double getRightVolume() {
        return this.volR;
    }

    public double getVolume() {
        return this.volL + this.volR;
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            if (this.isOpen) {
                g.setColor(this.colorM);
                g.fillOval(this.xL, this.yL, this.diaL, this.diaL);
                g.fillOval(this.xR, this.yR, this.diaR, this.diaR);
                g.fillRect(this.xTube, this.yTube, this.tubeLength, this.tubeWidth);
            } else {
                g.setColor(this.colorR);
                g.fillOval(this.xR, this.yR, this.diaR, this.diaR);
                g.fillRect(this.xTube, this.yTube, this.tubeLength, this.tubeWidth);
                g.setColor(this.colorL);
                g.fillOval(this.xL, this.yL, this.diaL, this.diaL);
                g.fillRect(this.xTube, this.yTube, this.tubeLength / 2, this.tubeWidth);
            }
            g.setColor(Color.black);
            g.drawArc(this.xL, this.yL, this.diaL, this.diaL, this.aL, this.arcL);
            g.drawArc(this.xR, this.yR, this.diaR, this.diaR, this.aR, this.arcR);
            g.drawLine(this.xTube, this.yTube, this.xTube + this.tubeLength, this.yTube);
            g.drawLine(this.xTube, this.yTube + this.tubeWidth, this.xTube + this.tubeLength, this.yTube + this.tubeWidth);
            g.setColor(this.colorBkg);
            g.fillPolygon(this.stopcock);
            if (this.isOpen) {
                g.setColor(this.colorM);
                g.fillRect(this.xTube, this.yHole, this.tubeLength, this.diaHole);
                g.setColor(Color.black);
                g.drawOval(this.xOpen, this.yOpen, this.stopcockWidth, this.stopcockDia);
            } else {
                g.setColor(Color.black);
                g.drawOval(this.xClosed, this.yClosed, this.stopcockDia, this.stopcockDia);
                g.drawOval(this.xHole, this.yHole, this.diaHole, this.diaHole);
            }
            g.drawPolygon(this.stopcock);
        }
    }

    public void setDiameters(int _leftDiameter, int _rightDiameter) {
        this.diaL = _leftDiameter < 0 ? 0 : _leftDiameter;
        this.diaR = _rightDiameter < 0 ? 0 : _rightDiameter;
        this.isOpen = false;
        this.setup();
    }

    public void setLeftColor(String _color) {
        Color _colorL;
        try {
            _colorL = Color.decode(_color);
        }
        catch (NumberFormatException e) {
            _colorL = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            _colorL = null;
        }
        if (_colorL != null) {
            this.colorL = _colorL;
        }
        this.repaint();
    }

    public void setLeftColor(int _red, int _green, int _blue) {
        if (_red < 0 || _red > 255) {
            return;
        }
        if (_green < 0 || _green > 255) {
            return;
        }
        if (_blue < 0 || _blue > 255) {
            return;
        }
        this.colorL = new Color(_red, _green, _blue);
        this.repaint();
    }

    public void setLeftVolume(double _volume) {
        if (_volume > 0.0) {
            this.volL = _volume;
            this.volR = (double)this.diaR / (double)this.diaL;
            this.volR = this.volL * this.volR * this.volR * this.volR;
        }
    }

    public void setMixtureColor(String _color) {
        Color _colorM;
        try {
            _colorM = Color.decode(_color);
        }
        catch (NumberFormatException e) {
            _colorM = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            _colorM = null;
        }
        if (_colorM != null) {
            this.colorM = _colorM;
        }
        this.repaint();
    }

    public void setMixtureColor(int _red, int _green, int _blue) {
        if (_red < 0 || _red > 255) {
            return;
        }
        if (_green < 0 || _green > 255) {
            return;
        }
        if (_blue < 0 || _blue > 255) {
            return;
        }
        this.colorM = new Color(_red, _green, _blue);
        this.repaint();
    }

    public void setRightColor(String _color) {
        Color _colorR;
        try {
            _colorR = Color.decode(_color);
        }
        catch (NumberFormatException e) {
            _colorR = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            _colorR = null;
        }
        if (_colorR != null) {
            this.colorR = _colorR;
        }
        this.repaint();
    }

    public void setRightColor(int _red, int _green, int _blue) {
        if (_red < 0 || _red > 255) {
            return;
        }
        if (_green < 0 || _green > 255) {
            return;
        }
        if (_blue < 0 || _blue > 255) {
            return;
        }
        this.colorR = new Color(_red, _green, _blue);
        this.repaint();
    }

    public void setRightVolume(double _volume) {
        if (_volume > 0.0) {
            this.volR = _volume;
            this.volL = (double)this.diaL / (double)this.diaR;
            this.volL = this.volR * this.volL * this.volL * this.volL;
        }
    }

    public void setStopcockState(boolean _state) {
        this.isOpen = _state;
        this.repaint();
    }

    private void setup() {
        double _tmp;
        int[] _x = new int[5];
        int[] _y = new int[5];
        this.bounds = this.getBounds();
        if (this.stopcockWidth >= this.tubeLength || this.stopcockDia >= this.stopcockWidth || this.diaHole >= this.tubeWidth) {
            System.out.println("Bulbs.class:  Invalid Stopcock and Tube Parameter(s);  resetting values ...");
            this.setDefaults();
        }
        if (this.diaL == 0 && this.diaR == 0) {
            this.diaR = this.diaL = (this.bounds.width - 2 - this.tubeLength) / 2;
        } else if (this.diaL == 0) {
            this.diaL = this.bounds.width - 2 - this.tubeLength - this.diaR;
        } else if (this.diaR == 0) {
            this.diaR = this.bounds.width - 2 - this.tubeLength - this.diaL;
        } else if (this.diaL + this.diaR + this.tubeLength >= this.bounds.width) {
            System.out.println("Bulbs.class:  Bulbs and tube sizes are too large;  resetting values ...");
            this.setDefaults();
            _tmp = (double)(this.bounds.width - this.tubeLength) / (double)(this.diaL + this.diaR);
            this.diaL = (int)Math.floor((double)this.diaL * _tmp) - 1;
            this.diaR = (int)Math.floor((double)this.diaR * _tmp) - 1;
        }
        if (this.diaL >= this.bounds.height || this.diaR >= this.bounds.height) {
            _tmp = this.bounds.height;
            _tmp = this.diaL > this.diaR ? (_tmp /= (double)this.diaL) : (_tmp /= (double)this.diaR);
            this.diaL = (int)Math.floor((double)this.diaL * _tmp) - 1;
            this.diaR = (int)Math.floor((double)this.diaR * _tmp) - 1;
        }
        this.volR = (double)this.diaR / (double)this.diaL;
        this.volR = this.volL * this.volR * this.volR * this.volR;
        this.border = (this.bounds.width - this.diaL - this.tubeLength - this.diaR) / 2;
        if (this.colorBkg == null) {
            this.colorBkg = this.getBackground();
        } else {
            this.setBackground(this.colorBkg);
        }
        this.xL = this.border;
        this.yL = (this.bounds.height - this.diaL) / 2;
        this.xTube = this.xL + this.diaL;
        this.yTube = (this.bounds.height - this.tubeWidth) / 2;
        this.xR = this.xTube + this.tubeLength;
        this.yR = (this.bounds.height - this.diaR) / 2;
        this.aL = (int)Math.round(180.0 * Math.atan((double)this.tubeWidth / (double)this.diaL) / Math.PI);
        this.arcL = 360 - 2 * this.aL;
        this.aR = (int)Math.round(180.0 * Math.atan((double)this.tubeWidth / (double)this.diaR) / Math.PI);
        this.arcR = 360 - 2 * this.aR;
        this.aR = 180 + this.aR;
        this.xStopcock = this.xTube + (this.tubeLength - this.stopcockDia) / 2;
        this.yStopcock = this.yTube - this.stopcockBorder;
        _x[0] = this.xStopcock;
        _y[0] = this.yStopcock;
        _x[1] = this.xStopcock + this.stopcockDia;
        _y[1] = this.yStopcock;
        _x[2] = this.xStopcock + (int)Math.round(17.0 * (double)this.stopcockDia / 20.0);
        _y[2] = this.yStopcock + this.tubeWidth + 2 * this.stopcockBorder;
        _x[3] = this.xStopcock + (int)Math.round(3.0 * (double)this.stopcockDia / 20.0);
        _y[3] = this.yStopcock + this.tubeWidth + 2 * this.stopcockBorder;
        _x[4] = this.xStopcock;
        _y[4] = this.yStopcock;
        this.stopcock = new Polygon(_x, _y, 5);
        this.xClosed = this.xStopcock;
        this.yClosed = this.yStopcock - this.stopcockDia;
        this.xOpen = this.xStopcock - (this.stopcockWidth - this.stopcockDia) / 2;
        this.yOpen = this.yClosed;
        this.xHole = this.xClosed + (this.stopcockDia - this.diaHole) / 2;
        this.yHole = this.yStopcock + this.stopcockBorder + (this.tubeWidth - this.diaHole) / 2;
        this.isSet = true;
        this.repaint();
    }

    private void setDefaults() {
        this.tubeLength = 20;
        this.tubeWidth = 8;
        this.stopcockDia = 10;
        this.stopcockWidth = 16;
        this.diaHole = 4;
        this.stopcockBorder = 3;
    }
}

