/*
 * Decompiled with CFR 0.152.
 */
package bulb;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Bulb
extends Applet {
    boolean isStandalone = false;
    private Color colorBkg = null;
    private Color colorGas = null;
    private int dia = 0;
    private int tubeLength = 40;
    private int tubeWidth = 8;
    private int stopcockDia = 10;
    private int stopcockWidth = 16;
    private int diaHole = 4;
    private int stopcockBorder = 3;
    private double volume = 1.0;
    private boolean isSet = false;
    private boolean isOpen = false;
    private Rectangle bounds = null;
    private int xBulb;
    private int yBulb;
    private int xTube;
    private int yTube;
    private int angle;
    private int arc;
    private int xStopcock;
    private int yStopcock;
    private int xClosed;
    private int yClosed;
    private int xOpen;
    private int yOpen;
    private int xHole;
    private int yHole;
    private Polygon stopcock;
    private int hLiquid;
    private Color liquidColor = new Color(255, 255, 255);
    private boolean showLiquid = false;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.colorGas = Color.decode(this.getParameter("GasColor", "#A0FFFF"));
        }
        catch (NumberFormatException e) {
            this.colorGas = new Color(160, 255, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorGas = new Color(160, 255, 255);
        }
        try {
            this.colorBkg = Color.decode(this.getParameter("BGColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBkg = null;
        }
        try {
            this.dia = Integer.parseInt(this.getParameter("Diameter", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.tubeLength = Integer.parseInt(this.getParameter("TubeLength", "40"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.tubeLength <= 0) {
            this.tubeLength = 40;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void start() {
        this.setup();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Bulb.class  version 1.1  Copyright 2000  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGColor", "String", "Background Color"}, {"Diameter", "int", "Bulb Diameter in pixels"}, {"GasColor", "String", "Color of gas"}, {"TubeLength", "int", "Length of Tube in pixels"}};
        return pinfo;
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            g.setColor(this.colorGas);
            g.fillOval(this.xBulb, this.yBulb, this.dia, this.dia);
            if (this.isOpen) {
                g.fillRect(this.xTube, this.yTube, this.tubeWidth, this.tubeLength);
            } else {
                g.fillRect(this.xTube, this.yStopcock + this.stopcockBorder, this.tubeWidth, this.stopcockWidth + this.stopcockBorder);
            }
            if (this.showLiquid) {
                g.setColor(this.liquidColor);
                double _r = (double)this.dia / 2.0;
                double _r2 = _r * _r;
                int _xBulb = this.xBulb + this.dia / 2 + 1;
                int _yBulb = this.yBulb + this.dia / 2 + 1;
                for (int i = 0; i <= this.hLiquid; ++i) {
                    double _z = -_r + (double)i;
                    int _zz = (int)Math.ceil(_z);
                    int _x = (int)Math.floor(Math.sqrt(_r2 - _z * _z));
                    g.drawLine(_xBulb - _x, _yBulb - _zz, _xBulb + _x - 1, _yBulb - _zz);
                }
            }
            g.setColor(Color.black);
            g.drawArc(this.xBulb, this.yBulb, this.dia, this.dia, this.angle, this.arc);
            g.drawLine(this.xTube, this.yTube, this.xTube, this.yTube + this.tubeLength);
            g.drawLine(this.xTube + this.tubeWidth, this.yTube, this.xTube + this.tubeWidth, this.yTube + this.tubeLength);
            g.setColor(this.colorBkg);
            g.fillPolygon(this.stopcock);
            if (this.isOpen) {
                g.setColor(this.colorGas);
                g.fillRect(this.xHole, this.yTube, this.diaHole, this.tubeLength);
                g.setColor(Color.black);
                g.drawOval(this.xOpen, this.yOpen, this.stopcockDia, this.stopcockWidth);
            } else {
                g.setColor(Color.black);
                g.drawOval(this.xClosed, this.yClosed, this.stopcockDia, this.stopcockDia);
                g.drawOval(this.xHole, this.yHole, this.diaHole, this.diaHole);
            }
            g.drawPolygon(this.stopcock);
        }
    }

    public void setDiameter(int _diameter) {
        this.dia = _diameter < 0 ? 0 : _diameter;
        this.isOpen = false;
        this.setup();
    }

    public void setGasColor(String _color) {
        Color _colorGas;
        try {
            _colorGas = Color.decode(_color);
        }
        catch (NumberFormatException e) {
            _colorGas = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            _colorGas = null;
        }
        if (_colorGas != null) {
            this.colorGas = _colorGas;
        }
        this.repaint();
    }

    public void setGasColor(int _red, int _green, int _blue) {
        if (_red < 0 || _red > 255) {
            return;
        }
        if (_green < 0 || _green > 255) {
            return;
        }
        if (_blue < 0 || _blue > 255) {
            return;
        }
        this.colorGas = new Color(_red, _green, _blue);
        this.repaint();
    }

    public void setLiquidColor(int _red, int _green, int _blue) {
        this.liquidColor = new Color(_red, _green, _blue);
    }

    public void setLiquidFraction(double _fraction) {
        double _root = 2.0;
        double _rLow = -1.0;
        double _rHigh = 1.0;
        double _froot = 2.0;
        if (_fraction <= 0.0) {
            _root = -1.0;
        } else if (_fraction >= 1.0) {
            _root = 1.0;
        } else if (_fraction == 0.5) {
            _root = 0.0;
        } else if (_fraction < 0.5) {
            _rHigh = 0.0;
        } else {
            _rLow = 0.0;
        }
        if (_root == 2.0) {
            while (Math.abs(_froot - _fraction) > 0.001) {
                _root = (_rLow + _rHigh) / 2.0;
                _froot = 0.25 * (1.0 + _root) * (1.0 + _root) * (2.0 - _root);
                if (_froot >= _fraction) {
                    _rHigh = _root;
                    continue;
                }
                _rLow = _root;
            }
        }
        this.hLiquid = (int)Math.round((1.0 + _root) * (double)this.dia / 2.0);
    }

    public void setShowLiquid(boolean _showLiquid) {
        this.showLiquid = _showLiquid;
        this.repaint();
    }

    public void setStopcockState(boolean _state) {
        this.isOpen = _state;
        this.repaint();
    }

    private void setup() {
        int[] _x = new int[5];
        int[] _y = new int[5];
        this.bounds = this.getBounds();
        if (this.stopcockWidth >= this.tubeLength || this.stopcockDia >= this.stopcockWidth || this.diaHole >= this.tubeWidth) {
            System.out.println("Bulb.class:  Invalid Stopcock and Tube Parameter(s);  resetting values ...");
            this.setDefaults();
        }
        if (this.dia >= this.bounds.width) {
            this.dia = 0;
        }
        if (this.dia + this.tubeLength >= this.bounds.height) {
            this.dia = 0;
        }
        if (this.dia == 0) {
            this.dia = this.bounds.width < this.bounds.height - this.tubeLength ? this.bounds.width - 1 : this.bounds.height - this.tubeLength - 1;
        }
        if (this.colorBkg == null) {
            this.colorBkg = this.getBackground();
        } else {
            this.setBackground(this.colorBkg);
        }
        this.xBulb = (this.bounds.width - this.dia) / 2;
        this.yBulb = this.bounds.height - this.dia - 1;
        this.xTube = (this.bounds.width - this.tubeWidth) / 2;
        this.yTube = this.bounds.height - this.dia - this.tubeLength;
        this.angle = (int)Math.round(180.0 * Math.atan((double)this.tubeWidth / (double)this.dia) / Math.PI);
        this.arc = 360 - 2 * this.angle;
        this.angle = 90 + this.angle;
        this.xStopcock = this.xTube + this.tubeWidth + this.stopcockBorder;
        this.yStopcock = this.bounds.height - this.dia - this.stopcockWidth - this.stopcockBorder;
        _x[0] = this.xStopcock;
        _y[0] = this.yStopcock;
        _x[1] = this.xStopcock;
        _y[1] = this.yStopcock + this.stopcockDia;
        _x[2] = this.xStopcock - this.tubeWidth - 2 * this.stopcockBorder;
        _y[2] = this.yStopcock + (int)Math.round(17.0 * (double)this.stopcockDia / 20.0);
        _x[3] = this.xStopcock - this.tubeWidth - 2 * this.stopcockBorder;
        _y[3] = this.yStopcock + (int)Math.round(3.0 * (double)this.stopcockDia / 20.0);
        _x[4] = this.xStopcock;
        _y[4] = this.yStopcock;
        this.stopcock = new Polygon(_x, _y, 5);
        this.xClosed = this.xStopcock;
        this.yClosed = this.yStopcock;
        this.xOpen = this.xStopcock;
        this.yOpen = this.yClosed - (this.stopcockWidth - this.stopcockDia) / 2;
        this.xHole = this.xTube + (this.tubeWidth - this.diaHole) / 2;
        this.yHole = this.yClosed + (this.stopcockDia - this.diaHole) / 2;
        this.isSet = true;
        this.repaint();
    }

    private void setDefaults() {
        this.tubeLength = 40;
        this.tubeWidth = 8;
        this.stopcockDia = 10;
        this.stopcockWidth = 16;
        this.diaHole = 4;
        this.stopcockBorder = 3;
    }
}

