/*
 * Decompiled with CFR 0.152.
 */
package balance;

import balance.DataFormat;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataListener;
import edu.davidson.tools.SDataSource;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;

public class Balance
extends SApplet
implements SDataListener {
    boolean isStandalone = false;
    private int wBody;
    private int hBody;
    private int wPan;
    private double mass;
    private Color colorBkg = null;
    private Color colorPan = null;
    private Color colorBody = null;
    private int unitIn = 0;
    private int unitOut = 0;
    private double[][] conv = new double[][]{{1.0, 1000.0, 0.001, 0.03527, 0.002204585}, {0.001, 1.0, 1.0E-6, 3.527E-5, 2.204585E-6}, {1000.0, 1000000.0, 1.0, 35.27, 2.204585}, {28.35, 28350.0, 0.02835, 1.0, 0.0625}, {453.6, 453600.0, 0.4536, 16.0, 1.0}};
    private String sUnit = "g";
    private int len;
    private int prec;
    private double maxMass = 100.0;
    private double stdev = 0.0;
    private Random rnd = new Random();
    private double tareMass = 0.0;
    private int panHeight = 20;
    private boolean isSet = false;
    private Rectangle bounds = null;
    private Graphics graphics = null;
    private Polygon pan;
    private int hPan;
    private int panBevel;
    private int xBody;
    private int yBody;
    private int xPost;
    private int yPost;
    private int wPost;
    private int hPost;
    private int xFootL;
    private int xFootR;
    private int yFoot;
    private int wFoot;
    private Font font;
    private FontMetrics fontMetrics;
    private DataFormat dataFormat = new DataFormat();
    private int xMass;
    private int yMass;
    private int wMass;
    private int hMass;
    private int xDisplay;
    private int yDisplay;
    private int wDisplay;
    private int hDisplay;
    private int xButton;
    private int yButton;
    private int wButton;
    private int hButton;
    private Button tareButton = new Button("Tare");

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (((Applet)((Object)this)).getParameter(key) != null ? ((Applet)((Object)this)).getParameter(key) : def);
    }

    public Balance() {
        SApplet.addDataListener((Object)((Object)this));
    }

    public void init() {
        int _scale;
        int _prec;
        String _unitOutput;
        String _unitInput;
        try {
            this.colorBkg = Color.decode(this.getParameter("BGColor", ""));
        }
        catch (NumberFormatException e) {
            this.colorBkg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBkg = null;
        }
        try {
            this.colorPan = Color.decode(this.getParameter("PanColor", "#C0C0C0"));
        }
        catch (NumberFormatException e) {
            this.colorPan = new Color(192, 192, 192);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorPan = new Color(192, 192, 192);
        }
        try {
            this.colorBody = Color.decode(this.getParameter("BodyColor", "#E0C000"));
        }
        catch (NumberFormatException e) {
            this.colorBody = new Color(224, 192, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.colorBody = new Color(224, 192, 0);
        }
        try {
            this.wBody = Integer.parseInt(this.getParameter("BodyWidth", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.wBody = 0;
        }
        if (this.wBody < 0) {
            this.wBody = 0;
        }
        try {
            this.hBody = Integer.parseInt(this.getParameter("BodyHeight", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.hBody = 0;
        }
        if (this.hBody < 0) {
            this.hBody = 0;
        }
        try {
            this.wPan = Integer.parseInt(this.getParameter("PanWidth", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.wPan = 0;
        }
        if (this.wPan < 0) {
            this.wPan = 0;
        }
        try {
            this.mass = Double.valueOf(this.getParameter("Mass", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mass = 0.0;
        }
        try {
            this.stdev = Double.valueOf(this.getParameter("StandardDeviation", "0.0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stdev = 0.0;
        }
        this.stdev = Math.abs(this.stdev);
        try {
            _unitInput = this.getParameter("InputUnit", "gram");
        }
        catch (Exception e) {
            e.printStackTrace();
            _unitInput = "gram";
        }
        try {
            _unitOutput = this.getParameter("DisplayUnit", "gram");
        }
        catch (Exception e) {
            e.printStackTrace();
            _unitOutput = "gram";
        }
        try {
            _prec = Integer.parseInt(this.getParameter("Precision", "2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            _prec = 2;
        }
        try {
            _scale = Integer.parseInt(this.getParameter("Scale", "2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            _scale = 2;
        }
        this.setScale(_scale, _prec);
        this.setUnits(_unitInput, _unitOutput);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ((Container)((Object)this)).setLayout(null);
        this.tareButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Balance.this.tareButton_actionPerformed(e);
            }
        });
        ((Container)((Object)this)).add(this.tareButton);
    }

    public void start() {
        this.setup();
        this.graphics = ((Component)((Object)this)).getGraphics();
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Balance.class  version 1.0  Copyright 2000  David N. Blauch";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"BGColor", "String", "Integer value for the background color"}, {"BodyColor", "String", "Integer value for the color of the body"}, {"BodyHeight", "int", "Height in pixels of the body"}, {"BodyWidth", "int", "Width in pixels of the balance body"}, {"DisplayUnit", "String", "Unit for displayed masses"}, {"InputUnit", "String", "Unit for input masses"}, {"Mass", "double", "Mass "}, {"PanColor", "String", "Integer value for the color of the pan"}, {"PanWidth", "int", "Width in pixels of the pan"}, {"Precision", "int", "Number of decimal places displayed"}, {"Scale", "int", "Maximum mass is 10^scale"}, {"StandardDeviation", "double", "Standard deviation for mass measurements"}};
        return pinfo;
    }

    public void addData(SDataSource ds, int id, double[] xVal, double[] yVal) {
        this.mass = yVal[0];
        this.updateDisplay();
    }

    public void addDatum(SDataSource ds, int id, double xVal, double yVal) {
        this.mass = yVal;
        this.updateDisplay();
    }

    public void clearSeries(int id) {
    }

    public void deleteSeries(int id) {
    }

    public SApplet getOwner() {
        return this;
    }

    public void paint(Graphics g) {
        if (this.isSet) {
            g.setColor(this.colorPan);
            g.fillPolygon(this.pan);
            g.fillRect(this.xPost, this.yPost, this.wPost, this.hPost);
            g.setColor(this.colorBody);
            g.fillRoundRect(this.xBody, this.yBody, this.wBody, this.hBody, this.hPost, this.hPost);
            g.setColor(Color.black);
            g.drawPolygon(this.pan);
            g.drawRect(this.xPost, this.yPost, this.wPost, this.hPost);
            g.drawRoundRect(this.xBody, this.yBody, this.wBody, this.hBody, this.hPost, this.hPost);
            g.fillArc(this.xFootL, this.yFoot, this.wFoot, this.wFoot, 180, 180);
            g.fillArc(this.xFootR, this.yFoot, this.wFoot, this.wFoot, 180, 180);
            g.setColor(Color.lightGray);
            g.fillRect(this.xDisplay, this.yDisplay, this.wDisplay, this.hDisplay);
            g.setColor(Color.white);
            g.drawLine(this.xDisplay, this.yDisplay, this.xDisplay + this.wDisplay, this.yDisplay);
            g.drawLine(this.xDisplay, this.yDisplay, this.xDisplay, this.yDisplay + this.hDisplay);
            g.drawLine(this.xDisplay - 1, this.yDisplay - 1, this.xDisplay + this.wDisplay + 1, this.yDisplay - 1);
            g.drawLine(this.xDisplay - 1, this.yDisplay - 1, this.xDisplay - 1, this.yDisplay + this.hDisplay + 1);
            g.setColor(Color.darkGray);
            g.drawLine(this.xDisplay, this.yDisplay + this.hDisplay, this.xDisplay + this.wDisplay, this.yDisplay + this.hDisplay);
            g.drawLine(this.xDisplay + this.wDisplay, this.yDisplay, this.xDisplay + this.wDisplay, this.yDisplay + this.hDisplay);
            g.setColor(Color.black);
            g.drawLine(this.xDisplay - 1, this.yDisplay + this.hDisplay + 1, this.xDisplay + this.wDisplay + 1, this.yDisplay + this.hDisplay + 1);
            g.drawLine(this.xDisplay + this.wDisplay + 1, this.yDisplay - 1, this.xDisplay + this.wDisplay + 1, this.yDisplay + this.hDisplay + 1);
            this.paintValue(g, this.mass, this.len, this.prec);
        }
    }

    public void setMass(double _mass) {
        this.mass = _mass;
        this.updateDisplay();
    }

    public void setOwner(SApplet owner) {
    }

    public void setScale(int _scale, int _precision) {
        if (_scale < 0) {
            this.len = 0;
            this.maxMass = 1.0;
        } else if (_scale > 3) {
            this.len = 3;
            this.maxMass = 1000.0;
        } else {
            this.len = _scale;
            this.maxMass = Math.pow(10.0, _scale);
        }
        this.prec = _precision < 0 ? 0 : (_precision > 4 ? 4 : _precision);
        this.len += 3 + this.prec;
        this.updateDisplay();
    }

    public void setStandardDeviation(double _stdev) {
        this.stdev = Math.abs(_stdev);
    }

    public void setUnits(String _unitInput, String _unitDisplay) {
        String _value = _unitInput.toLowerCase();
        if (_value.equals("g") || _value.equals("gram") || _value.equals("grams")) {
            this.unitIn = 0;
        } else if (_value.equals("mg") || _value.equals("milligram") || _value.equals("milligrams")) {
            this.unitIn = 1;
        } else if (_value.equals("kg") || _value.equals("kilogram") || _value.equals("kilograms")) {
            this.unitIn = 2;
        } else if (_value.equals("oz") || _value.equals("ounce") || _value.equals("ounces")) {
            this.unitIn = 3;
        } else if (_value.equals("lb") || _value.equals("pound") || _value.equals("pounds")) {
            this.unitIn = 4;
        }
        _value = _unitDisplay.toLowerCase();
        if (_value.equals("g") || _value.equals("gram") || _value.equals("grams")) {
            this.unitOut = 0;
            this.sUnit = " g";
        } else if (_value.equals("mg") || _value.equals("milligram") || _value.equals("milligrams")) {
            this.unitOut = 1;
            this.sUnit = " mg";
        } else if (_value.equals("kg") || _value.equals("kilogram") || _value.equals("kilograms")) {
            this.unitOut = 2;
            this.sUnit = " kg";
        } else if (_value.equals("oz") || _value.equals("ounce") || _value.equals("ounces")) {
            this.unitOut = 3;
            this.sUnit = " oz";
        } else if (_value.equals("lb") || _value.equals("pound") || _value.equals("pounds")) {
            this.unitOut = 4;
            this.sUnit = " lb";
        }
        this.updateDisplay();
    }

    public void updateDisplay() {
        if (this.isSet) {
            if (this.graphics == null) {
                this.graphics = ((Component)((Object)this)).getGraphics();
            }
            this.paintValue(this.graphics, this.mass, this.len, this.prec);
        }
    }

    private void paintValue(Graphics g, double _mass, int _len, int _prec) {
        double _m = (_mass - this.tareMass + this.stdev * this.rnd.nextGaussian()) * this.conv[this.unitIn][this.unitOut];
        String _sMass = Math.abs(_m) <= this.maxMass ? String.valueOf(DataFormat.formatDec(_m, _len, _prec)).concat(String.valueOf(this.sUnit)) : "- - - -";
        byte[] _bMass = _sMass.getBytes();
        int _tmp = this.wMass - this.fontMetrics.bytesWidth(_bMass, 0, _bMass.length);
        g.setColor(Color.lightGray);
        g.fillRect(this.xMass, this.yMass - this.fontMetrics.getAscent(), this.wMass, this.hMass);
        g.setColor(Color.black);
        g.drawString(_sMass, this.xMass + _tmp, this.yMass);
    }

    private void setup() {
        int[] _x = new int[5];
        int[] _y = new int[5];
        char[] _tare = new char[]{'T', 'a', 'r', 'e'};
        char[] _mass = new char[]{'-', '0', '0', '0', '0', '.', '0', '0', '0', '0', ' ', 'o', 'z'};
        this.bounds = ((Component)((Object)this)).getBounds();
        if (this.colorBkg == null) {
            this.colorBkg = ((Component)((Object)this)).getBackground();
        } else {
            ((Component)((Object)this)).setBackground(this.colorBkg);
        }
        if (2 * this.hPan + this.hBody > this.bounds.height) {
            this.hPan = 0;
            this.hBody = 0;
        }
        if (this.hPan == 0 && this.hBody == 0) {
            this.hPan = this.bounds.height / 7;
            this.hPost = this.hPan / 2;
            this.wFoot = this.hPan;
            this.hBody = 5 * this.hPan;
        } else if (this.hPan == 0) {
            this.hPan = (this.bounds.height - this.hBody) / 2;
            this.hPost = this.hPan / 2;
            this.wFoot = this.hPan;
        } else if (this.hBody == 0) {
            this.hPost = this.hPan / 2;
            this.wFoot = this.hPan;
            this.hBody = 5 * this.hPan;
            if (2 * this.hPan + this.hBody >= this.bounds.height) {
                this.hBody = this.bounds.height - 2 * this.hPan;
            }
        }
        if (this.wBody >= this.bounds.width || this.wBody == 0) {
            this.wBody = this.bounds.width - 1;
        }
        if (this.wPan >= this.bounds.width || this.wPan == 0) {
            this.wPan = this.wBody * 4 / 5;
        }
        this.panBevel = this.hPan / 3;
        this.wPost = this.wPan / 6;
        _x[0] = (this.bounds.width - this.wPan) / 2;
        _y[0] = this.hPan;
        _x[1] = _x[0] + this.wPan;
        _y[1] = this.hPan;
        _x[2] = _x[1] - this.panBevel;
        _y[2] = 0;
        _x[3] = _x[0] + this.panBevel;
        _y[3] = 0;
        _x[4] = _x[0];
        _y[4] = _y[0];
        this.pan = new Polygon(_x, _y, 5);
        this.xPost = (this.bounds.width - this.wPost) / 2;
        this.yPost = this.hPan;
        this.xBody = (this.bounds.width - this.wBody) / 2;
        this.yBody = this.hPan + this.hPost;
        this.xFootL = this.xBody + this.wFoot;
        this.xFootR = this.xBody + this.wBody - 2 * this.wFoot;
        this.yFoot = this.yBody + this.hBody - this.wFoot / 2;
        this.hDisplay = this.hBody / 4;
        this.wDisplay = this.wBody * 3 / 5;
        int _tmp = (this.hBody - 2 * this.hDisplay) / 5;
        if (_tmp < 0) {
            System.out.println("Balance.class:  Insufficient space for display and button.");
            _tmp = 0;
        }
        this.xDisplay = (this.bounds.width - this.wDisplay) / 2;
        this.yDisplay = this.yBody + 2 * _tmp;
        this.hButton = this.hDisplay;
        this.wButton = this.wBody / 5;
        this.xButton = (this.bounds.width - this.wButton) / 2;
        this.yButton = this.yBody + 3 * _tmp + this.hDisplay;
        this.tareButton.setBounds(this.xButton, this.yButton, this.wButton, this.hButton);
        this.wMass = 4 * this.wDisplay / 5;
        this.hMass = 4 * this.hDisplay / 5;
        this.font = ((Component)((Object)this)).getFont();
        this.fontMetrics = ((Component)((Object)this)).getFontMetrics(this.font);
        _tmp = this.font.getSize();
        while (this.fontMetrics.charsWidth(_mass, 0, _mass.length) < this.wMass && this.fontMetrics.getHeight() < this.hMass) {
            this.font = new Font(this.font.getName(), this.font.getStyle(), ++_tmp);
            this.fontMetrics = ((Component)((Object)this)).getFontMetrics(this.font);
        }
        while ((this.fontMetrics.charsWidth(_mass, 0, _mass.length) > this.wMass || this.fontMetrics.getHeight() > this.hMass) && _tmp >= 6) {
            this.font = new Font(this.font.getName(), this.font.getStyle(), --_tmp);
            this.fontMetrics = ((Component)((Object)this)).getFontMetrics(this.font);
        }
        this.wMass = this.fontMetrics.charsWidth(_mass, 0, _mass.length);
        this.hMass = this.fontMetrics.getHeight();
        this.xMass = (this.bounds.width - this.wMass) / 2;
        this.yMass = this.yDisplay + (this.hDisplay + this.hMass) / 2 - this.fontMetrics.getDescent();
        ((Container)((Object)this)).setFont(this.font);
        this.isSet = true;
    }

    void tareButton_actionPerformed(ActionEvent e) {
        this.tareMass = this.mass;
        this.updateDisplay();
    }
}

